<?php

namespace Modules\Sliders\Controllers;

use App\Controllers\Auth\AuthController;


class Sliders extends AuthController
{

  public function initController($request, $response, $logger)
  {
    parent::initController($request, $response, $logger);
  }

  public function index()
  {
    $this->data['title'] = "Sliders";
    $this->data['bcrumb'] = "Slider Dashboard";

    return view('Modules\Sliders\Views\index', $this->data);
  }
  /*** ======================================================================
   * SLIDERS ADD/EDIT/DELETE
   =========================================================================*/
  public function allSlides()
  {
    $this->data['title'] = "All Slides";
    $this->data['bcrumb'] = "Slides";

    $this->data['allslides'] = $this->slidersModel->getAll();
    return view('Modules\Sliders\Views\all_slides', $this->data);
  }
  public function addSlider()
  {
    $this->data['title'] = "Add Slide";
    $this->data['bcrumb'] = "Add Slide";

    $this->data['categories'] = $this->sliderscategoryModel->getAll();
    
    if($this->request->getMethod() == 'POST'){

      $rules = [
        'title' => ['label'=>'Slide Title', 'rules'=>'required'],
        'photo' => [
            'label' => 'Image File',
            'rules' => 'uploaded[photo]'
                . '|is_image[photo]'
                . '|mime_in[photo,image/jpg,image/jpeg,image/gif,image/png,image/webp]'
                . '|max_size[photo,2024]'
        ],
    ];
      if($this->validate($rules))
      {
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));
        $file1 = $this->request->getFile('photo');

          $newName4 = $file1->getRandomName();
          // ensure upload directory exists
          $uploadPath = ROOTPATH . 'media/files';
          if (!file_exists($uploadPath)) {
              mkdir($uploadPath, 0777, true);
          }

          if ($file1->move($uploadPath, $newName4)) {

          // Determine canonical link (if admin selected an existing page/post)
          $selectedId = $this->request->getVar('selected_link_id');
          $linkVal = $this->request->getVar('link');
          if(!empty($selectedId)){
            $sel = $this->postsModel->getPostWithFullDetails($selectedId);
            if(!$sel){
              $sel = $this->postsModel->getSinglePost($selectedId);
            }
            if($sel){
              $linkVal = $sel->menu_link ?? ($sel->slug ?? ($sel->alias ?? $linkVal));
            }
          }

          // Handle background image if uploaded
          $backgroundImg = $this->request->getFile('background-img');
          $backgroundImgName = null;
          if ($backgroundImg && $backgroundImg->isValid() && !$backgroundImg->hasMoved()) {
              $backgroundImgName = $backgroundImg->getRandomName();
              $backgroundImg->move(ROOTPATH . 'media/files', $backgroundImgName);
          }

          $slideData = [
            'title'          => $this->request->getVar("title"),
            'alias'          => $slug,
            'photo'           => $newName4,
            'description'     => $this->request->getVar("description"),
            'category_id'     => $this->request->getVar("category_id"),
            'status'          => $this->request->getVar("status"),
            'link_text'       => $this->request->getVar("link_text"),
            'link_icon'       => $this->request->getVar("link_icon"),
            'link'            => $linkVal,
            'link_2_text'     => $this->request->getVar("link_2_text"),
            'link_2'          => $this->request->getVar("link_2"),
            'link_2_icon'     => $this->request->getVar("link_2_icon"),
            'background-img'  => $backgroundImgName,
            'ordering'        => $this->request->getVar("ordering"),
            'access'          => $this->request->getVar("access"),
            'extra_1'         => $this->request->getVar("extra_1"),
            'extra_2'         => $this->request->getVar("extra_2"),
            'extra_3'         => $this->request->getVar("extra_3"),
            'extra_4'         => $this->request->getVar("extra_4"),
            'service_group'   => $this->request->getVar("service_group") ?? 'general',
            'nav_context'     => $this->request->getVar("nav_context") ?? 'personal',
            'template_group'  => $this->request->getVar("template_group") ?? 'default',
            'created_by'      => $this->userdata->user_id,
            ];
              
          if($this->slidersModel->save($slideData))
          {
              // Send notification for slide creation
              $adminmessage = 'New Slide Added: ' . $this->request->getVar("title");
              $notificationType = 'content';
              $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

              session()->setTempdata('success', 'Slide added successfully', 3);
              return redirect()->to('administrator/sliders/all');
          }else{
              session()->setTempdata('error', 'Slide NOT added', 3);
              return redirect()->to('sliders/add');
          }
      }
      }else{
        $this->data['validation'] = $this->validator;
      }
        
    }
    return view('Modules\Sliders\Views\add_slide', $this->data);
  }
  public function editSlider($id = null)
  {
    $this->data['title'] = "Edit Slide";
    $this->data['bcrumb'] = "Edit Slide";

    $this->data['categories'] = $this->sliderscategoryModel->getAll();
    $this->data['myslide'] = $this->slidersModel->where('id', $id)->first($id);

    // Attempt to resolve the slide's link to an existing page/post so we can prefill selection
    $selectedLinkId = null;
    $selectedMeta = null;
    $linkVal = $this->data['myslide']['link'] ?? null;
    if ($linkVal) {
      // Try find by menu_link
      $found = $this->postsModel->where('menu_link', $linkVal)->first();
      if (!$found) {
        // Try slug/alias
        $found = $this->postsModel->where('slug', $linkVal)->orWhere('alias', $linkVal)->first();
      }
      if ($found) {
        $selectedLinkId = $found['id'] ?? null;
        $selectedMeta = [
          'id' => $found['id'] ?? null,
          'title' => $found['title'] ?? ($found['name'] ?? null),
          'menu_link' => $found['menu_link'] ?? null,
          'slug' => $found['slug'] ?? null,
          'alias' => $found['alias'] ?? null,
          'excerpt' => $found['excerpt'] ?? null,
          'photo' => $found['photo'] ?? null,
          'type' => isset($found['content_type_id']) ? ($found['content_type_id'] == 1 ? 'page' : ($found['content_type_id'] == 2 ? 'post' : 'service')) : null,
        ];
      }
    }

    $this->data['selected_link_id'] = $selectedLinkId;
    $this->data['selected_link_meta'] = $selectedMeta;

    return view('Modules\Sliders\Views\edit_slider', $this->data);
  }
  public function updateSlider()
  {
    $this->data['title'] = "Edit Slide";
    $this->data['bcrumb'] = "Edit Slide";

    $id = $this->request->getVar("id");
    $this->data['categories'] = $this->sliderscategoryModel->getAll();
    $this->data['myslide'] = $this->slidersModel->where('id', $id)->first($id);

    if($this->request->getMethod() == 'POST'){

      $rules = [
        'title' => ['label'=>'Slide Title', 'rules'=>'required'],
    ];
    $photoRules = ['photo' => [
        'label' => 'Image File',
        'rules' => 'uploaded[photo]'
          . '|is_image[photo]'
          . '|mime_in[photo,image/jpg,image/jpeg,image/gif,image/png,image/webp]'
          . '|max_size[photo,2024]'
        ],
      ];

      $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));

      if(!$this->validate($rules)){
        $validation = \Config\Services::validation();
        $errors = $validation->getErrors();
        $errorMessage = implode('<br>', $errors);
        session()->setFlashdata('error', $errorMessage, 5);
        return redirect()->to('administrator/sliders/edit/'.$id.'-'.$slug);
      }
      
      // Handle file upload
      $myphoto = $this->request->getFile('photo');
      $sliderPic = $this->slidersModel->where('id', $id)->first($id);
    if ($myphoto->isValid() && !$myphoto->hasMoved()) {
      $newName = $myphoto->getRandomName();

      // ensure upload directory exists
      $uploadPath = ROOTPATH . 'media/files';
      if (!file_exists($uploadPath)) {
        mkdir($uploadPath, 0777, true);
      }

      // delete old image if exists
      if (!empty($sliderPic['photo'])) {
        $existingFile = basename($sliderPic['photo']);
        $oldPath = $uploadPath . DIRECTORY_SEPARATOR . $existingFile;
        if (file_exists($oldPath)) {
          @unlink($oldPath);
        }
      }

      if ($myphoto->move($uploadPath, $newName)) {
        $nwn1 = $newName;
      } else {
        $nwn1 = $sliderPic['photo'];
      }
    } else {
      // keep existing filename
      $nwn1 = $sliderPic['photo'];
    }

      // Determine canonical link (if admin selected an existing page/post)
      $selectedId = $this->request->getVar('selected_link_id');
      $linkVal = $this->request->getVar('link');
      if(!empty($selectedId)){
        $sel = $this->postsModel->getPostWithFullDetails($selectedId);
        if(!$sel){
          $sel = $this->postsModel->getSinglePost($selectedId);
        }
        if($sel){
          $linkVal = $sel->menu_link ?? ($sel->slug ?? ($sel->alias ?? $linkVal));
        }
      }

      $slideData = 
      [
          'title'          => $this->request->getVar("title"),
          'alias'          => $slug,
          'photo'           =>$nwn1,
          'description'     => $this->request->getVar("description"), 
          'category_id'     => $this->request->getVar("category_id"), 
          'status'          => $this->request->getVar("status"),
          'link_text'       => $this->request->getVar("link_text"),
          'link'            => $linkVal,
          'link_2_text'     => $this->request->getVar("link_2_text"),
          'link_2'          => $this->request->getVar("link_2"),
          "ordering"        => $this->request->getVar("ordering"), 
          'access'          => $this->request->getVar("access"),
          'extra_1'         => $this->request->getVar("extra_1"),
          'extra_2'         => $this->request->getVar("extra_2"),
          'extra_3'         => $this->request->getVar("extra_3"),
          'extra_4'         => $this->request->getVar("extra_4"),
          'updated_by'      => $this->userdata->user_id,
          'updated_at'      => date("Y-m-d H:i:s"),
        ];

        if($this->slidersModel->update($id, $slideData))
        {
            // Send notification for slide update
            $adminmessage = 'Slide Updated: ' . $this->request->getVar("title");
            $notificationType = 'content';
            $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

            session()->setTempdata('success', 'Slide Updated successfully', 3);
            return redirect()->to('administrator/sliders/all');
        }else{
            session()->setTempdata('error', 'Slide NOT updated', 3);
            return redirect()->to('administrator/sliders/all');
        } 
    }
    return view('Modules\Sliders\Views\edit_slider', $this->data);
  }
  public function delSlide($id)
  {
    $slide = $this->slidersModel->where('id', $id)->first($id);
    if ($slide && !empty($slide['photo'])) {
        $file = ROOTPATH . 'media/files/' . $slide['photo'];
        if (file_exists($file)) {
            @unlink($file);
        }
    }
    $this->slidersModel->where('id', $id)->delete($id);

    if($this->request->isAJAX())
    {
      // Send notification for slide deletion (AJAX)
      $slideTitle = $slide['title'] ?? 'Unknown Slide';
      $adminmessage = 'Slide Deleted: ' . $slideTitle;
      $notificationType = 'content';
      $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

      $response = [
        'success' => true,
        'msg' => 'Slide deleted successfully',
      ];
      return $this->response->setJSON($response);
    }else{
      // Send notification for slide deletion (non-AJAX)
      $slideTitle = $slide['title'] ?? 'Unknown Slide';
      $adminmessage = 'Slide Deleted: ' . $slideTitle;
      $notificationType = 'content';
      $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

      session()->setTempdata('success', 'Slide deleted successfully', 3);
      return redirect()->to('administrator/sliders/all');
    }
  }
  /*** ======================================================================
   * SLIDER CATEGORY ADD/EDIT/DELETE
   =========================================================================*/
   public function sliderCategory()
   {
    $this->data['title'] = "Slider Categories";
    $this->data['bcrumb'] = "Slider Categories";

    $this->data['slider_categories'] = $this->sliderscategoryModel->getAll();
    return view('Modules\Sliders\Views\category', $this->data);
   }
   public function addCategory()
  {    
    $this->data['slider_categories'] = $this->sliderscategoryModel->getAll();
  
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'name' => ['label'=>'Category Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
          $slideData = [
              'name'          => $this->request->getVar("name"),
              'alias'         => $slug,
              'description'   => $this->request->getVar("description"),
              'created_by'    => $this->userdata->user_id,
          ];
          
          if($this->sliderscategoryModel->save($slideData))
          {
              // Send notification for category creation
              $adminmessage = 'New Slider Category Created: ' . $this->request->getVar("name");
              $notificationType = 'content';
              $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

              session()->setTempdata('success', 'Category added successfully', 3);
              return redirect()->to('administrator/sliders/categories');
          }else{
              session()->setTempdata('error', 'Category NOT added', 3);
              return redirect()->to('administrator/sliders/categories');
          }
      }else{
        session()->setTempdata('error', 'Category Name can not be empty', 3);
        return redirect()->to('administrator/sliders/categories');
      }
    }
    return view('Modules\sliders\Views\category', $this->data);
  }
  public function editCategory($id = null)
  {
    $this->data['title'] = "Slider Categories";
    $this->data['bcrumb'] = "Slider Categories";

    $this->data['slider_categories'] = $this->sliderscategoryModel->getAll();
    $this->data['singleCategory'] = $this->sliderscategoryModel->where('id', $id)->first($id);

    return view('Modules\Sliders\Views\category', $this->data);
  }
  public function updateCategory()
  {
    $this->data['title'] = "Slider Categories";
    $this->data['bcrumb'] = "Slider Categories";

    $this->data['slider_categories'] = $this->sliderscategoryModel->getAll();
   
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'name' => ['label'=>'Category Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {

          $id = $this->request->getVar("id");
          $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
          $productData = [
              'name'          => $this->request->getVar("name"),
              'alias'         => $slug,
              'description'   => $this->request->getVar("description"),
              'updated_by'    => $this->userdata->user_id,
              'updated_at'    => date("Y-m-d H:i:s"),
          ];
          
          if($this->sliderscategoryModel->update($id, $productData))
          {
              // Send notification for category update
              $adminmessage = 'Slider Category Updated: ' . $this->request->getVar("name");
              $notificationType = 'content';
              $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

              session()->setTempdata('success', 'Category updated successfully', 3);
              return redirect()->to('administrator/sliders/categories');
          }else{
              session()->setTempdata('error', 'Category NOT updated', 3);
              return redirect()->to('administrator/sliders/categories');
          }
      }else{
        session()->setTempdata('error', 'Category Name can not be empty', 3);
        return redirect()->to('administrator/sliders/categories');
      }
    }
    return view('Modules\Sliders\Views\category', $this->data);
  }
  public function delCategory($id)
    {
        $category = $this->sliderscategoryModel->find($id);
        $this->sliderscategoryModel->where('id', $id)->delete($id);

        if($this->request->isAJAX())
        {
          // Send notification for category deletion (AJAX)
          $categoryName = $category ? $category['name'] : 'Unknown Category';
          $adminmessage = 'Slider Category Deleted: ' . $categoryName;
          $notificationType = 'content';
          $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

          $response = [
            'error' => true,
            'msg' =>'Category deleted successfully',	   
          ];
          return $this->response->setJSON($response);
        }else{
          // Send notification for category deletion (non-AJAX)
          $categoryName = $category ? $category['name'] : 'Unknown Category';
          $adminmessage = 'Slider Category Deleted: ' . $categoryName;
          $notificationType = 'content';
          $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

          session()->setFlashdata('success', 'Category deleted successfully', 3);
          return redirect()->to('administrator/sliders/categories');
        }
    }

    // Bulk operations for slides
    public function bulkSlideAction()
    {
        if ($this->request->getMethod() == 'POST') {
            $action = $this->request->getVar('action');
            $slideIds = $this->request->getVar('slide_ids');

            if (empty($slideIds)) {
                if($this->request->isAJAX()) {
                    return $this->response->setJSON(['success' => false, 'message' => 'No slides selected']);
                } else {
                    session()->setTempdata('error', 'No slides selected', 3);
                    return redirect()->to('administrator/sliders/all');
                }
            }

            $successCount = 0;
            $failedCount = 0;

            foreach ($slideIds as $slideId) {
                $slide = $this->slidersModel->find($slideId);
                if (!$slide) {
                    $failedCount++;
                    continue;
                }

                switch ($action) {
                    case 'activate':
                        if ($this->slidersModel->update($slideId, ['status' => 1])) {
                            $successCount++;
                        } else {
                            $failedCount++;
                        }
                        break;
                    
                    case 'deactivate':
                        if ($this->slidersModel->update($slideId, ['status' => 0])) {
                            $successCount++;
                        } else {
                            $failedCount++;
                        }
                        break;
                    
                    case 'delete':
                        // Delete slide image and record
                        if ($slide && !empty($slide['photo'])) {
                            $file = ROOTPATH . 'media/files/' . $slide['photo'];
                            if (file_exists($file)) {
                                @unlink($file);
                            }
                        }
                        if ($this->slidersModel->delete($slideId)) {
                            $successCount++;
                        } else {
                            $failedCount++;
                        }
                        break;
                    
                    default:
                        $failedCount++;
                        break;
                }
            }

            if ($successCount > 0) {
                // Send notification for bulk action
                $adminmessage = 'Bulk Slide Action: ' . $action . ' performed on ' . $successCount . ' slides';
                $notificationType = 'content';
                $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

                if($this->request->isAJAX()) {
                    return $this->response->setJSON([
                        'success' => true,
                        'message' => $successCount . ' slides processed successfully'
                    ]);
                } else {
                    session()->setTempdata('success', $successCount . ' slides processed successfully', 3);
                }
            }

            if ($failedCount > 0) {
                if($this->request->isAJAX()) {
                    return $this->response->setJSON([
                        'success' => false,
                        'message' => $failedCount . ' slides failed to process'
                    ]);
                } else {
                    session()->setTempdata('error', $failedCount . ' slides failed to process', 3);
                }
            }
        }

        return redirect()->to('administrator/sliders/all');
    }

    // Bulk operations for categories
    public function bulkCategoryAction()
    {
        if ($this->request->getMethod() == 'POST') {
            $action = $this->request->getVar('action');
            $categoryIds = $this->request->getVar('category_ids');

            if (empty($categoryIds)) {
                if($this->request->isAJAX()) {
                    return $this->response->setJSON(['success' => false, 'message' => 'No categories selected']);
                } else {
                    session()->setTempdata('error', 'No categories selected', 3);
                    return redirect()->to('administrator/sliders/categories');
                }
            }

            $successCount = 0;
            $failedCount = 0;

            foreach ($categoryIds as $categoryId) {
                $category = $this->sliderscategoryModel->find($categoryId);
                if (!$category) {
                    $failedCount++;
                    continue;
                }

                switch ($action) {
                    case 'delete':
                        if ($this->sliderscategoryModel->delete($categoryId)) {
                            $successCount++;
                        } else {
                            $failedCount++;
                        }
                        break;
                    
                    default:
                        $failedCount++;
                        break;
                }
            }

            if ($successCount > 0) {
                // Send notification for bulk action
                $adminmessage = 'Bulk Slider Category Action: ' . $action . ' performed on ' . $successCount . ' categories';
                $notificationType = 'content';
                $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

                if($this->request->isAJAX()) {
                    return $this->response->setJSON([
                        'success' => true,
                        'message' => $successCount . ' categories processed successfully'
                    ]);
                } else {
                    session()->setTempdata('success', $successCount . ' categories processed successfully', 3);
                }
            }

            if ($failedCount > 0) {
                if($this->request->isAJAX()) {
                    return $this->response->setJSON([
                        'success' => false,
                        'message' => $failedCount . ' categories failed to process'
                    ]);
                } else {
                    session()->setTempdata('error', $failedCount . ' categories failed to process', 3);
                }
            }
        }

        return redirect()->to('administrator/sliders/categories');
    }
}