<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <div>
                <?php if(session()->getTempdata('error')):?>
                <div class="alert alert-danger">  <?= session()->getTempdata('error');?></div>
                <?php endif;?>
                <?php if(session()->getTempdata('success')):?>
                <div class="alert alert-success">  <?= session()->getTempdata('success');?></div>
                <?php endif;?>
                        <?php if(session()->getTempdata('warning')):?>
                <div class="alert alert-warning">  <?= session()->getTempdata('warning');?></div>
                <?php endif;?> 					
            </div>
            <?php if(isset($validation)): ?>
                <div class="alert alert-danger">
                    <?= $validation->listErrors()?>
                </div>
            <?php endif;?>
            <!-- End of Notification Messages !-->

    <div class="d-md-flex align-items-start  mb-3 mt-3">
        <div class="nav flex-column nav-pills me-3 col-lg-2 col-md-2 col-12 align-items-start" >
            <ul class="btabs nav nav-tabs" id="myTab">
                <!-- Account Settings !-->
                <li class="nav-item">
                    <a href="#v-pills-gperms"  class="nav-link active" data-bs-toggle="tab">Group Permissions</a>
                </li><!-- Group Permissions !-->
                <li class="nav-item">
                    <a href="#v-pills-perms"  class="nav-link" data-bs-toggle="tab">All Permissions</a>
                </li><!-- Permissions !-->
                <li class="nav-item">
                    <a href="#v-pills-sect"  class="nav-link" data-bs-toggle="tab">Module Sections</a>
                </li><!-- Module Sections !-->
                <li class="nav-item">
                    <a href="#v-pills-groups" class="nav-link" data-bs-toggle="tab">User Groups</a>
                </li><!-- User Groups !-->
            </ul>
        </div><!-- Tab Buttons !-->
        <div class="tab-content mb-3 col-lg-9 col-md-10 col-12" >
            <div id="v-pills-gperms" class="tab-pane fade show active">
                <?= view('Modules\Settings\Views\general\partials\group-permissions-tab') ?>
            </div><!-- Group Permissions !-->
            <div id="v-pills-perms" class="tab-pane fade">
                <?= view('Modules\Settings\Views\general\partials\list-permissions-tab') ?>
            </div><!-- System Permissions !-->
            <div id="v-pills-sect" class="tab-pane fade">
                <?= view('Modules\Settings\Views\general\partials\list-module-section-tab') ?>
            </div><!-- Modules !-->
            <div id="v-pills-groups" class="tab-pane fade">
                <?= view('Modules\Settings\Views\general\partials\list-user-groups-tab') ?>
            </div><!-- Groups !-->
         </div><!-- Tab Content !-->
    </div><!-- Tabs Btn & Content !-->
        </div><!-- col !-->
    </div><!-- Row !-->
</div><!-- container !-->

<!-- Modal !-->
<?= view('Modules\Settings\Views\\general\\modals\\add-permissionsModal') ?>
<?= view('Modules\Settings\Views\\general\\modals\\group-permissionModal') ?>
<?= view('Modules\Settings\Views\\general\\modals\\add-moduleSection') ?>

<script>
    window.csrfTokenName = "<?= csrf_token() ?>";
    window.csrfTokenValue = "<?= csrf_hash() ?>";
    var csrfTokenp = '<?= csrf_hash() ?>';

    $(document).ready(function () {
          $('#perm-list').DataTable();
      });

</script>
<script src="<?= base_url();?>assets/admin_assets/js/modules/settings.js"></script>
<script src="<?= base_url();?>assets/admin_assets/js/modules/permissions.js"></script>
<script src="<?= base_url();?>assets/admin_assets/js/countryselection.js"></script>

<?= $this->endSection(); ?>