<h4 class="p-2">Company Policies <span class="float-sm-end">
    <?php if(has_permission('companysettings.managepolicies')):?>
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#policyModal">Add Policy</button>
    <?php endif;?>
</span></h4>
<div class="table-responsive">
    <table class="table table-sm table-striped" id="permissionTable">
        <thead class="bg-dark text-white" style="font-size:12px;width:100%">
            <tr>
                <th width="5%"></th>
                <th width="10%">Policy</th>
                <th width="65%">Title</th>
                <th width="5%"></th>
            </tr>
        </thead>
        <tbody style="font-size:12px;">
            <?php foreach($policies as $policy):?>
            <tr>
                <td><img src="<?= $policy->photo;?>" alt="Photo" width="50px" class="rounded-circle"></td>
                <td><?= $policy->policy_type;?></td>
                <td><strong><?= $policy->title; ?></strong></td>
                <td>
                    <div class="btn-group">
                        <button  class="btn btn-sm btn-outline-warning rounded-circle me-2" title="View" data-bs-toggle="modal" data-bs-target="#viewpolicyModal<?= $policy->id; ?>">
                            <small><i class="bi bi-eye"></i></small>
                        </button>
                        <!-- View Policy Details Modal !-->
                         <div class="modal fade" id="viewpolicyModal<?= $policy->id; ?>" tabindex="-1" aria-labelledby="viewpolicyModalLabel<?= $policy->id; ?>" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h1 class="modal-title fs-5" id="viewpolicyModalLabel<?= $policy->id; ?>"><?= $policy->title; ?></h1>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <?= nl2br($policy->description); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End View Policy !-->
                    
                        <?php if(has_permission('companysettings.managepolicies')):?>
                        <button  class="btn btn-sm btn-outline-info rounded-circle me-2 edit-policy" data-id="<?= $policy->id; ?>" title="Edit"><small><i class="bi bi-pencil"></i></small>
                            </button>
                        <?php endif;?>
                        <?php if(has_permission('companysettings.deletepolicy')):?>
                        <button  class="btn btn-sm btn-outline-danger rounded-circle delete-policy" onclick="delete_policy(<?= $policy->id; ?>, '<?= $policy->title; ?>')" title="Delete"><small><i class="bi bi-trash"></i></small>
                            </button>
                        <?php endif;?>
                    </div>
                </td>
            </tr>
            <?php endforeach;?>
        </tbody>
    </table>
</div><!-- All permissions !-->