    <?php if(empty($company->id)):?>
        <h4>Company Details <span class="float-sm-end"><button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#companyModal">Add Company</button> </span></h4>
        <div class="alert alert-danger">No company details set.</div>
    <?php else:?>
        <h4 class="mb-3">Company Settings <span class="float-sm-end"><button class="btn btn-sm btn-info text-white edit-company" data-id="<?= $company->id; ?>">Edit Company</button> </span></h4>
    
    <div class="card card-body mb-3">
        <div class="row g-5">
            <!-- <div class="col-sm-5">
              <img src="<?= base_url('media/files/' . $company->photo); ?>" alt="Company Logo" class="img-fluid">
            </div> -->
            <div class="col-sm-5">
    <img src="<?= $company->photo_url; ?>" alt="Company Logo" class="img-fluid rounded">
</div>
            <div class="col-sm-7">
                <div class="row">
                    <div class="col-4 mb-2 fw-bold">Name:</div>
                    <div class="col-8 mb-2"><?= $company->name; ?></div>
                    <div class="col-4 mb-2 fw-bold">Email:</div>
                    <div class="col-8 mb-2"><?= $company->email; ?></div>
                    <div class="col-4 mb-2 fw-bold">Phone:</div>
                    <div class="col-8 mb-2"><?= $company->tel; ?></div>
                    <div class="col-4 mb-2 fw-bold">TIN NO:</div>
                    <div class="col-8 mb-2"><?= $company->tax_id; ?></div>
                     <div class="col-4 mb-2 fw-bold">Currency:</div>
                    <div class="col-8 mb-2">
                        <?= $company->currency_code ? $company->currency_code . ' (' . $company->currency_symbol . ')' : 'N/A'; ?>
                    </div>
                    <div class="col-4 mb-2 fw-bold">WEBSITE:</div>
                    <div class="col-8 mb-2"><?= $company->website ; ?></div>
                </div>
            </div>
        </div><!-- row !-->
    </div><!-- card !-->
    <div class="card card-body mb-3">
    <div class="row g-5">
            <div class="col-sm-5 align-self-center">
                <h4>Address</h4>
            </div>
            <div class="col-sm-7">
                <div class="row">
                    <div class="col-12 mb-2"><?= $company->address_1; ?></div>
                    <div class="col-12 mb-2"><?= $company->address_2; ?></div>
                    <div class="col-4 mb-2 fw-bold">Zip Code:</div>
                    <div class="col-8 mb-2"><?= $company->area_code; ?></div>
                    <div class="col-4 mb-2 fw-bold">City:</div>
                    <div class="col-8 mb-2"><?= $company->city_name; ?></div>
                    <div class="col-4 mb-2 fw-bold">State:</div>
                    <div class="col-8 mb-2"><?= $company->state_name; ?></div>
                    <div class="col-4 mb-2 fw-bold">Country:</div>
                    <div class="col-8 mb-2"><?= $company->country_name; ?></div>
                </div>
            </div>
        </div><!-- row !-->
    </div><!-- card !-->
    <div class="card card-body mb-3">
        <div class="row g-5">
            <div class="col-sm-5 align-self-center">
                <h4>Mission</h4>
            </div>
            <div class="col-sm-7">
                <div class="row">
                    <div class="col-12 mb-2"><?= nl2br($company->mission); ?></div>
                </div>
            </div>
        </div><!-- row !-->
    </div><!-- card !-->
    <div class="card card-body mb-3">
        <div class="row g-5">
            <div class="col-sm-5 align-self-center">
                <h4>Vision</h4>
            </div>
            <div class="col-sm-7">
                <div class="row">
                    <div class="col-12 mb-2"><?= nl2br($company->vision); ?></div>
                </div>
            </div>
        </div><!-- row !-->
    </div><!-- card !-->
    <div class="card card-body mb-3">
        <div class="row g-5">
            <div class="col-sm-5 align-self-center">
                <h4>Core Values</h4>
            </div>
            <div class="col-sm-7">
                <div class="row">
                    <div class="col-12 mb-2"><?= nl2br($company->core_values); ?></div>
                </div>
            </div>
        </div><!-- row !-->
    </div><!-- card !-->
    <div class="card card-body mb-3">
        <div class="row g-5">
            <div class="col-sm-5 align-self-center">
                <h4>Description / About</h4>
            </div>
            <div class="col-sm-7">
                <div class="row">
                    <div class="col-12 mb-2"><?= nl2br($company->description); ?></div>
                </div>
            </div>
        </div><!-- row !-->
    </div><!-- card !-->
<?php endif;?>