<div class="modal fade" id="companyModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="companyModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header border-0 alert-info">
        <h5 class="modal-title fw-bold fs-6" id="companyModalLabel">Set Company Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="alert alert-primary">
          <h4>Importance of Accurate Company Details</h4>
          <p>Dear Administrator,</br>

          Kindly ensure that you enter accurate company information, as these details will be displayed on the About Us page of the website and will also appear on most printed reports and system-generated receipts. <b><i>Please don’t forget to upload the company logo as well.</i></b></p>

          Your attention to detail will help maintain a professional and consistent brand representation.

          Thank you!
        </div>
        <!-- Form !-->
        <form method="POST" id="companyForm" action="<?= base_url('administrator/settings/company'); ?>" enctype="multipart/form-data">
            <?= csrf_field(); ?>
            <input type="hidden" name="id" >
            <div class="row mb-md-3">
              <div class="col-md-5 mb-3">
                <div id="display-image"></div>
                <input type="file" name="photo" class="form-control" accept=".jpg,.png,.jpeg">
              </div>
              <div class="col-md-7 mb-3">
                <div class="row">
                  <div class="col-md-12 mb-2">
                    <label for="name" class="form-label mb-0 fw-bold fs-6">Company Name*</label>
                    <input type="text" name="name" id="name" class="form-control">
                  </div>
                  <div class="col-lg-6 mb-2">
                    <label for="email" class="form-label mb-0 fw-bold fs-6">Official Email*</label>
                    <input type="email" name="email" id="email" class="form-control">
                  </div>
                  <div class="col-lg-6 mb-2">
                    <label for="wb" class="form-label mb-0 fw-bold fs-6">Website</label>
                    <input type="text" name="website" id="wb" class="form-control">
                  </div>
                  <div class="col-md-12 mb-2">
                    <div class="row">
                      <div class="col-md">
                        <label for="tel" class="form-label mb-0 fw-bold">Office Phone*</label>
                        <input type="tel" name="tel" id="tel" class="form-control">
                      </div>
                      <div class="col-md">
                        <label for="tel" class="form-label mb-0 fw-bold fs-6">Mobile Phone</label>
                        <input type="tel" name="mobile" id="tel" class="form-control">
                      </div>
                    </div>
                    
                  </div>
                  <div class="col-md-12 mb-2">
                    <label for="tax" class="form-label mb-0 fw-bold fs-6">Tax ID *</label>
                    <input type="text" name="tax_id" id="tax" class="form-control" placeholder="TIN No.">
                  </div>
                  <div class="col-md-12 mb-2">
                  <label for="currency" class="form-label mb-0 fw-bold fs-6">Default Currency</label>
                  <select name="default_currency_id" id="currency" class="form-select">
                      <option value="">Select Currency</option>
                      <?php foreach($currencies as $currency):?>
                      <option value="<?= $currency['id']; ?>">
                          <?= $currency['currency_code'] . ' - ' . $currency['currency_name'] . ' (' . $currency['currency_symbol'] . ')'; ?>
                      </option>
                      <?php endforeach;?>
                  </select>
              </div>
                </div>
              </div>
            </div><!-- row !-->
            <div class="row mb-md-3">
              <div class="col-md-6 mb-2">
                <label for="add1" class="form-label mb-0 fw-bold fs-6">Address 1*</label>
                <input type="text" name="address_1" class="form-control" id="add1">
              </div>
              <div class="col-md-6 mb-2">
                <label for="add1" class="form-label mb-0 fw-bold fs-6">Address 2</label>
                <input type="text" name="address_2" class="form-control" id="add2">
              </div>
              <div class="col-md-2 mb-2">
                <label for="code" class="form-label mb-0 fw-bold fs-6">Zip Code</label>
                <input type="text" name="area_code" class="form-control" id="code">
              </div>
              <div class="col-md-4 mb-2">
                <label for="country_id" class="form-label  mb-0 fw-bold fs-6">Country*</label>
                <select name="country_id" id="country_id" class="form-select">
                  <option value="">Select --</option>
                  <?php foreach($countries as $country):?>
                    <option value="<?= $country['country_id'] ?>"><?= $country['country_name'];?></option>
                  <?php endforeach;?>
                </select>
              </div>
              <!-- <div class="col-md-3 mb-2">
                <label for="state_id" class="form-label  mb-0 fw-bold fs-6">state</label>
                <select name="state_id" id="state_id" class="form-select">
                  <option value="">-</option>
                  <?php foreach($states ?? [] as $state): ?>
                    <option value="<?= $state['id']; ?>" data-country-id="<?= $state['country_id']; ?>">
                      <?= $state['name']; ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-3 mb-2">
                <label for="city_id" class="form-label  mb-0 fw-bold fs-6">City</label>
                <select name="city_id" id="city_id" class="form-select">
                  <option value="">-</option>
                  <?php foreach($cities ?? [] as $city): ?>
                    <option value="<?= $city['id']; ?>" data-state-id="<?= $city['state_id']; ?>">
                      <?= $city['name']; ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div> -->
            </div><!-- row !-->
            <div class="row mb-md-3">
              <div class="col-lg-6 mb-2">
                <label for="vision" class="form-label mb-0 fw-bold fs-6">Vision</label>
                <textarea name="vision" id="vision" class="form-control" rows="3" placeholder="Provide full company vision - helpful on website"></textarea>
              </div>
              <div class="col-lg-6 mb-2">
                <label for="mission" class="form-label mb-0 fw-bold fs-6">Mission</label>
                <textarea name="mission" id="mission" class="form-control" rows="3" placeholder="Provide full company mission - helpful on website"></textarea>
              </div>
              <div class="col-lg-6 mb-2">
                <label for="obj" class="form-label mb-0 fw-bold fs-6">Objectives</label>
               <textarea name="objectives" id="obj" class="form-control" rows="3" placeholder="List each objective on separate line"></textarea>
              </div>
              <div class="col-lg-6 mb-2">
                <label for="valu" class="form-label mb-0 fw-bold fs-6">Core Values</label>
                <textarea name="core_values" id="valu" class="form-control" rows="3" placeholder="List each values on separate line"></textarea>
              </div>
              <div class="col-md-12 mb-2">
                <label for="decri" class="form-label mb-0 fw-bold fs-6">Description <small class="text-muted fw-normal">(Brief information about the company)</small></label>
                <textarea name="description" id="decri" class="form-control" rows="5"></textarea>
              </div>

              <div class="accordion accordion-flush" id="accordionFlushExample">
                <div class="accordion-item">
                  <h2 class="accordion-header">
                    <button class="accordion-button alert-warning collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                      Add/Edit SOCIALS
                    </button>
                  </h2>
                  <div id="flush-collapseOne" class="accordion-collapse collapse" data-bs-parent="#accordionFlushExample">
                    <div class="accordion-body">
                      <div class="row g-2 p-1">
                        <div class="col-md mb-2">
                          <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-facebook"></i></span>
                            <input type="text" name="facebook" id="fa" class="form-control" placeholder="username">
                          </div>
                        </div>
                        <div class="col-md mb-2">
                          <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-twitter-x"></i></span>
                            <input type="text" name="twitter" id="tw" class="form-control" placeholder="username">
                          </div>
                        </div>
                        <div class="col-md mb-2">
                          <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-linkedin"></i></span>
                            <input type="text" name="linkedin" id="lin" class="form-control" placeholder="username">
                          </div>
                        </div>
                        <div class="col-md mb-2">
                          <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-instagram"></i></span>
                            <input type="text" name="instagram" id="tw" class="form-control" placeholder="username">
                          </div>
                        </div>
                        <div class="col-md mb-2">
                          <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-whatsapp"></i></span>
                            <input type="number" name="whatsapp" id="whats" class="form-control" placeholder="phone">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              
            </div><!-- row !-->
        <!-- End Form !-->
      </div>
      <div class="modal-footer border-0">
        <div class="btn-group w-75">
          <button type="button" class="btn btn-secondary w-25 me-2 rounded" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-danger sbtn w-75 rounded">Update</button>
        </div>
      </div>
      </form>
    </div>
  </div>
</div>