<?php

namespace Modules\Settings\Models;

use CodeIgniter\Model;

class UserGroupPermissionsModel extends Model
{
    protected $table = 'usc_user_group_permissions';
    protected $primaryKey = 'id';

    protected $allowedFields = ['group_id', 'permission_id', 'deleted_at'];

    protected $returnType     = 'object';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getGroupPermissions($groupId)
    {
        return $this->select('usc_permissions.*')
            ->join('usc_permissions', 'usc_permissions.id = usc_user_group_permissions.permission_id')
            ->where('usc_user_group_permissions.deleted_at', null)
            ->where('usc_user_group_permissions.group_id', $groupId)
            ->findAll();
    }

}