<?php

namespace Modules\Settings\Models;

use CodeIgniter\Model;

class PolicySettingsModel extends Model 
{
	
	protected $table      = 'settings_policies';
    protected $primaryKey = 'id ';
	
	protected $allowedFields = ['title', 'policy_type', 'photo',  'description', 'is_active', 'created_by', 'updated_by'];

    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';


    public function getAll()
    {
        $builder = $this->db->table('settings_policies');
        $builder->select('settings_policies.*')
                ->where('deleted_at', null)
                ->orderBy('id', 'Desc');
        return $results = $builder->get()->getResult();
    }
}