<?php

namespace Modules\Settings\Models;

use CodeIgniter\Model;

class PermissionsModel extends Model
{
    protected $table = 'usc_permissions';
    protected $primaryKey = 'id';
    protected $db;

    protected $allowedFields = ['parent_id', 'name', 'module_section_id', 'description', 'module'];
    
    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    protected $returnType     = 'object';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getAll()
    {
        $builder = $this->db->table('usc_permissions as p');
        $builder->select('p.*, pp.name as parent_name, m.name as section_name')
                ->join('usc_permissions as pp', 'pp.id=p.parent_id', 'left')
                ->join('usc_module_sections as m', 'm.id=p.module_section_id', 'left')
                ->where('p.deleted_at', null);
        return $result = $builder->get()->getResult();
    }
    

    public function getByName($name)
    {
        return $this->where('name', $name)->first();
    }

    public function getPermissionsBySection()
    {
        return $this->select('usc_permissions.*, usc_module_sections.name as section_name')
            ->join('usc_module_sections', 'usc_module_sections.id = usc_permissions.module_section_id')
            ->orderBy('usc_module_sections.sort_order', 'ASC')
            ->orderBy('usc_permissions.id', 'ASC')
            ->findAll();
    }
    
    public function getSectionPermissions($sectionId)
    {
        return $this->where('module_section_id', $sectionId)->findAll();
    }

    

}