<?php

namespace Modules\Settings\Models;

use CodeIgniter\Model;
use CodeIgniter\I18n\Time;

class PaymentGatewaysModel extends Model
{
    protected $table = 'payment_gateways';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'gateway_type', 'merchant_id', 'public_key', 'secret_key', 'webhook_url', 'is_test_mode', 'status', 'supported_currencies', 'configuration'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getAll()
    {
        $builder = $this->db->table('payment_gateways');
        $builder->where('deleted_at', null);
        $result = $builder->get()->getResult();
        return $result;
    }


}