<?php

namespace Modules\Settings\Models;

use CodeIgniter\Model;

class CompanySettingsModel extends Model 
{
    protected $table = 'settings_company';
    protected $primaryKey = 'id';
    protected $allowedFields = ['name', 'tel', 'mobile', 'photo', 'default_currency_id', 'tax_id', 'email', 'address_1', 'address_2', 'vision', 'mission', 'objectives', 'achievements', 'core_values', 'description', 'area_code', 'city_id', 'state_id', 'country_id', 'website', 'facebook', 'twitter', 'whatsapp', 'instagram', 'linkedin', 'created_by', 'updated_by'];
    protected $useTimestamps = true;
    protected $useSoftDeletes = true;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    public function getCompanyDetails()
    {
        $builder = $this->db->table('settings_company');
        $builder->select('settings_company.*,
                         co.country_name,
                         st.name as state_name,
                         ci.name as city_name,
                         curr.currency_code,
                         curr.currency_symbol,
                         curr.currency_name')
                ->join('usc_countries as co', 'co.country_id = settings_company.country_id', 'left')
                ->join('usc_states as st', 'st.id = settings_company.state_id', 'left')
                ->join('usc_cities as ci', 'ci.id = settings_company.city_id', 'left')
                ->join('usc_country_currency as curr', 'curr.id = settings_company.default_currency_id', 'left')
                ->where('settings_company.deleted_at', null)
                ->orderBy('settings_company.id', 'DESC')
                ->limit(1);

        $company = $builder->get()->getRow();

        // Convert filename to full URL for display
        if ($company && !empty($company->photo)) {
            $company->photo_url = base_url('media/files/' . $company->photo);
        } else {
            $company->photo_url = base_url('assets/images/default-company.png');
        }

        return $company;
    }

    public function getCurrencies()
    {
        // Get currencies from the separate currency table
        return $this->db->table('usc_country_currency')
                       ->select('*')
                       ->where('status', 1)
                       ->orderBy('currency_code')
                       ->get()
                       ->getResultArray();
    }

    public function getCountries()
    {
        $countryModel = new \App\Models\CountryModel();
        return $countryModel->getAll();
    }

    // Get company by ID
    public function getCompanyById($id)
    {
        $company = $this->find($id);
        
        // Convert filename to full URL for display in modal
        if ($company && !empty($company['photo'])) {
            $company['photo_url'] = base_url('media/files/' . $company['photo']);
        } else {
            $company['photo_url'] = base_url('assets/images/default-company.png');
        }
        
        return $company;
    }
}