<?php

namespace Modules\Settings\Controllers;

use App\Controllers\Auth\AuthController;

class LTcmsSettings extends AuthController
{

  public function initController($request, $response, $logger)
  {
        parent::initController($request, $response, $logger);
  }
  public function index()
  {
    $this->data['title']    = 'Systems Settings';
    $this->data['bcrumb']   = 'System Settings';

    $this->data['gateways'] = $this->paymentgatewaysModel->getAll();
    $this->data['perms']    = $this->permissionsModel->getAll();
    $this->data['groups']   = $this->usergroupsModel->getAll();
    $this->data['permissions'] = $this->permissionsModel->getAll();
    $this->data['sections'] = $this->modulesectionModel->getSectionsWithPermissions();
    $this->data['sectionPermissions'] = $this->permissionsModel->getPermissionsBySection();

    // Load all group permissions to pre-check checkboxes
    $groupPermissions = [];
    foreach ($this->data['groups'] as $group) {
        $perms = $this->usergrouppermissionsModel->getGroupPermissions($group->id);
        $permIds = [];
        foreach ($perms as $perm) {
            $permIds[] = $perm->id;
        }
        $groupPermissions[$group->id] = $permIds;
    }
    $this->data['groupPermissions'] = $groupPermissions;

    return view('Modules\Settings\Views\general\index', $this->data);
  }

   

  //Module Sections
  public function createModuleSection()
  {
    $rules = [
      'name' => ['label'=>'Section Name', 'rules'=>'required'],
    ];

    if(!$this->validate($rules)){
      session()->setFlashdata('error', 'Name is required', 3);
    }

    $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
    $sectionData = [
      'name'        => $this->request->getPost('name'),
      'slug'        => $slug,
      'description' => $this->request->getPost('description'),
      'icon'        => $this->request->getPost('icon'),
      'is_active'   => $this->request->getPost('is_active'),
      'sort_order'  => $this->request->getPost('sort_order'),
    ];

    if($this->modulesectionModel->save($sectionData))
    {
      //For notifications
        $message  = 'Module Section Created';
        $ntype    = 'settings';
        $createdBy = $this->userdata->user_id;
        $this->sendAdminNotifications($message, $ntype, $createdBy);

        session()->setFlashdata('success', 'Module Section Created Successfully', 3);
    }else{
      session()->setFlashdata('error', 'Module Section Not Created', 3);
    }
    return redirect()->to('administrator/settings/all');
  }

  public function editModuleSection($id)
  {
    $section = $this->modulesectionModel->where('id', $id)->first();     
    echo json_encode($section);
  }

  public function updateModuleSection()
  {

    $rules = [
      'name' => ['label'=>'Section Name', 'rules'=>'required'],
    ];

    if(!$this->validate($rules)){
      session()->setFlashdata('error', 'Name is required', 3);
    }

    $id = $this->request->getPost('id');
    $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
    $sectionData = [
      'name'        => $this->request->getPost('name'),
      'slug'        => $slug,
      'description' => $this->request->getPost('description'),
      'icon'        => $this->request->getPost('icon'),
      'is_active'   => $this->request->getPost('is_active'),
      'sort_order'  => $this->request->getPost('sort_order'),
    ];

    if($this->modulesectionModel->update($id, $sectionData))
    {
      //For notifications
        $message  = 'Module Section Updated';
        $ntype    = 'settings';
        $createdBy = $this->userdata->user_id;
        $this->sendAdminNotifications($message, $ntype, $createdBy);

        session()->setFlashdata('success', 'Module Section Edited Successfully', 3);
    }else{
      session()->setFlashdata('error', 'Module Section Not Edited', 3);
    }
    return redirect()->to('administrator/settings/all');
  }
  public function deleteModuleSection($id)
  {
    $section = $this->modulesectionModel->where('id', $id)->first($id);
    if($this->modulesectionModel->where('id', $id)->delete($id))
    {
      //For notifications
      $message  = 'Module Section '.$section['name'].' Deleted';
      $ntype    = 'settings';
      $createdBy = $this->userdata->user_id;
        $this->sendAdminNotifications($message, $ntype, $createdBy);

      session()->setFlashdata('error', 'Module Section '.$section['name'].' Deleted', 3);
      return redirect()->to('administrator/settings/all');
    }
    
  }


}