<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>

<style>
/* Custom styles for Tags Page */
.tags-card {
    border: none;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
    transition: all 0.3s ease;
}

.tags-card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.15);
}

.tags-card .card-header {
      background: linear-gradient(135deg, #667eea 0%, #6577ecff 100%);
    color: white;
    border: none;
}

.list-tags-card .card-header {
     background: linear-gradient(135deg, #21a8f1ff 0%, #86abecff 100%);
    color: white;
    border: none;
}

.tag-badge {
    background-color: #e9ecef;
    color: #495057;
    font-family: 'Courier New', monospace;
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
    border-radius: 0.25rem;
}

.btn-action-group .btn {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    margin-left: 0.25rem;
}

.modal-header {
        background: linear-gradient(135deg, #21a8f1ff 0%, #86abecff 100%);
    color: white;
}

.modal-header .btn-close {
    filter: brightness(0) invert(1);
}

.edit-form-container {
    background-color: #f8f9fa;
    border-radius: 0.5rem;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    border-left: 4px solid #667eea;
}

.form-label {
    font-weight: 600;
    color: #495057;
}

.tag-item {
    border-left: 3px solid transparent;
    transition: all 0.3s ease;
}

.tag-item:hover {
    border-left-color: #667eea;
    background-color: #f8f9fa;
}

.tag-count {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 24px;
    height: 24px;
    border-radius: 50%;
    background-color: #667eea;
    color: white;
    font-size: 0.75rem;
    font-weight: 600;
    margin-left: 0.5rem;
}
</style>

<div class="container-fluid">
    <!-- Breadcrumb -->
    <div class="row mb-3">
        <div class="col">
            <h4 class="mb-2">
                <i class="bi bi-tags-fill text-primary"></i> Tags Manager
            </h4>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator/posts') ?>">All Posts</a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?></li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Alert Messages -->
    <div class="row">
        <div class="col">
            <?php if(session()->getTempdata('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle-fill me-2"></i>
                    <?= session()->getTempdata('success');?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif;?>
            <?php if(session()->getTempdata('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                    <?= session()->getTempdata('error');?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <div id="showMsg"></div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <!-- Add/Edit Tag Form -->
        <div class="col-lg-4 mb-4">
            <div class="card tags-card">
                <?php if(!isset($singleTag)): ?>
                    <!-- Add Tag Form -->
                    <div class="card-header">
                        <h6 class="card-title mb-0 fw-bold">
                            <i class="bi bi-plus-circle"></i> Add New Tag
                        </h6>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?= base_url('administrator/posts/tags/add');?>" id="addTagForm">
                            <?= csrf_field(); ?>
                            <div class="mb-3">
                                <label class="form-label">Tag Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" required placeholder="e.g., Digital Banking">
                                <small class="text-muted">Use descriptive names for better organization</small>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description" rows="3" placeholder="Brief description of this tag"></textarea>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-check-lg"></i> Save Tag
                                </button>
                            </div>
                        </form>
                    </div>
                <?php else: ?>
                    <!-- Edit Tag Form -->
                    <div class="card-header">
                        <h6 class="card-title mb-0 fw-bold">
                            <i class="bi bi-pencil-square"></i> Edit Tag
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info" role="alert">
                            <small><i class="bi bi-info-circle"></i> Editing: <strong><?= esc($singleTag['name']) ?></strong></small>
                        </div>
                        <form method="POST" action="<?= base_url('administrator/posts/tags/update');?>" id="editTagForm">
                            <?= csrf_field(); ?>
                            <div class="mb-3">
                                <label class="form-label">Tag Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" value="<?= esc($singleTag['name']); ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description" rows="3"><?= esc($singleTag['description']); ?></textarea>
                            </div>
                            <input type="hidden" name="id" value="<?= $singleTag['id']; ?>">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-success flex-fill">
                                    <i class="bi bi-check-lg"></i> Update
                                </button>
                                <a href="<?= base_url('administrator/posts/tags') ?>" class="btn btn-secondary">
                                    <i class="bi bi-x-lg"></i> Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Quick Stats Card -->
            <div class="card mt-3">
                <div class="card-body">
                    <h6 class="card-subtitle mb-3 text-muted">
                        <i class="bi bi-bar-chart"></i> Quick Stats
                    </h6>
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <span>Total Tags:</span>
                        <span class="badge bg-primary"><?= count($tags) ?></span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <span>Active Tags:</span>
                        <span class="badge bg-success"><?= count(array_filter($tags, function($t) { return !empty($t->name); })) ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tags List -->
        <div class="col-lg-8 mb-4">
            <div class="card list-tags-card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0 fw-bold">
                        <i class="bi bi-list-ul"></i> All Tags
                    </h6>
                    <button class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#addTagModal">
                        <i class="bi bi-plus-circle"></i> Quick Add
                    </button>
                </div>
                <div class="card-body">
                    <?php if(!empty($tags)): ?>
                        <div class="table-responsive">
                            <table id="tagsTable" class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th width="40">#</th>
                                        <th>Name</th>
                                        <th>Slug</th>
                                        <th>Description</th>
                                        <th width="150">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($tags as $tag): ?>
                                        <tr class="tag-item">
                                            <td><?= $tag->id; ?></td>
                                            <td>
                                                <strong><?= esc($tag->name); ?></strong>
                                            </td>
                                            <td>
                                                <span class="tag-badge"><?= esc($tag->alias); ?></span>
                                            </td>
                                            <td>
                                                <small class="text-muted">
                                                    <?= !empty($tag->description) ? esc(substr($tag->description, 0, 50)) : 'No description' ?>
                                                    <?= !empty($tag->description) && strlen($tag->description) > 50 ? '...' : '' ?>
                                                </small>
                                            </td>
                                            <td>
                                                <div class="btn-action-group">
                                                    <button class="btn btn-sm btn-info btn-view-tag"
                                                        data-id="<?= $tag->id ?>"
                                                        data-name="<?= esc($tag->name) ?>"
                                                        data-alias="<?= esc($tag->alias) ?>"
                                                        data-description="<?= esc($tag->description ?? '') ?>"
                                                        title="View Details">
                                                        <i class="bi bi-eye"></i>
                                                    </button>
                                                    <a href="<?= base_url('administrator/posts/tags/edit/'.$tag->id); ?>" 
                                                       class="btn btn-sm btn-success"
                                                       title="Edit">
                                                        <i class="bi bi-pencil"></i>
                                                    </a>
                                                    <button class="btn btn-sm btn-danger btn-delete-tag"
                                                        data-id="<?= $tag->id ?>"
                                                        data-name="<?= esc($tag->name) ?>"
                                                        title="Delete">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="bi bi-tags display-1 text-muted"></i>
                            <p class="text-muted mt-3">No tags found. Create your first tag!</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Add Tag Modal -->
<div class="modal fade" id="addTagModal" tabindex="-1" aria-labelledby="addTagModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addTagModalLabel">
                    <i class="bi bi-plus-circle"></i> Quick Add Tag
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="quickAddTagForm">
                <div class="modal-body">
                    <?= csrf_field(); ?>
                    <div class="mb-3">
                        <label class="form-label">Tag Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" id="quickTagName" required placeholder="e.g., Mobile Banking">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" id="quickTagDescription" rows="3" placeholder="Brief description"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-lg"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-lg"></i> Save Tag
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Tag Details Modal -->
<div class="modal fade" id="viewTagModal" tabindex="-1" aria-labelledby="viewTagModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewTagModalLabel">
                    <i class="bi bi-info-circle"></i> Tag Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <dl class="row mb-0">
                    <dt class="col-sm-4">ID:</dt>
                    <dd class="col-sm-8" id="view-tag-id"></dd>
                    
                    <dt class="col-sm-4">Name:</dt>
                    <dd class="col-sm-8" id="view-tag-name"></dd>
                    
                    <dt class="col-sm-4">Slug:</dt>
                    <dd class="col-sm-8">
                        <span class="tag-badge" id="view-tag-alias"></span>
                    </dd>
                    
                    <dt class="col-sm-4">Description:</dt>
                    <dd class="col-sm-8" id="view-tag-description"></dd>
                </dl>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Tag Confirmation Modal -->
<div class="modal fade" id="deleteTagModal" tabindex="-1" aria-labelledby="deleteTagModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteTagModalLabel">
                    <i class="bi bi-exclamation-triangle"></i> Confirm Deletion
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this tag?</p>
                <div class="alert alert-warning" role="alert">
                    <strong id="delete-tag-name"></strong>
                </div>
                <p class="text-muted mb-0">
                    <small><i class="bi bi-info-circle"></i> This action cannot be undone. The tag will be removed from all associated posts.</small>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-lg"></i> Cancel
                </button>
                <a href="#" id="confirm-delete-tag" class="btn btn-danger">
                    <i class="bi bi-trash"></i> Yes, Delete Tag
                </a>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Base URL
    const baseUrl = '<?= base_url() ?>';

    // Initialize DataTable
    if ($.fn.DataTable && $('#tagsTable').length) {
        $('#tagsTable').DataTable({
            pageLength: 10,
            order: [[0, 'desc']],
            language: {
                search: "Search tags:",
                lengthMenu: "Show _MENU_ entries",
                info: "Showing _START_ to _END_ of _TOTAL_ tags",
            },
            columnDefs: [
                {
                    targets: [4], // Actions column
                    orderable: false
                }
            ]
        });
    }

    // View Tag Details Modal
    document.querySelectorAll('.btn-view-tag').forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const id = btn.getAttribute('data-id') || '';
            const name = btn.getAttribute('data-name') || '';
            const alias = btn.getAttribute('data-alias') || '';
            const description = btn.getAttribute('data-description') || 'No description provided';

            document.getElementById('view-tag-id').textContent = id;
            document.getElementById('view-tag-name').textContent = name;
            document.getElementById('view-tag-alias').textContent = alias;
            document.getElementById('view-tag-description').textContent = description;

            const modal = new bootstrap.Modal(document.getElementById('viewTagModal'));
            modal.show();
        });
    });

    // Delete Tag Modal
    document.querySelectorAll('.btn-delete-tag').forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const id = btn.getAttribute('data-id');
            const name = btn.getAttribute('data-name') || 'this tag';
            
            document.getElementById('delete-tag-name').textContent = name;
            document.getElementById('confirm-delete-tag').href = 
                baseUrl + 'administrator/posts/tags/delete/' + id;
            
            const modal = new bootstrap.Modal(document.getElementById('deleteTagModal'));
            modal.show();
        });
    });

    // Quick Add Tag Form (AJAX)
    const quickAddForm = document.getElementById('quickAddTagForm');
    if (quickAddForm) {
        quickAddForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(quickAddForm);
            const submitBtn = quickAddForm.querySelector('button[type="submit"]');
            const originalBtnText = submitBtn.innerHTML;
            
            // Disable button and show loading
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-1"></span> Saving...';
            
            fetch(baseUrl + 'administrator/posts/tags/add', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Show success message
                    const alertDiv = document.createElement('div');
                    alertDiv.className = 'alert alert-success alert-dismissible fade show';
                    alertDiv.innerHTML = `
                        <i class="bi bi-check-circle-fill me-2"></i>
                        ${data.msg}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    `;
                    document.getElementById('showMsg').innerHTML = '';
                    document.getElementById('showMsg').appendChild(alertDiv);
                    
                    // Close modal and reset form
                    const modal = bootstrap.Modal.getInstance(document.getElementById('addTagModal'));
                    modal.hide();
                    quickAddForm.reset();
                    
                    // Reload page after short delay
                    setTimeout(() => {
                        window.location.reload();
                    }, 1500);
                } else {
                    // Show error message
                    alert(data.msg || 'Failed to add tag');
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalBtnText;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred. Please try again.');
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalBtnText;
            });
        });
    }

    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(function(form) {
        form.addEventListener('submit', function(e) {
            const nameInput = form.querySelector('input[name="name"]');
            if (nameInput && !nameInput.value.trim()) {
                e.preventDefault();
                alert('Tag name is required!');
                nameInput.focus();
                return false;
            }
        });
    });

    // Auto-dismiss alerts after 5 seconds
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert-dismissible');
        alerts.forEach(function(alert) {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        });
    }, 5000);

    // Reset modal forms when closed
    document.querySelectorAll('.modal').forEach(function(modal) {
        modal.addEventListener('hidden.bs.modal', function() {
            const form = modal.querySelector('form');
            if (form) {
                form.reset();
            }
        });
    });
});

// Keyboard shortcuts
document.addEventListener('keydown', function(e) {
    // Ctrl/Cmd + K to search
    if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
        e.preventDefault();
        const searchInput = document.querySelector('.dataTables_filter input');
        if (searchInput) {
            searchInput.focus();
        }
    }
    
    // Ctrl/Cmd + N to add new tag
    if ((e.ctrlKey || e.metaKey) && e.key === 'n') {
        e.preventDefault();
        const addModal = new bootstrap.Modal(document.getElementById('addTagModal'));
        addModal.show();
        setTimeout(() => {
            document.getElementById('quickTagName').focus();
        }, 500);
    }
    
    // ESC to close modals
    if (e.key === 'Escape') {
        const modals = document.querySelectorAll('.modal.show');
        modals.forEach(function(modal) {
            const bsModal = bootstrap.Modal.getInstance(modal);
            if (bsModal) {
                bsModal.hide();
            }
        });
    }
});
</script>

<?= $this->endSection();?>