<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>View Page Details</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/pages') ?> ">All Pages</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Create/Post !-->
<div class="row">
    <div class="col-lg-9 col-md-8 col-sm-12">
        <div class="card card-body mb-3">
            <h3 class="fw-bold"><?= $singlePage->title; ?></h3>
            <span class="d-flex mb-2">
                <small>
                    <strong>Created:</strong> <?= date('jS M Y, g:i A', strtotime($singlePage->created_at)); ?> | 
                    <strong>Author:</strong> <?= $singlePage->first_name.' '.$singlePage->last_name; ?> | 
                    <strong>Category:</strong> <?= $singlePage->category_name ?? 'Uncategorized'; ?>
                </small>
            </span>

            <!-- Page Link - Clickable & Testable !-->
            <div class="alert alert-info mb-3">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <strong><i class="bi bi-link-45deg"></i> Page URL:</strong><br/>
                        <a href="<?= base_url($singlePage->menu_link ?? ''); ?>" target="_blank" class="text-primary fw-bold">
                            <?= base_url($singlePage->menu_link ?? ''); ?>
                        </a>
                    </div>
                    <div class="col-md-4 text-end">
                        <a href="<?= base_url($singlePage->menu_link ?? ''); ?>" target="_blank" class="btn btn-sm btn-primary">
                            <i class="bi bi-box-arrow-up-right"></i> Test Link
                        </a>
                    </div>
                </div>
            </div>

            <!-- Page Content !-->
            <?php if($singlePage->photo): ?>
                <div class="mb-3">
                    <img src="<?= $singlePage->photo; ?>" alt="<?= $singlePage->title; ?>" class="img-fluid rounded" />
                </div>
            <?php endif; ?>

            <?php if($singlePage->excerpt): ?>
                <div class="mb-3">
                    <h5 class="fw-bold">Excerpt</h5>
                    <p class="text-muted"><?= $singlePage->excerpt; ?></p>
                </div>
            <?php endif; ?>

            <div class="mb-3">
                <h5 class="fw-bold">Full Content</h5>
                <div class="content-area">
                    <?= $singlePage->content ?>
                </div>
            </div>

            <!-- SEO Information !-->
            <?php if($singlePage->metadesc || $singlePage->metakey): ?>
            <div class="card bg-light mt-3">
                <div class="card-header bg-primary bg-opacity-10">
                    <strong><i class="bi bi-search"></i> SEO Information</strong>
                </div>
                <div class="card-body">
                    <?php if($singlePage->metadesc): ?>
                        <p><strong>Meta Description:</strong><br/>
                        <span class="text-muted"><?= $singlePage->metadesc; ?></span></p>
                    <?php endif; ?>
                    <?php if($singlePage->metakey): ?>
                        <p><strong>Meta Keywords:</strong><br/>
                        <span class="text-muted"><?= $singlePage->metakey; ?></span></p>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

        </div>
    </div>

    <!-- Sidebar with Page Details !-->
    <div class="col-lg-3 col-md-4 col-sm-12">
        <!-- Quick Actions !-->
        <div class="card mb-3">
            <div class="card-header bg-secondary bg-opacity-10">
                <strong>Quick Actions</strong>
            </div>
            <div class="list-group list-group-flush">
                <a href="<?= base_url('administrator/pages'); ?>" class="list-group-item list-group-item-action">
                    <i class="bi bi-arrow-left"></i> Back to Pages
                </a>
                <a href="<?= base_url('administrator/pages/edit/').$singlePage->id.'-'.$singlePage->alias; ?>" class="list-group-item list-group-item-action">
                    <i class="bi bi-pencil"></i> Edit Page
                </a>
                <a href="<?= base_url('administrator/pages/add/'); ?>" class="list-group-item list-group-item-action">
                    <i class="bi bi-plus-circle"></i> Add New Page
                </a>
                <a href="<?= base_url($singlePage->menu_link ?? ''); ?>" target="_blank" class="list-group-item list-group-item-action text-primary">
                    <i class="bi bi-eye"></i> View Live Page
                </a>
            </div>
        </div>

        <!-- Publishing Details !-->
        <div class="card mb-3">
            <div class="card-header bg-success bg-opacity-10">
                <strong><i class="bi bi-info-circle"></i> Publishing Details</strong>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless mb-0">
                    <tr>
                        <th>Status:</th>
                        <td>
                            <?php 
                            $statusClass = '';
                            switch($singlePage->status) {
                                case 'Published': $statusClass = 'success'; break;
                                case 'Unpublished': $statusClass = 'warning'; break;
                                case 'Archived': $statusClass = 'secondary'; break;
                                case 'Trashed': $statusClass = 'danger'; break;
                                default: $statusClass = 'info';
                            }
                            ?>
                            <span class="badge bg-<?= $statusClass ?>"><?= $singlePage->status; ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th>Access:</th>
                        <td><span class="badge bg-info"><?= $singlePage->access; ?></span></td>
                    </tr>
                    <tr>
                        <th>Type:</th>
                        <td><?= $singlePage->content_type_name ?? 'Page'; ?></td>
                    </tr>
                    <?php if($singlePage->published_date): ?>
                    <tr>
                        <th>Published:</th>
                        <td><?= date('jS M Y', strtotime($singlePage->published_date)); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if($singlePage->updated_at): ?>
                    <tr>
                        <th>Updated:</th>
                        <td><?= date('jS M Y, g:i A', strtotime($singlePage->updated_at)); ?></td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>

        <!-- Template & Configuration !-->
        <div class="card mb-3">
            <div class="card-header bg-primary bg-opacity-10">
                <strong><i class="bi bi-layout-text-window"></i> Template & Config</strong>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless mb-0">
                    <?php if($singlePage->template_name): ?>
                    <tr>
                        <th>Template:</th>
                        <td><?= $singlePage->template_name; ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if($singlePage->service_group_name): ?>
                    <tr>
                        <th>Service Group:</th>
                        <td><?= $singlePage->service_group_name; ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if($singlePage->nav_context): ?>
                    <tr>
                        <th>Nav Context:</th>
                        <td><?= $singlePage->nav_context; ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if($singlePage->banner_title): ?>
                    <tr>
                        <th>Banner:</th>
                        <td><?= $singlePage->banner_title; ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <th>Block Page:</th>
                        <td><?= $singlePage->is_block == 'Yes' ? 'Yes' : 'No'; ?></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Statistics !-->
        <div class="card mb-3">
            <div class="card-header bg-warning bg-opacity-10">
                <strong><i class="bi bi-bar-chart"></i> Statistics</strong>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless mb-0">
                    <tr>
                        <th>Hits:</th>
                        <td><span class="badge bg-danger"><?= $singlePage->hits ?? 0; ?></span></td>
                    </tr>
                    <tr>
                        <th>Views:</th>
                        <td><span class="badge bg-primary"><?= $singlePage->views ?? 0; ?></span></td>
                    </tr>
                    <tr>
                        <th>Page ID:</th>
                        <td><?= $singlePage->id; ?></td>
                    </tr>
                    <tr>
                        <th>Alias:</th>
                        <td><code><?= $singlePage->alias; ?></code></td>
                    </tr>
                </table>
            </div>
        </div>

    </div>
</div>

<!-- End Create/Post !-->
<!---- JS --->
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>  
<?= $this->endSection();?>