<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Pages & Services</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Show All Posts !-->
<div class="card card-body">
    <div class="d-flex bd-highlight mb-3">
        <div class="p-2 bd-highlight">
        <a href="<?= base_url('administrator/pages/add'); ?>" class="btn btn-sm btn-success w-100"><i class="bi bi-plus"></i> Add New</a>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-pencil-square"></i></button>
                <a href="#" class="btn btn-sm btn-light">Edit</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                <a href="#" class="btn btn-sm btn-light">Publish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-x-circle-fill text-danger"></i></button>
                <a href="#" class="btn btn-sm btn-light">Unpublish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-hdd-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Arhived</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-trash-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Trashed</a>
            </div>
        </div>
        <div class="p-2 bd-grow-1 bd-highlight"> &nbsp;</div>
    </div>
    <div class="table-responsive">
        <table id="postslist" class="table table-stripped table-hover">
            <thead class="bg-primary bg-opacity-10" style="font-size: 14px"><tr>
                <th>#</th>
                <th></th>
                <th>Title</th>
                <th>Type</th>
                <th>Service Group</th>
                <th>Template</th>
                <th>Author</th>
                <th>Status</th>
                <th>Hits</th>
                <th></th>
            </tr></thead>
            <tbody>
            <?php foreach($pages as $p): ?>
                    <tr>
                    <td><span class="badge rounded-pill bg-info"> <?= $p->id; ?> </span></td>
                    <td>
                        <?php if($p->photo):?>
                            <img src="<?= $p->photo; ?>" width="50px">
                        <?php endif;?>
                    </td>
                    <td>
                        <a href="<?= base_url('administrator/pages/edit/').$p->id.'-'.$p->alias; ?>" style="font-size: 15px;"><?= $p->title; ?></a> 
                        <small class="text-muted"> (<?= $p->alias; ?>)</small><br>
                        <small>Category: <a href="<?= base_url('administrator/posts/categories'); ?>"><?= $p->category_name; ?></a></small>
                        <?php if($p->is_block == 'Yes'): ?>
                            <span class="badge bg-secondary ms-1">Blocks</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="badge bg-primary">
                            <i class="<?= $p->content_type_slug == 'page' ? 'fas fa-file-alt' : 'fas fa-cogs' ?>"></i>
                            <?= $p->content_type_name; ?>
                        </span>
                    </td>
                    <td>
                        <?php if(!empty($p->service_group_name)): ?>
                            <span class="badge bg-info"><?= ucfirst($p->service_group_name); ?></span>
                        <?php else: ?>
                            <span class="text-muted">-</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if(!empty($p->template_name)): ?>
                            <small class="text-muted"><?= $p->template_name; ?></small>
                        <?php else: ?>
                            <span class="text-muted">-</span>
                        <?php endif; ?>
                    </td>
                    <td><small><a href="#"><?= $p->first_name.' '.$p->last_name; ?></a></small></td>
                    <td>
                        <?php if($p->status == 'published'):?>
                            <span class="badge rounded-pill bg-success"><?= $p->status ?></span> 
                        <?php elseif($p->status == 'unpublished'):?>
                            <span class="badge rounded-pill bg-danger"><?= $p->status ?></span>
                        <?php elseif($p->status == 'archived'):?>
                            <span class="badge rounded-pill bg-info"><?= $p->status ?></span>
                        <?php else:?>
                            <span class="badge rounded-pill bg-secodary"><?= $p->status ?></span>
                        <?php endif;?>
                    </td>
                    <td> <span class="badge rounded-pill bg-warning"> <?= $p->hits ?? 0; ?> </span> </td>
                    <td>
                    <div class="btn-group dropstart">
                    <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-three-dots-vertical"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?= base_url('administrator/pages/view/').$p->id.'-'.$p->alias; ?>"><small>view</small></a></li>
                        <li><a class="dropdown-item" href="<?= base_url('administrator/pages/edit/').$p->id.'-'.$p->alias; ?>"><small>Edit</small></a></li>
                        <li><a class="dropdown-item" onclick="delete_page(<?= $p->id ?>, '<?= $p->title ?>')"    style="cursor: pointer"><small>Delete</small></a></li>
                    </ul>
                    </div>
                    
                    </td>
                    </tr>
                    <?php endforeach;?>
            </tbody>
        </table>
    </div>
</div>
</div> <!-- Container!-->         
    <!---- Modals --->

<!---- JS --->
<script type="text/javascript">
    function delete_page(id, title){
        var confirmation = confirm('Are you sure you want to delete '+ title +' page?');
        if(confirmation == true){
            window.location.href = base_url + ('administrator/pages/delete/')+ id;
        }
    }
</script>
<script type="text/javascript">
      $(document).ready(function () {
          $('#postslist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
          });
      });

</script>
               
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>   
<?= $this->endSection();?>