<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>

<style>
/* Custom styles for Context Manager */
.context-card {
    border: none;
    box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
    transition: all 0.3s ease;
}

.context-card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.15);
}

.context-card .card-header {
    background: linear-gradient(135deg, #667eea 0%, #6577ecff 100%);
    color: white;
    border: none;
}

.service-card .card-header {
    background: linear-gradient(135deg, #21a8f1ff 0%, #86abecff 100%);
    color: white;
    border: none;
}

.list-group-item {
    border-left: 3px solid transparent;
    transition: all 0.3s ease;
}

.list-group-item:hover {
    border-left-color: #667eea;
    background-color: #f8f9fa;
}

.badge-slug {
    background-color: #e9ecef;
    color: #495057;
    font-family: 'Courier New', monospace;
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
}

.btn-action-group .btn {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    margin-left: 0.25rem;
}

.modal-header {
    background: linear-gradient(135deg, #21a8f1ff 0%, #86abecff 100%);
    color: white;
}

.modal-header .btn-close {
    filter: brightness(0) invert(1);
}

.edit-form-container {
    background-color: #f8f9fa;
    border-radius: 0.5rem;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    border-left: 4px solid #667eea;
}

.preview-image-container {
    position: relative;
    display: inline-block;
}

.preview-image-container img {
    border-radius: 0.5rem;
}

.form-label {
    font-weight: 600;
    color: #495057;
}

.icon-preview {
    font-size: 1.5rem;
    margin-right: 0.5rem;
}
</style>

<div class="container-fluid">
    <!-- Breadcrumb -->
    <div class="row mb-3">
        <div class="col">
            <h4 class="mb-2">
                <i class="bi bi-gear-fill text-primary"></i> Context Manager
            </h4>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Context Manager</li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Alert Messages -->
    <div class="row">
        <div class="col">
            <?php if(session()->getTempdata('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle-fill me-2"></i>
                    <?= session()->getTempdata('success');?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif;?>
            <?php if(session()->getTempdata('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                    <?= session()->getTempdata('error');?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <!-- Nav Contexts Column -->
        <div class="col-lg-6 mb-4">
            <div class="card context-card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0 fw-bold">
                        <i class="bi bi-compass"></i> Navigation Contexts
                    </h6>
                    <button class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#addNavContextModal">
                        <i class="bi bi-plus-circle"></i> Add New
                    </button>
                </div>
                <div class="card-body">
                    <!-- Edit Form (if editing) -->
                    <?php if(isset($singleNavContext) && !empty($singleNavContext)): ?>
                    <div class="edit-form-container">
                        <h6 class="mb-3">
                            <i class="bi bi-pencil-square"></i> Edit Nav Context
                        </h6>
                        <form method="POST" action="<?= base_url('administrator/posts/context-manager/nav-contexts/update') ?>">
                            <?= csrf_field() ?>
                            <div class="mb-3">
                                <label class="form-label">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" value="<?= esc($singleNavContext['name']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description" rows="3"><?= esc($singleNavContext['description']) ?></textarea>
                            </div>
                            <input type="hidden" name="id" value="<?= $singleNavContext['id'] ?>">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-success">
                                    <i class="bi bi-check-lg"></i> Update
                                </button>
                                <a href="<?= base_url('administrator/posts/context-manager') ?>" class="btn btn-secondary">
                                    <i class="bi bi-x-lg"></i> Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>

                    <!-- Nav Contexts List -->
                    <?php if(!empty($nav_contexts)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle" id="navContextsTable">
                            <thead class="table-light">
                                <tr>
                                    <th width="40">#</th>
                                    <th>Name</th>
                                    <th>Slug</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($nav_contexts as $nc): ?>
                                <tr>
                                    <td><?= $nc['id'] ?></td>
                                    <td>
                                        <strong><?= esc($nc['name']) ?></strong>
                                        <?php if(!empty($nc['description'])): ?>
                                        <br><small class="text-muted"><?= esc(substr($nc['description'], 0, 50)) ?><?= strlen($nc['description']) > 50 ? '...' : '' ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge-slug"><?= esc($nc['slug'] ?? '') ?></span>
                                    </td>
                                    <td>
                                        <div class="btn-action-group">
                                            <button class="btn btn-sm btn-info btn-view-navcontext"
                                                data-id="<?= $nc['id'] ?>"
                                                data-name="<?= esc($nc['name']) ?>"
                                                data-slug="<?= esc($nc['slug']) ?>"
                                                data-description="<?= esc($nc['description']) ?>"
                                                data-active="<?= $nc['is_active'] ?>"
                                                data-created="<?= esc($nc['created_at']) ?>"
                                                title="View Details">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <a href="<?= base_url('administrator/posts/context-manager/nav-contexts/edit/'.$nc['id']) ?>" 
                                               class="btn btn-sm btn-success"
                                               title="Edit">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <button class="btn btn-sm btn-danger btn-delete-navcontext"
                                                data-id="<?= $nc['id'] ?>"
                                                data-name="<?= esc($nc['name']) ?>"
                                                title="Delete">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox display-1 text-muted"></i>
                        <p class="text-muted mt-3">No navigation contexts found. Add your first one!</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Service Groups Column -->
        <div class="col-lg-6 mb-4">
            <div class="card service-card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0 fw-bold">
                        <i class="bi bi-grid-3x3-gap"></i> Service Groups
                    </h6>
                    <button class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#addServiceGroupModal">
                        <i class="bi bi-plus-circle"></i> Add New
                    </button>
                </div>
                <div class="card-body">
                    <!-- Edit Form (if editing) -->
                    <?php if(isset($singleServiceGroup) && !empty($singleServiceGroup)): ?>
                    <div class="edit-form-container">
                        <h6 class="mb-3">
                            <i class="bi bi-pencil-square"></i> Edit Service Group
                        </h6>
                        <form method="POST" action="<?= base_url('administrator/posts/context-manager/service-groups/update') ?>" enctype="multipart/form-data">
                            <?= csrf_field() ?>
                            <div class="mb-3">
                                <label class="form-label">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" value="<?= esc($singleServiceGroup['name']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description" rows="3"><?= esc($singleServiceGroup['description']) ?></textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Preview Image</label>
                                <?php if(isset($singleServiceGroup['preview_image']) && !empty($singleServiceGroup['preview_image'])): ?>
                                    <div class="preview-image-container mb-2">
                                        <img src="<?= base_url('media/service-groups/' . $singleServiceGroup['preview_image']) ?>" 
                                             alt="Current preview" 
                                             class="img-thumbnail" 
                                             style="max-height: 100px">
                                    </div>
                                <?php endif; ?>
                                <input type="file" class="form-control" name="preview_image" accept="image/*">
                                <small class="text-muted">Leave empty to keep current image</small>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Associated Nav Contexts</label>
                                <div class="border rounded p-3 bg-white">
                                    <?php if(!empty($nav_contexts)): ?>
                                        <?php foreach($nav_contexts as $nc): ?>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="nav_contexts[]" 
                                                       value="<?= $nc['id'] ?>" 
                                                       id="nc-edit-<?= $nc['id'] ?>" 
                                                       <?= (isset($singleServiceGroupNavs) && in_array($nc['id'], $singleServiceGroupNavs)) ? 'checked' : '' ?>>
                                                <label class="form-check-label" for="nc-edit-<?= $nc['id'] ?>">
                                                    <?= esc($nc['name']) ?>
                                                </label>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <p class="text-muted mb-0">No nav contexts available</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <input type="hidden" name="id" value="<?= $singleServiceGroup['id'] ?>">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-success">
                                    <i class="bi bi-check-lg"></i> Update
                                </button>
                                <a href="<?= base_url('administrator/posts/context-manager') ?>" class="btn btn-secondary">
                                    <i class="bi bi-x-lg"></i> Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>

                    <!-- Service Groups List -->
                    <?php if(!empty($service_groups)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle" id="serviceGroupsTable">
                            <thead class="table-light">
                                <tr>
                                    <th width="40">#</th>
                                    <th>Name</th>
                                    <th>Slug</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($service_groups as $sg): ?>
                                <tr>
                                    <td><?= $sg['id'] ?></td>
                                    <td>
                                        <strong><?= esc($sg['name']) ?></strong>
                                        <?php if(!empty($sg['description'])): ?>
                                        <br><small class="text-muted"><?= esc(substr($sg['description'], 0, 50)) ?><?= strlen($sg['description']) > 50 ? '...' : '' ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge-slug"><?= esc($sg['slug'] ?? '') ?></span>
                                    </td>
                                    <td>
                                        <div class="btn-action-group">
                                            <button class="btn btn-sm btn-info btn-view-servicegroup"
                                                data-id="<?= $sg['id'] ?>"
                                                data-name="<?= esc($sg['name']) ?>"
                                                data-slug="<?= esc($sg['slug']) ?>"
                                                data-description="<?= esc($sg['description']) ?>"
                                                data-active="<?= $sg['is_active'] ?>"
                                                data-preview="<?= !empty($sg['preview_image']) ? base_url('media/service-groups/' . $sg['preview_image']) : '' ?>"
                                                data-created="<?= esc($sg['created_at']) ?>"
                                                data-createdby="<?= esc($sg['created_by'] ?? '') ?>"
                                                title="View Details">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <a href="<?= base_url('administrator/posts/context-manager/service-groups/edit/'.$sg['id']) ?>" 
                                               class="btn btn-sm btn-success"
                                               title="Edit">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <button class="btn btn-sm btn-danger btn-delete-servicegroup"
                                                data-id="<?= $sg['id'] ?>"
                                                data-name="<?= esc($sg['name']) ?>"
                                                title="Delete">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox display-1 text-muted"></i>
                        <p class="text-muted mt-3">No service groups found. Add your first one!</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Nav Context Modal -->
<div class="modal fade" id="addNavContextModal" tabindex="-1" aria-labelledby="addNavContextModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addNavContextModalLabel">
                    <i class="bi bi-plus-circle"></i> Add Navigation Context
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?= base_url('administrator/posts/context-manager/nav-contexts/add') ?>">
                <div class="modal-body">
                    <?= csrf_field() ?>
                    <div class="mb-3">
                        <label class="form-label">Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" required placeholder="e.g., Personal Banking">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" rows="3" placeholder="Brief description of this navigation context"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-lg"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-lg"></i> Save Context
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Service Group Modal -->
<div class="modal fade" id="addServiceGroupModal" tabindex="-1" aria-labelledby="addServiceGroupModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addServiceGroupModalLabel">
                    <i class="bi bi-plus-circle"></i> Add Service Group
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?= base_url('administrator/posts/context-manager/service-groups/add') ?>" enctype="multipart/form-data">
                <div class="modal-body">
                    <?= csrf_field() ?>
                    <div class="mb-3">
                        <label class="form-label">Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" required placeholder="e.g., Current Accounts">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" rows="3" placeholder="Brief description of this service group"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Preview Image</label>
                        <input type="file" class="form-control" name="preview_image" accept="image/*">
                        <small class="text-muted">Recommended size: 800x600px</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Associated Nav Contexts</label>
                        <div class="border rounded p-3 bg-light">
                            <?php if(!empty($nav_contexts)): ?>
                                <?php foreach($nav_contexts as $nc): ?>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" name="nav_contexts[]" 
                                               value="<?= $nc['id'] ?>" 
                                               id="nc-add-<?= $nc['id'] ?>">
                                        <label class="form-check-label" for="nc-add-<?= $nc['id'] ?>">
                                            <?= esc($nc['name']) ?>
                                        </label>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <p class="text-muted mb-0">No nav contexts available. Create one first!</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-lg"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-lg"></i> Save Group
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Nav Context Modal -->
<div class="modal fade" id="viewNavContextModal" tabindex="-1" aria-labelledby="viewNavContextModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewNavContextModalLabel">
                    <i class="bi bi-info-circle"></i> Nav Context Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <dl class="row mb-0">
                    <dt class="col-sm-4">Name:</dt>
                    <dd class="col-sm-8" id="vc-name"></dd>
                    
                    <dt class="col-sm-4">Slug:</dt>
                    <dd class="col-sm-8">
                        <span class="badge-slug" id="vc-slug"></span>
                    </dd>
                    
                    <dt class="col-sm-4">Description:</dt>
                    <dd class="col-sm-8" id="vc-description"></dd>
                    
                    <dt class="col-sm-4">Status:</dt>
                    <dd class="col-sm-8" id="vc-active"></dd>
                    
                    <dt class="col-sm-4">Created:</dt>
                    <dd class="col-sm-8" id="vc-created"></dd>
                </dl>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- View Service Group Modal -->
<div class="modal fade" id="viewServiceGroupModal" tabindex="-1" aria-labelledby="viewServiceGroupModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewServiceGroupModalLabel">
                    <i class="bi bi-info-circle"></i> Service Group Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-8">
                        <dl class="row mb-0">
                            <dt class="col-sm-4">Name:</dt>
                            <dd class="col-sm-8" id="sg-name"></dd>
                            
                            <dt class="col-sm-4">Slug:</dt>
                            <dd class="col-sm-8">
                                <span class="badge-slug" id="sg-slug"></span>
                            </dd>
                            
                            <dt class="col-sm-4">Description:</dt>
                            <dd class="col-sm-8" id="sg-description"></dd>
                            
                            <dt class="col-sm-4">Status:</dt>
                            <dd class="col-sm-8" id="sg-active"></dd>
                            
                            <dt class="col-sm-4">Created:</dt>
                            <dd class="col-sm-8" id="sg-created"></dd>
                            
                            <dt class="col-sm-4">Created By:</dt>
                            <dd class="col-sm-8" id="sg-createdby"></dd>
                        </dl>
                    </div>
                    <div class="col-md-4 text-center" id="sg-preview-col">
                        <img id="sg-preview-img" src="" alt="Preview" class="img-fluid img-thumbnail" style="max-height:200px; display:none;">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Nav Context Modal -->
<div class="modal fade" id="deleteNavContextModal" tabindex="-1" aria-labelledby="deleteNavContextModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteNavContextModalLabel">
                    <i class="bi bi-exclamation-triangle"></i> Confirm Deletion
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this navigation context?</p>
                <div class="alert alert-warning" role="alert">
                    <strong id="delete-nc-name"></strong>
                </div>
                <p class="text-muted mb-0">
                    <small><i class="bi bi-info-circle"></i> This action cannot be undone.</small>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-lg"></i> Cancel
                </button>
                <a href="#" id="confirm-delete-nc" class="btn btn-danger">
                    <i class="bi bi-trash"></i> Yes, Delete
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Delete Service Group Modal -->
<div class="modal fade" id="deleteServiceGroupModal" tabindex="-1" aria-labelledby="deleteServiceGroupModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteServiceGroupModalLabel">
                    <i class="bi bi-exclamation-triangle"></i> Confirm Deletion
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this service group?</p>
                <div class="alert alert-warning" role="alert">
                    <strong id="delete-sg-name"></strong>
                </div>
                <p class="text-muted mb-0">
                    <small><i class="bi bi-info-circle"></i> This action cannot be undone.</small>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-lg"></i> Cancel
                </button>
                <a href="#" id="confirm-delete-sg" class="btn btn-danger">
                    <i class="bi bi-trash"></i> Yes, Delete
                </a>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Base URL for links
    const baseUrl = '<?= base_url() ?>';

    // Initialize DataTables
    if ($.fn.DataTable) {
        $('#navContextsTable').DataTable({
            pageLength: 10,
            order: [[0, 'desc']],
            language: {
                search: "Search contexts:",
                lengthMenu: "Show _MENU_ entries",
            }
        });

        $('#serviceGroupsTable').DataTable({
            pageLength: 10,
            order: [[0, 'desc']],
            language: {
                search: "Search groups:",
                lengthMenu: "Show _MENU_ entries",
            }
        });
    }

    // View Nav Context Modal
    document.querySelectorAll('.btn-view-navcontext').forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const name = btn.getAttribute('data-name') || '';
            const slug = btn.getAttribute('data-slug') || '';
            const description = btn.getAttribute('data-description') || 'No description provided';
            const active = btn.getAttribute('data-active') == '1' ? 
                '<span class="badge bg-success">Active</span>' : 
                '<span class="badge bg-secondary">Inactive</span>';
            const created = btn.getAttribute('data-created') || '';

            document.getElementById('vc-name').textContent = name;
            document.getElementById('vc-slug').textContent = slug;
            document.getElementById('vc-description').textContent = description;
            document.getElementById('vc-active').innerHTML = active;
            document.getElementById('vc-created').textContent = created;

            const modal = new bootstrap.Modal(document.getElementById('viewNavContextModal'));
            modal.show();
        });
    });

    // View Service Group Modal
    document.querySelectorAll('.btn-view-servicegroup').forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const name = btn.getAttribute('data-name') || '';
            const slug = btn.getAttribute('data-slug') || '';
            const description = btn.getAttribute('data-description') || 'No description provided';
            const active = btn.getAttribute('data-active') == '1' ? 
                '<span class="badge bg-success">Active</span>' : 
                '<span class="badge bg-secondary">Inactive</span>';
            const preview = btn.getAttribute('data-preview') || '';
            const created = btn.getAttribute('data-created') || '';
            const createdby = btn.getAttribute('data-createdby') || 'Unknown';

            document.getElementById('sg-name').textContent = name;
            document.getElementById('sg-slug').textContent = slug;
            document.getElementById('sg-description').textContent = description;
            document.getElementById('sg-active').innerHTML = active;
            document.getElementById('sg-created').textContent = created;
            document.getElementById('sg-createdby').textContent = createdby;

            const img = document.getElementById('sg-preview-img');
            if (preview && preview !== baseUrl + 'media/service-groups/') {
                img.src = preview;
                img.style.display = 'block';
            } else {
                img.style.display = 'none';
            }

            const modal = new bootstrap.Modal(document.getElementById('viewServiceGroupModal'));
            modal.show();
        });
    });

    // Delete Nav Context Modal
    document.querySelectorAll('.btn-delete-navcontext').forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const id = btn.getAttribute('data-id');
            const name = btn.getAttribute('data-name') || 'this item';
            
            document.getElementById('delete-nc-name').textContent = name;
            document.getElementById('confirm-delete-nc').href = 
                baseUrl + 'administrator/posts/context-manager/nav-contexts/delete/' + id;
            
            const modal = new bootstrap.Modal(document.getElementById('deleteNavContextModal'));
            modal.show();
        });
    });

    // Delete Service Group Modal
    document.querySelectorAll('.btn-delete-servicegroup').forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const id = btn.getAttribute('data-id');
            const name = btn.getAttribute('data-name') || 'this item';
            
            document.getElementById('delete-sg-name').textContent = name;
            document.getElementById('confirm-delete-sg').href = 
                baseUrl + 'administrator/posts/context-manager/service-groups/delete/' + id;
            
            const modal = new bootstrap.Modal(document.getElementById('deleteServiceGroupModal'));
            modal.show();
        });
    });

    // Auto-dismiss alerts after 5 seconds
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert-dismissible');
        alerts.forEach(function(alert) {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        });
    }, 5000);

    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(function(form) {
        form.addEventListener('submit', function(e) {
            const nameInput = form.querySelector('input[name="name"]');
            if (nameInput && !nameInput.value.trim()) {
                e.preventDefault();
                alert('Name field is required!');
                nameInput.focus();
                return false;
            }
        });
    });

    // Preview image before upload
    const fileInputs = document.querySelectorAll('input[type="file"]');
    fileInputs.forEach(function(input) {
        input.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function(event) {
                    // Find or create preview element
                    let preview = input.parentElement.querySelector('.image-preview');
                    if (!preview) {
                        preview = document.createElement('div');
                        preview.className = 'image-preview mt-2';
                        input.parentElement.appendChild(preview);
                    }
                    preview.innerHTML = '<img src="' + event.target.result + '" class="img-thumbnail" style="max-height: 100px;">';
                };
                reader.readAsDataURL(file);
            }
        });
    });
});

// Keyboard shortcuts
document.addEventListener('keydown', function(e) {
    // Ctrl/Cmd + K to search
    if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
        e.preventDefault();
        const searchInput = document.querySelector('.dataTables_filter input');
        if (searchInput) {
            searchInput.focus();
        }
    }
    
    // ESC to close modals
    if (e.key === 'Escape') {
        const modals = document.querySelectorAll('.modal.show');
        modals.forEach(function(modal) {
            const bsModal = bootstrap.Modal.getInstance(modal);
            if (bsModal) {
                bsModal.hide();
            }
        });
    }
});
</script>

<?= $this->endSection();?>