<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>All Posts Comments</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Show All Posts !-->
<div class="card card-body">
    <div class="table-responsive">
        <table id="commentslist" class="table table-stripped table-hover">
            <thead class="bg-primary bg-opacity-10" style="font-size: 14px"><tr>
                <th>Date</th>
                <th>Comment</th>
                <th>Post</th>
                <th>User</th>
                <th>Action</th>
            </tr></thead>
            <tbody style="font-size: 13px">
            <?php foreach($post_comments as $p): ?>
                    <tr>
                    <td><small><?= date('jS M Y', strtotime($p->created_at)); ?></small></td>
                    <td><?= $p->description; ?></td>
                    <td><a href="<?= base_url('administrator/posts/view/').$p->post_id.'-'.$p->post_alias; ?>"><?= $p->post_title; ?></a></td>
                    <td><small><a href="#"><?= $p->first_name; ?></a></small></td>
                    <td>
                    <div class="btn-group dropstart">
                    <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-three-dots-vertical"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" onclick="edit_postcomment(<?= $p->id ?>)"><small>Edit</small></a></li>
                        <li><a class="dropdown-item"   style="cursor: pointer" onclick="delete_postcomment(<?= $p->id ?>)"><small>Delete</small></a></li>
                    </ul>
                    </div>
                    </td>
                    </tr>
                    <?php endforeach;?>
            </tbody>
        </table>
    </div>
</div>
</div> <!-- Container!-->         
<!---- Modals --->
<?= view('Modules\Posts\Views\\modals\\del_postsModal') ?>
<?= view('Modules\Posts\Views\comments\modals\\add_comment') ?>

<!---- JS --->
<script type="text/javascript">
      $(document).ready(function () {
          $('#commentslist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
          });
      });

</script>               
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>   
<?= $this->endSection();?>