<?= $this->extend('Modules\Admin\Views\index'); ?>

<?= $this->section('styles') ?>
<style>
.icon-preview-wrapper {
    display: flex;
    align-items: center;
    gap: 10px;
    position: relative;
    z-index: 1080;
}

.icon-preview {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    background: #f8f9fa;
}

.icon-picker-container {
    position: absolute;
    top: 100%;
    left: 0;
    z-index: 1070;
    background: white;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    padding: 1rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    max-height: 300px;
    overflow-y: auto;
    width: 320px;
    margin-top: 2px;
}

.icon-grid {
    display: grid;
    grid-template-columns: repeat(8, 1fr);
    gap: 8px;
}

.icon-item {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.2s ease-in-out;
}

.icon-item:hover {
    background: #e9ecef;
    border-color: #adb5bd;
    transform: scale(1.1);
}

.icon-item.selected {
    background: #e7f1ff;
    border-color: #0d6efd;
}

.icon-item i {
    font-size: 1rem;
}

/* Fix modal z-index to ensure picker is visible */
.modal {
    z-index: 1050;
}

.modal-backdrop {
    z-index: 1040;
}
/* Confirmation Modal Styles */
.confirmation-icon {
    font-size: 3rem;
}

/* Toast Notifications */
/* .toast {
    backdrop-filter: blur(10px);
} */

/* Modal animations */
.modal.fade .modal-dialog {
    transform: scale(0.8);
    transition: transform 0.3s ease-out;
}

.modal.show .modal-dialog {
    transform: scale(1);
}

/* Button animations */
.btn {
    transition: all 0.2s ease-in-out;
}

.btn:hover {
    transform: translateY(-1px);
}

/* Custom danger button */
.btn-custom-danger {
    background: linear-gradient(135deg, #dc3545, #c82333);
    border: none;
    color: white;
}

.btn-custom-danger:hover {
    background: linear-gradient(135deg, #c82333, #a71e2a);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(220, 53, 69, 0.3);
}
</style>

<?= $this->endSection() ?>

<?= $this->section('head') ?>
<!-- CSRF Token -->
<meta name="csrf-token" content="<?= csrf_hash() ?>">
<?= $this->endSection() ?>

<?= $this->section('content'); ?>
<div class="container-fluid">
    <div class="row mb-md-3">
        <div class="col">
            <h4>Content Blocks Management</h4>
            <nav aria-label="breadcrumb"><small>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Blocks</li>
                </ol></small>
            </nav>
        </div>
    </div>

    <!-- Messages -->
    <div class="row">
        <div class="col">
            <?php if(session()->getTempdata('success')): ?>
                <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
            <?php endif;?>
            <?php if(session()->getTempdata('error')): ?>
                <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
            <?php endif;?>
            <div id="showMsg"></div>
        </div>
    </div>

    <!-- Tabs Navigation -->
    <ul class="nav nav-tabs" id="blocksTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= ($activeTab === 'definitions' ? 'active' : '') ?>" id="definitions-tab" data-bs-toggle="tab" data-bs-target="#definitions" type="button" role="tab">
                <i class="bi bi-puzzle"></i> Block Definitions
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= ($activeTab === 'item-types' ? 'active' : '') ?>" id="item-types-tab" data-bs-toggle="tab" data-bs-target="#item-types" type="button" role="tab">
                <i class="bi bi-tags"></i> Item Types
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= ($activeTab === 'blocks' ? 'active' : '') ?>" id="blocks-tab" data-bs-toggle="tab" data-bs-target="#blocks" type="button" role="tab">
                <i class="bi bi-grid-3x3"></i> Post Blocks
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= ($activeTab === 'items' ? 'active' : '') ?>" id="items-tab" data-bs-toggle="tab" data-bs-target="#items" type="button" role="tab">
                <i class="bi bi-list-check"></i> Block Items
            </button>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content card card-body" id="blocksTabContent">
        
        <!-- BLOCK DEFINITIONS TAB -->
        <div class="tab-pane fade <?= ($activeTab === 'definitions' ? 'show active' : '') ?>" id="definitions" role="tabpanel">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#addDefinitionModal">
                        <i class="bi bi-plus"></i> Add Definition
                    </button>
                </div>
                <div class="text-muted">
                    <small>Total: <?= count($blockDefinitions) ?> definitions</small>
                </div>
            </div>
            
            <div class="table-responsive">
                <table id="definitionsTable" class="table table-hover table-sm">
                    <thead class="bg-primary bg-opacity-10">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Slug</th>
                            <th>Category</th>
                            <th>Icon</th>
                            <th>Repeatable</th>
                            <th>Max Instances</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($blockDefinitions) && count($blockDefinitions) > 0): ?>
                            <?php foreach($blockDefinitions as $def): ?>
                                <tr>
                                    <td><span class="badge bg-info"><?= $def['id'] ?></span></td>
                                    <td>
                                        <strong><?= esc($def['name']) ?></strong>
                                        <?php if(!empty($def['description'])): ?>
                                            <br><small class="text-muted"><?= esc($def['description']) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td><code><?= $def['slug'] ?></code></td>
                                    <td><span class="badge bg-secondary"><?= $def['category'] ?></span></td>
                                    <td>
                                        <?php if(!empty($def['icon'])): ?>
                                            <i class="<?= $def['icon'] ?>" title="<?= $def['icon'] ?>"></i>
                                        <?php else: ?>
                                            <i class="bi bi-square text-muted"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?= $def['is_repeatable'] ?
                                            '<span class="badge bg-success">Yes</span>' :
                                            '<span class="badge bg-secondary">No</span>' ?>
                                    </td>
                                    <td>
                                        <?= $def['max_instances'] ?
                                            '<span class="badge bg-info">'.$def['max_instances'].'</span>' :
                                            '<span class="badge bg-light text-dark">Unlimited</span>' ?>
                                    </td>
                                    <td>
                                        <?= $def['is_active'] ?
                                            '<span class="badge bg-success">Active</span>' :
                                            '<span class="badge bg-secondary">Inactive</span>' ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary edit-definition" 
                                                    data-id="<?= $def['id'] ?>"
                                                    title="Edit Definition">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-danger delete-definition"
                                                    data-id="<?= $def['id'] ?>"
                                                    data-name="<?= esc($def['name']) ?>"
                                                    title="Delete Definition">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center py-4">
                                    <i class="bi bi-inbox display-4 text-muted"></i>
                                    <p class="mt-2">No block definitions found</p>
                                    <button class="btn btn-sm btn-success mt-2" data-bs-toggle="modal" data-bs-target="#addDefinitionModal">
                                        <i class="bi bi-plus"></i> Add Your First Definition
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- ITEM TYPES TAB -->
        <div class="tab-pane fade <?= ($activeTab === 'item-types' ? 'show active' : '') ?>" id="item-types" role="tabpanel">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#addItemTypeModal">
                        <i class="bi bi-plus"></i> Add Item Type
                    </button>
                </div>
                <div class="text-muted">
                    <small>Total: <?= count($itemTypeDefinitions ?? []) ?> item types</small>
                </div>
            </div>
            
            <div class="table-responsive">
                <table id="itemTypesTable" class="table table-hover table-sm">
                    <thead class="bg-primary bg-opacity-10">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Slug</th>
                            <th>Description</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($itemTypeDefinitions) && count($itemTypeDefinitions) > 0): ?>
                            <?php foreach($itemTypeDefinitions as $itemType): ?>
                                <tr>
                                    <td><span class="badge bg-info"><?= $itemType['id'] ?></span></td>
                                    <td><strong><?= esc($itemType['name']) ?></strong></td>
                                    <td><code><?= $itemType['slug'] ?></code></td>
                                    <td><?= esc($itemType['description'] ?? '-') ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button type="button" class="btn btn-outline-info view-item-type"
                                                    data-id="<?= $itemType['id'] ?>"
                                                    title="View Item Type">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-outline-primary edit-item-type"
                                                    data-id="<?= $itemType['id'] ?>"
                                                    title="Edit Item Type">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-danger delete-item-type"
                                                    data-id="<?= $itemType['id'] ?>"
                                                    data-name="<?= esc($itemType['name']) ?>"
                                                    title="Delete Item Type">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center py-4">
                                    <i class="bi bi-tags display-4 text-muted"></i>
                                    <p class="mt-2">No item types found</p>
                                    <button class="btn btn-sm btn-success mt-2" data-bs-toggle="modal" data-bs-target="#addItemTypeModal">
                                        <i class="bi bi-plus"></i> Add Your First Item Type
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- POST BLOCKS TAB -->
        <div class="tab-pane fade <?= ($activeTab === 'blocks' ? 'show active' : '') ?>" id="blocks" role="tabpanel">
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="form-label">Filter by Post</label>
                    <select class="form-select" id="filterByPost">
                        <option value="">All Posts</option>
                        <?php if(isset($allPosts)): ?>
                            <?php foreach($allPosts as $post): ?>
                                <option value="<?= $post['id'] ?>"><?= esc($post['title']) ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Filter by Status</label>
                    <select class="form-select" id="filterByStatus">
                        <option value="">All Status</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button class="btn btn-sm btn-success add-block" data-post-id="">
                        <i class="bi bi-plus"></i> Add Block to Post
                    </button>
                </div>
            </div>
            
            <div class="table-responsive">
                <table id="blocksTable" class="table table-hover table-sm">
                    <thead class="bg-primary bg-opacity-10">
                        <tr>
                            <th>#</th>
                            <th>Post</th>
                            <th>Block Type</th>
                            <th>Category</th>
                            <th>Heading</th>
                            <th>Order</th>
                            <th>Items</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($postBlocks) && count($postBlocks) > 0): ?>
                            <?php foreach($postBlocks as $block): ?>
                                <tr data-post-id="<?= $block->post_id ?>" data-status="<?= $block->status ?>">
                                    <td><span class="badge bg-info"><?= $block->id ?></span></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div>
                                                <strong class="d-block"><?= esc($block->post_title ?? 'N/A') ?></strong>
                                                <small class="text-muted">ID: <?= $block->post_id ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <code><?= $block->block_type ?></code>
                                        <?php 
                                        // Get definition name if available
                                        $defName = '';
                                        if(isset($blockDefinitions)) {
                                            foreach($blockDefinitions as $def) {
                                                if($def['slug'] == $block->block_type) {
                                                    $defName = $def['name'];
                                                    break;
                                                }
                                            }
                                        }
                                        if($defName): ?>
                                            <br><small class="text-muted"><?= esc($defName) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td><span class="badge bg-secondary"><?= $block->block_cat ?></span></td>
                                    <td><?= esc($block->heading ?? '-') ?></td>
                                    <td>
                                        <span class="badge bg-primary"><?= $block->ordering ?></span>
                                        <button class="btn btn-sm btn-outline-secondary ms-1 change-order" 
                                                data-id="<?= $block->id ?>" 
                                                data-current="<?= $block->ordering ?>"
                                                title="Change Order">
                                            <i class="bi bi-arrow-up-down"></i>
                                        </button>
                                    </td>
                                    <td>
                                        <span class="badge bg-success"><?= $block->items_count ?? 0 ?></span>
                                        <?php if(($block->items_count ?? 0) > 0): ?>
                                            <button class="btn btn-sm btn-outline-info ms-1 view-items" 
                                                    data-block-id="<?= $block->id ?>"
                                                    title="View Items">
                                                <i class="bi bi-list"></i>
                                            </button>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?= ($block->status == 'active') ? 
                                            '<span class="badge bg-success">Active</span>' : 
                                            '<span class="badge bg-secondary">Inactive</span>' ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button type="button" 
                                               class="btn btn-outline-info view-block" 
                                               data-id="<?= $block->id ?>" 
                                               title="View Block">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-outline-primary edit-block" 
                                                    data-id="<?= $block->id ?>"
                                                    title="Edit Block">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-success add-item" 
                                                    data-block-id="<?= $block->id ?>"
                                                    data-block-type="<?= $block->block_type ?>"
                                                    title="Add Item">
                                                <i class="bi bi-plus-circle"></i>
                                            </button>
                                            <button class="btn btn-outline-danger delete-block" 
                                                    data-id="<?= $block->id ?>" 
                                                    data-title="<?= esc($block->post_title ?? 'Block') ?>"
                                                    title="Delete Block">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center py-4">
                                    <i class="bi bi-inbox display-4 text-muted"></i>
                                    <p class="mt-2">No post blocks found</p>
                                    <button class="btn btn-sm btn-success mt-2 add-block" data-post-id="">
                                        <i class="bi bi-plus"></i> Add Your First Block
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- BLOCK ITEMS TAB -->
        <div class="tab-pane fade <?= ($activeTab === 'items' ? 'show active' : '') ?>" id="items" role="tabpanel">
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="form-label">Filter by Block</label>
                    <select class="form-select" id="filterByBlock">
                        <option value="">All Blocks</option>
                        <?php if(isset($postBlocks)): ?>
                            <?php foreach($postBlocks as $block): ?>
                                <option value="<?= $block->id ?>">
                                    Block #<?= $block->id ?> - <?= $block->block_type ?>
                                    <?php if(isset($block->post_title)): ?>
                                        (<?= esc($block->post_title) ?>)
                                    <?php endif; ?>
                                </option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Filter by Type</label>
                    <select class="form-select" id="filterByType">
                        <option value="">All Types</option>
                        <?php if (isset($availableItemTypes) && !empty($availableItemTypes)): ?>
                            <?php foreach ($availableItemTypes as $type): ?>
                                <option value="<?= esc($type['slug']) ?>"><?= esc($type['name']) ?></option>
                            <?php endforeach; ?>
                        <?php elseif (isset($itemTypeDefinitions) && !empty($itemTypeDefinitions)): ?>
                            <?php foreach ($itemTypeDefinitions as $type): ?>
                                <option value="<?= esc($type['slug']) ?>"><?= esc($type['name']) ?></option>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <!-- Fallback static options if no definitions available -->
                            <option value="cards">Cards</option>
                            <option value="text">Text</option>
                            <option value="image">Image</option>
                            <option value="code">Code</option>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button class="btn btn-sm btn-success" id="addItemBtn">
                        <i class="bi bi-plus"></i> Add New Item
                    </button>
                </div>
            </div>
            
            <div class="table-responsive">
                <table id="itemsTable" class="table table-hover table-sm">
                    <thead class="bg-primary bg-opacity-10">
                        <tr>
                            <th>#</th>
                            <th>Block</th>
                            <th>Type</th>
                            <th>Title</th>
                            <th>Icon</th>
                            <th>Order</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                   <tbody>
                        <?php if(isset($blockItems) && count($blockItems) > 0): ?>
                            <?php foreach($blockItems as $item): ?>
                                <tr data-block-id="<?= $item['block_id'] ?>" data-item-type="<?= $item['item_type'] ?>">
                                    <td><span class="badge bg-info"><?= $item['id'] ?></span></td>
                                    <td>
                                        <span class="badge bg-secondary">#<?= $item['block_id'] ?></span>
                                        <?php 
                                        // Get block type for display
                                        $blockType = '';
                                        if(isset($postBlocks)) {
                                            foreach($postBlocks as $block) {
                                                if($block->id == $item['block_id']) {
                                                    $blockType = $block->block_type;
                                                    break;
                                                }
                                            }
                                        }
                                        if($blockType): ?>
                                            <br><small class="text-muted"><?= $blockType ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <code><?= $item['item_type'] ?></code>
                                    </td>
                                    <td>
                                        <?= esc($item['title'] ?? '-') ?>
                                        <?php if(!empty($item['description'])): ?>
                                            <br><small class="text-muted"><?= esc(substr($item['description'], 0, 50)) ?>...</small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($item['icon'])): ?>
                                            <i class="<?= $item['icon'] ?>" title="<?= $item['icon'] ?>"></i>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary"><?= $item['ordering'] ?? 0 ?></span>
                                        <button class="btn btn-sm btn-outline-secondary ms-1 change-item-order" 
                                                data-id="<?= $item['id'] ?>" 
                                                data-current="<?= $item['ordering'] ?? 0 ?>"
                                                title="Change Order">
                                            <i class="bi bi-arrow-up-down"></i>
                                        </button>
                                    </td>
                                    <td>
                                        <?= ($item['status'] == 'active') ? 
                                            '<span class="badge bg-success">Active</span>' : 
                                            '<span class="badge bg-secondary">Inactive</span>' ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary edit-item" 
                                                    data-id="<?= $item['id'] ?>"
                                                    title="Edit Item">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-info view-item" 
                                                    data-id="<?= $item['id'] ?>"
                                                    title="View Details">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-outline-danger delete-item" 
                                                    data-id="<?= $item['id'] ?>" 
                                                    data-title="<?= esc($item['title'] ?? 'Item') ?>"
                                                    title="Delete Item">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <i class="bi bi-inbox display-4 text-muted"></i>
                                    <p class="mt-2">No block items found</p>
                                    <button class="btn btn-sm btn-success mt-2" id="addItemBtn">
                                        <i class="bi bi-plus"></i> Add Your First Item
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
            <!-- View Single Item Modal -->
            <div class="modal fade" id="viewItemModal" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Item Details</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <table class="table table-sm table-borderless">
                                        <tr><th width="30%">ID</th><td id="viewItemId"></td></tr>
                                        <tr><th>Block</th><td id="viewItemBlock"></td></tr>
                                        <tr><th>Type</th><td id="viewItemType"></td></tr>
                                        <tr><th>Title</th><td id="viewItemTitle"></td></tr>
                                        <tr><th>Description</th><td id="viewItemDescription"></td></tr>
                                        <tr><th>Link</th><td id="viewItemLink"></td></tr>
                                        <tr><th>Icon</th><td id="viewItemIcon"></td></tr>
                                        <tr><th>Order</th><td id="viewItemOrder"></td></tr>
                                        <tr><th>Status</th><td id="viewItemStatus"></td></tr>
                                    </table>
                                </div>
                                <div class="col-md-4 text-center">
                                    <div style="height:150px; display:flex; align-items:center; justify-content:center;">
                                        <img id="viewItemImage" src="" class="img-fluid img-thumbnail" style="max-height:140px; display:none;" alt="Item Image">
                                        <div id="viewItemImagePlaceholder" class="text-muted">No image</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

<!-- Add Definition Modal -->
<div class="modal fade" id="addDefinitionModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Block Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addDefinitionForm" method="POST" action="<?= base_url('administrator/posts/blocks/definition/add') ?>">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="row">
                        <!-- Main Content -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Name</strong> <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="name" required>
                                        <div class="form-text">The display name for this block type.</div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Slug</strong> <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control bg-light" name="slug" required readonly>
                                        <div class="form-text">Unique identifier (auto-generated from name).</div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Description</strong></label>
                                        <textarea class="form-control" name="description" rows="3" placeholder="Brief description of this block type"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Sidebar -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header"><strong>Attributes</strong></div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Status</strong></label>
                                        <select class="form-select" name="is_active">
                                            <option value="1">Active</option>
                                            <option value="0">Inactive</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Category</strong></label>
                                        <select class="form-select" name="category">
                                            <?php if(isset($serviceGroups) && !empty($serviceGroups)): ?>
                                                <?php foreach($serviceGroups as $sg): ?>
                                                    <option value="<?= esc($sg['slug']) ?>"><?= esc($sg['name']) ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Icon</strong></label>
                                        <div class="icon-preview-wrapper">
                                            <span id="addIconPreview" class="icon-preview"><i class="bi bi-square"></i></span>
                                            <input type="hidden" name="icon" id="addDefinitionIcon">
                                            <button type="button" class="btn btn-sm btn-outline-secondary" id="showAddIconPicker">Select Icon</button>
                                            <div id="addIconPickerContainer" class="icon-picker-container" style="display: none;"></div>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Repeatable</strong></label>
                                        <select class="form-select" name="is_repeatable">
                                            <option value="1">Yes - Multiple instances allowed</option>
                                            <option value="0">No - Single instance only</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Max Instances</strong></label>
                                        <input type="number" class="form-control" name="max_instances" min="0" placeholder="0 for unlimited">
                                        <div class="form-text">Set to 0 for unlimited instances.</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12">
                             <div class="card">
                                <div class="card-header"><strong>Allowed Item Types</strong></div>
                                <div class="card-body">
                                    <p class="card-text">Select which item types can be added to this block.</p>
                                    <div class="row g-2" id="addItemTypesCheckboxes">
                                        <?php if(isset($availableItemTypes) && !empty($availableItemTypes)): ?>
                                            <?php foreach($availableItemTypes as $itemType): ?>
                                                <div class="col-md-4 col-sm-6">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" name="item_types[]" id="addItemType_<?= esc($itemType['id']) ?>" value="<?= esc($itemType['id']) ?>">
                                                        <label class="form-check-label" for="addItemType_<?= esc($itemType['id']) ?>"><?= esc($itemType['name']) ?></label>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <p class="text-muted">No item types defined yet. Please add item types first.</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                             </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Create Definition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Definition Modal -->
<div class="modal fade" id="editDefinitionModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Block Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editDefinitionForm" method="POST" action="<?= base_url('administrator/posts/blocks/definition/update') ?>">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="row">
                        <!-- Main Content -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Name</strong> <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="name" required>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Slug</strong> <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control bg-light" name="slug" required readonly>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Description</strong></label>
                                        <textarea class="form-control" name="description" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Sidebar -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header"><strong>Attributes</strong></div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Status</strong></label>
                                        <select class="form-select" name="is_active">
                                            <option value="1">Active</option>
                                            <option value="0">Inactive</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Category</strong></label>
                                        <select class="form-select" name="category">
                                            <?php if(isset($serviceGroups) && !empty($serviceGroups)): ?>
                                                <?php foreach($serviceGroups as $sg): ?>
                                                    <option value="<?= esc($sg['slug']) ?>"><?= esc($sg['name']) ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Icon</strong></label>
                                        <div class="icon-preview-wrapper">
                                            <span id="editIconPreview" class="icon-preview"><i class="bi bi-square"></i></span>
                                            <input type="hidden" name="icon" id="editDefinitionIcon">
                                            <button type="button" class="btn btn-sm btn-outline-secondary" id="showEditIconPicker">Select Icon</button>
                                            <div id="editIconPickerContainer" class="icon-picker-container" style="display: none;"></div>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Repeatable</strong></label>
                                        <select class="form-select" name="is_repeatable">
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Max Instances</strong></label>
                                        <input type="number" class="form-control" name="max_instances" min="0" placeholder="0 for unlimited">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12">
                             <div class="card">
                                <div class="card-header"><strong>Allowed Item Types</strong></div>
                                <div class="card-body">
                                    <div class="row g-2" id="editItemTypesCheckboxes">
                                        <?php if(isset($availableItemTypes) && !empty($availableItemTypes)): ?>
                                            <?php foreach($availableItemTypes as $itemType): ?>
                                                <div class="col-md-4 col-sm-6">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" name="item_types[]" id="editItemType_<?= esc($itemType['id']) ?>" value="<?= esc($itemType['id']) ?>">
                                                        <label class="form-check-label" for="editItemType_<?= esc($itemType['id']) ?>"><?= esc($itemType['name']) ?></label>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                             </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Update Definition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Item Type Modal -->
<div class="modal fade" id="addItemTypeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Item Type Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addItemTypeForm" method="POST" action="<?= base_url('administrator/posts/blocks/item-type/add') ?>">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><strong>Name</strong> <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" required>
                            <div class="form-text">The display name for this item type.</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><strong>Slug</strong> <span class="text-danger">*</span></label>
                            <input type="text" class="form-control bg-light" name="slug" required readonly>
                            <div class="form-text">Unique identifier (auto-generated).</div>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label"><strong>Description</strong></label>
                            <textarea class="form-control" name="description" rows="2" placeholder="Brief description of this item type"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Create Item Type
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Item Type Modal -->
<div class="modal fade" id="editItemTypeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Item Type Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editItemTypeForm" method="POST" action="<?= base_url('administrator/posts/blocks/item-type/update') ?>">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><strong>Name</strong> <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><strong>Slug</strong> <span class="text-danger">*</span></label>
                            <input type="text" class="form-control bg-light" name="slug" required readonly>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label"><strong>Description</strong></label>
                            <textarea class="form-control" name="description" rows="2"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Update Item Type
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Item Type Modal -->
<div class="modal fade" id="viewItemTypeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">View Item Type Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="border-bottom pb-2">Item Type Information</h6>
                        <table class="table table-sm table-borderless">
                            <tr>
                                <th width="30%">ID</th>
                                <td id="viewItemTypeId"></td>
                            </tr>
                            <tr>
                                <th>Name</th>
                                <td id="viewItemTypeName"></td>
                            </tr>
                            <tr>
                                <th>Slug</th>
                                <td><code id="viewItemTypeSlug"></code></td>
                            </tr>
                            <tr>
                                <th>Description</th>
                                <td id="viewItemTypeDescription"></td>
                            </tr>
                            <tr>
                                <th>Created</th>
                                <td id="viewItemTypeCreated"></td>
                            </tr>
                            <tr>
                                <th>Updated</th>
                                <td id="viewItemTypeUpdated"></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6 class="border-bottom pb-2">Configuration</h6>
                        <div id="viewItemTypeConfig">
                            <!-- Configuration details will be loaded here -->
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary edit-item-type-btn">
                    <i class="bi bi-pencil"></i> Edit Item Type
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Add Block Modal -->
<div class="modal fade" id="addBlockModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Block to Post</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addBlockForm" method="POST" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="row">
                        <!-- Main Content -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label"><strong>Post</strong> <span class="text-danger">*</span></label>
                                            <select class="form-select" name="post_id" required>
                                                <option value="">Select a Post</option>
                                                <?php if(isset($allPosts)): ?>
                                                    <?php foreach($allPosts as $post): ?>
                                                        <option value="<?= $post['id'] ?>"><?= esc($post['title']) ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label"><strong>Block Definition</strong> <span class="text-danger">*</span></label>
                                            <select class="form-select" name="definition_id" required>
                                                <option value="">Select Definition</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Heading</strong></label>
                                        <input type="text" class="form-control" name="heading" placeholder="Optional block heading">
                                    </div>
                                     <div class="mb-3">
                                        <label class="form-label">Title Emphasized</label>
                                        <input type="text" class="form-control" name="title_emphasized" placeholder="Optional emphasized title text">
                                    </div>
                                     <div class="mb-3">
                                        <label class="form-label">Heading Type</label>
                                        <select class="form-select" name="heading_type">
                                            <option value="">Default</option>
                                            <option value="h1">H1</option> <option value="h2">H2</option> <option value="h3">H3</option>
                                            <option value="h4">H4</option> <option value="h5">H5</option> <option value="h6">H6</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Heading Color</label>
                                        <input type="color" class="form-control form-control-color" name="color" value="#000000" title="Choose heading color">
                                    </div>
                                     <div class="mb-3">
                                        <label class="form-label">Subtitle</label>
                                        <input type="text" class="form-control" name="subtitle" placeholder="Optional subtitle for the block">
                                    </div>
                                   
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Content</strong></label>
                                        <textarea class="form-control" name="content" rows="5" placeholder="Block content (if applicable)"></textarea>
                                    </div>

                                    <div class="accordion" id="addBlockAccordion">
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="addBlockCodeHeading">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#addBlockCodeCollapse">
                                                    Advanced: Custom Code & Adverts
                                                </button>
                                            </h2>
                                            <div id="addBlockCodeCollapse" class="accordion-collapse collapse" data-bs-parent="#addBlockAccordion">
                                                <div class="accordion-body">
                                                       <div class="mb-3">
                                                            <label class="form-label">Custom Classes</label>
                                                            <input type="text" class="form-control" name="custom_classes" placeholder="e.g. my-class another-class">
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">Custom CSS</label>
                                                            <textarea class="form-control" name="custom_css" rows="3" placeholder="Optional CSS to apply to this block"></textarea>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">Settings (JSON)</label>
                                                            <textarea class="form-control" name="settings" rows="3" placeholder='Optional JSON settings, e.g. {"key":"value"}'></textarea>
                                                        </div>
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Custom Code / HTML</strong></label>
                                                        <textarea class="form-control" name="code" rows="4" placeholder="Optional raw HTML or code for this block"></textarea>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Advert Code</strong></label>
                                                        <textarea class="form-control" name="advert_code" rows="3" placeholder="Optional advert/snippet code"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Sidebar -->
                        <div class="col-md-4">
                            <div class="card mb-3">
                                <div class="card-header"><strong>Attributes</strong></div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Status</strong></label>
                                        <select class="form-select" name="status">
                                            <option value="active">Active</option>
                                            <option value="inactive">Inactive</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Category</strong></label>
                                        <select class="form-select" name="block_cat">
                                            <option value="content">Content</option>
                                            <option value="header">Header</option>
                                            <option value="footer">Footer</option>
                                            <option value="sidebar">Sidebar</option>
                                            <option value="navigation">Navigation</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Order</strong></label>
                                        <input type="number" class="form-control" name="ordering" value="0" min="0">
                                    </div>
                                </div>
                            </div>
                            <div class="card mb-3">
                                <div class="card-header"><strong>Display Options</strong></div>
                                <div class="card-body">
                                   
                                    <div class="mb-3">
                                        <label class="form-label">List Type</label>
                                        <select class="form-select" name="list_type">
                                            <option value="none">None</option>
                                            <option value="ordered">Ordered</option>
                                            <option value="unordered">Unordered</option>
                                        </select>
                                    </div>
                                   
                                 
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header"><strong>Featured Image</strong></div>
                                <div class="card-body">
                                    <div class="image-preview-box mb-2" style="height: 150px; background: #F2F9FF; border-radius: 5px; display: flex; align-items: center; justify-content: center; text-align: center; overflow: hidden;">
                                        <img src="" class="img-fluid img-thumbnail block-image-preview" style="max-height: 100%; display: none;" alt="Image Preview">
                                        <small class="text-muted preview-text">Image Preview</small>
                                    </div>
                                    <input type="file" class="form-control block-photo-input" name="photo" accept="image/*">
                                    <div class="mb-2 mt-2">
                                        <label class="form-label">Caption / Image Alt</label>
                                        <input type="text" class="form-control" name="caption" placeholder="Optional caption or alt text">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Add Block
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Edit Block Modal -->
<div class="modal fade" id="editBlockModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Block</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editBlockForm" method="POST" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="row">
                        <!-- Main Content -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Heading</strong></label>
                                        <input type="text" class="form-control" name="heading" placeholder="Optional block heading">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Title Emphasized</label>
                                        <input type="text" class="form-control" name="title_emphasized" placeholder="Optional emphasized title text">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Heading Type</label>
                                        <select class="form-select" name="heading_type">
                                            <option value="">Default</option>
                                            <option value="h1">H1</option> <option value="h2">H2</option> <option value="h3">H3</option>
                                            <option value="h4">H4</option> <option value="h5">H5</option> <option value="h6">H6</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Heading Color</label>
                                        <input type="color" class="form-control form-control-color" name="color" value="#000000" title="Choose heading color">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Subtitle</label>
                                        <input type="text" class="form-control" name="subtitle" placeholder="Optional subtitle for the block">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Content</strong></label>
                                        <textarea class="form-control" name="content" rows="5" placeholder="Block content (if applicable)"></textarea>
                                    </div>

                                    <div class="accordion" id="editBlockAccordion">
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="editBlockCodeHeading">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#editBlockCodeCollapse">
                                                    Advanced: Custom Code & Adverts
                                                </button>
                                            </h2>
                                            <div id="editBlockCodeCollapse" class="accordion-collapse collapse" data-bs-parent="#editBlockAccordion">
                                                <div class="accordion-body">
                                                    <div class="mb-3">
                                                        <label class="form-label">Custom Classes</label>
                                                        <input type="text" class="form-control" name="custom_classes" placeholder="e.g. my-class another-class">
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">Custom CSS</label>
                                                        <textarea class="form-control" name="custom_css" rows="3" placeholder="Optional CSS to apply to this block"></textarea>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">Settings (JSON)</label>
                                                        <textarea class="form-control" name="settings" rows="3" placeholder='Optional JSON settings, e.g. {"key":"value"}'></textarea>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Custom Code / HTML</strong></label>
                                                        <textarea class="form-control" name="code" rows="4" placeholder="Optional raw HTML or code for this block"></textarea>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label"><strong>Advert Code</strong></label>
                                                        <textarea class="form-control" name="advert_code" rows="3" placeholder="Optional advert/snippet code"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Sidebar -->
                        <div class="col-md-4">
                            <div class="card mb-3">
                                <div class="card-header"><strong>Attributes</strong></div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Status</strong></label>
                                        <select class="form-select" name="status">
                                            <option value="active">Active</option>
                                            <option value="inactive">Inactive</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Category</strong></label>
                                        <select class="form-select" name="block_cat">
                                            <option value="content">Content</option>
                                            <option value="header">Header</option>
                                            <option value="footer">Footer</option>
                                            <option value="sidebar">Sidebar</option>
                                            <option value="navigation">Navigation</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Order</strong></label>
                                        <input type="number" class="form-control" name="ordering" value="0" min="0">
                                    </div>
                                </div>
                            </div>
                            <div class="card mb-3">
                                <div class="card-header"><strong>Display Options</strong></div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label">List Type</label>
                                        <select class="form-select" name="list_type">
                                            <option value="none">None</option>
                                            <option value="ordered">Ordered</option>
                                            <option value="unordered">Unordered</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header"><strong>Featured Image</strong></div>
                                <div class="card-body">
                                    <div class="image-preview-box mb-2" style="height: 150px; background: #F2F9FF; border-radius: 5px; display: flex; align-items: center; justify-content: center; text-align: center; overflow: hidden;">
                                        <img src="" class="img-fluid img-thumbnail block-image-preview" style="max-height: 100%; display: none;" alt="Image Preview">
                                        <small class="text-muted preview-text">Image Preview</small>
                                    </div>
                                    <input type="file" class="form-control block-photo-input" name="photo" accept="image/*">
                                    <div class="mb-2 mt-2">
                                        <label class="form-label">Caption / Image Alt</label>
                                        <input type="text" class="form-control" name="caption" placeholder="Optional caption or alt text">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Update Block
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Add/Edit Item Modal -->
<div class="modal fade" id="itemModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add/Edit Block Item</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="itemForm" method="POST" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="row">
                        <!-- Main Content -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label"><strong>Block</strong> <span class="text-danger">*</span></label>
                                            <select class="form-select" name="block_id" required>
                                                <option value="">Select Block</option>
                                                <?php if(isset($postBlocks)): ?>
                                                    <?php foreach($postBlocks as $block): ?>
                                                        <option value="<?= $block->id ?>" data-type="<?= $block->block_type ?>">
                                                            #<?= $block->id ?> - <?= $block->block_type ?> (<?= esc($block->post_title ?? 'N/A') ?>)
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label"><strong>Item Type</strong> <span class="text-danger">*</span></label>
                                            <select class="form-select" name="item_type" required>
                                                <option value="">Select Item Type</option>
                                                <?php if(isset($availableItemTypes)): ?>
                                                    <?php foreach($availableItemTypes as $type): ?>
                                                        <option value="<?= $type['slug'] ?>" data-description="<?= esc($type['description']) ?>" data-icon="<?= esc($type['icon']) ?>" data-fields="<?= esc($type['fields_config']) ?>" data-settings="<?= esc($type['settings_config']) ?>">
                                                            <?= esc($type['name']) ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                            <div class="form-text">Determines available fields below.</div>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Title</strong> <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="title" required placeholder="Item title">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Description</strong></label>
                                        <textarea class="form-control" name="description" rows="3" placeholder="Item description"></textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Link</strong></label>
                                        <input type="url" class="form-control" name="link" placeholder="https://example.com">
                                    </div>
                                    <hr>
                                    <div id="dynamicFields" class="mt-3">
                                        <p class="text-muted">Select an item type to see additional fields.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Sidebar -->
                        <div class="col-md-4">
                            <div class="card mb-3">
                                <div class="card-header"><strong>Attributes</strong></div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Status</strong></label>
                                        <select class="form-select" name="status">
                                            <option value="active">Active</option>
                                            <option value="inactive">Inactive</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Order</strong></label>
                                        <input type="number" class="form-control" name="ordering" value="0" min="0">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Icon</strong></label>
                                        <div class="icon-preview-wrapper">
                                            <span class="icon-preview item-icon-preview"><i class="bi bi-square"></i></span>
                                            <input type="hidden" name="icon" class="item-icon-input">
                                            <button type="button" class="btn btn-sm btn-outline-secondary show-item-icon-picker">Select Icon</button>
                                            <div class="icon-picker-container item-icon-picker" style="display: none;"></div>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Width</strong></label>
                                        <input type="text" class="form-control" name="width" placeholder="e.g., 100%, 300px">
                                        <div class="form-text">Optional CSS width value.</div>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header"><strong>Item Image</strong></div>
                                <div class="card-body">
                                    <div class="image-preview-box mb-2" style="height: 150px; background: #F2F9FF; border-radius: 5px; display: flex; align-items: center; justify-content: center; text-align: center; overflow: hidden;">
                                        <img src="" class="img-fluid img-thumbnail item-image-preview" style="max-height: 100%; display: none;" alt="Image Preview">
                                        <small class="text-muted preview-text">Image Preview</small>
                                    </div>
                                    <input type="file" class="form-control item-photo-input" name="photo" accept="image/*">
                                    <div class="mb-2 mt-2">
                                        <label class="form-label">Image Alt</label>
                                        <input type="text" class="form-control" name="photo_alt" placeholder="Alt text for image">
                                    </div>
                                    <div class="mb-2">
                                        <label class="form-label">Image Caption</label>
                                        <input type="text" class="form-control" name="photo_caption" placeholder="Caption (optional)">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Save Item
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Change Order Modal -->
<div class="modal fade" id="changeOrderModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Change Order</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="changeOrderForm" method="POST">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <input type="hidden" name="type"> <!-- block or item -->
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><strong>New Order Position</strong></label>
                        <input type="number" class="form-control" name="ordering" min="0" required>
                        <div class="form-text">Lower numbers appear first.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Order</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Block Details Modal -->
<div class="modal fade" id="viewBlockModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Block Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-7">
                        <h6 class="border-bottom pb-2 mb-3">Block Information</h6>
                        <table class="table table-sm table-borderless">
                            <tr>
                                <th width="30%">Post</th>
                                <td id="blockPostTitle"></td>
                            </tr>
                            <tr>
                                <th>Block Type</th>
                                <td><code id="blockType"></code></td>
                            </tr>
                            <tr>
                                <th>Definition</th>
                                <td>
                                    <span id="blockDefinitionName"></span>
                                    <small id="blockDefinitionDesc" class="text-muted d-block"></small>
                                </td>
                            </tr>
                            <tr>
                                <th>Category</th>
                                <td><span id="blockCategory" class="badge"></span></td>
                            </tr>
                            <tr>
                                <th>Heading</th>
                                <td id="blockHeading"></td>
                            </tr>
                            <tr>
                                <th>Order</th>
                                <td id="blockOrder"></td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td id="blockStatus"></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-5">
                        <h6 class="border-bottom pb-2 mb-3">Block Items</h6>
                        <div id="blockItemsContainer" style="max-height: 400px; overflow-y: auto;">
                            <!-- Items will be loaded here -->
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary edit-block-btn">
                    <i class="bi bi-pencil"></i> Edit Block
                </button>
            </div>
        </div>
    </div>
</div>

<!-- View Items Modal -->
<div class="modal fade" id="viewItemsModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Block Items</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="itemsListContainer">
                    <!-- Items will be loaded here via AJAX -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Custom Confirmation Modal -->
<div class="modal fade" id="confirmationModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="confirmationModalTitle">
                    <i class="bi bi-exclamation-triangle text-warning me-2"></i>
                    Confirm Action
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="d-flex align-items-start">
                    <div class="flex-shrink-0">
                        <i class="bi bi-question-circle display-6 text-primary"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 id="confirmationMessage">Are you sure you want to proceed?</h6>
                        <p class="text-muted mb-0" id="confirmationDetails">
                            This action cannot be undone.
                        </p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-circle me-1"></i> Cancel
                </button>
                <button type="button" class="btn btn-danger" id="confirmActionBtn">
                    <i class="bi bi-check-circle me-1"></i> Confirm
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Success Toast Notification -->
<div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="successToast" class="toast align-items-center text-bg-success border-0" role="alert">
        <div class="d-flex">
            <div class="toast-body">
                <i class="bi bi-check-circle-fill me-2"></i>
                <span id="toastMessage">Operation completed successfully!</span>
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
        </div>
    </div>
</div>
<script>
// Global base_url variable
var base_url = '<?= base_url() ?>';

// Enhanced Block Management System with Modern Modals
const BlockSystem = {
    init: function() {
        this.initDataTables();
        this.bindEvents();
        this.initSlugGeneration();
        this.initIconPicker();
    },

    // Base AJAX method for all requests
    doAjax: function(url, method, data, successCallback, errorCallback) {
        return $.ajax({
            url: url,
            type: method,
            data: data,
            dataType: 'json',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: successCallback,
            error: (xhr, status, error) => {
                if (xhr.status === 403) {
                    this.showAlert('Your session has expired. The page will refresh to restore your session.', 'warning');
                    setTimeout(() => window.location.reload(), 2000);
                    return;
                }
                if (errorCallback) {
                    errorCallback(xhr, status, error);
                } else {
                    this.showAlert('An error occurred: ' + (xhr.responseJSON?.message || error), 'error');
                }
            }
        });
    },

    // Custom Confirmation Modal System
    showConfirmation: function(options) {
        return new Promise((resolve) => {
            const {
                title = 'Confirm Action',
                message,
                details = 'This action cannot be undone.',
                confirmText = 'Confirm',
                cancelText = 'Cancel',
                type = 'danger', // danger, warning, info, success
                icon = 'bi-exclamation-triangle'
            } = options;

            // Set modal content
            $('#confirmationModalTitle').html(`<i class="bi ${icon} text-${type} me-2"></i>${title}`);
            $('#confirmationMessage').text(message);
            $('#confirmationDetails').text(details);
            $('#confirmActionBtn')
                .text(confirmText)
                .removeClass('btn-danger btn-warning btn-info btn-success')
                .addClass(`btn-${type}`);

            // Update cancel button text
            $('.btn-secondary[data-bs-dismiss="modal"]').html(`<i class="bi bi-x-circle me-1"></i> ${cancelText}`);

            // Get modal instance
            const modal = new bootstrap.Modal(document.getElementById('confirmationModal'));
            
            // Remove previous event listeners
            $('#confirmActionBtn').off('click');
            $('#confirmationModal').off('hidden.bs.modal');

            // Handle confirm button click
            $('#confirmActionBtn').on('click', function() {
                modal.hide();
                resolve(true);
            });

            // Handle modal close
            $('#confirmationModal').on('hidden.bs.modal', function() {
                resolve(false);
            });

            // Show modal
            modal.show();
        });
    },

    // Show toast notification
    showToast: function(message, type = 'success') {
        const toastEl = document.getElementById('successToast');
        const toast = new bootstrap.Toast(toastEl);
        
        // Update toast content and style
        $('#toastMessage').text(message);
        // Use Bootstrap's `bg-*` utilities (this project uses Bootstrap 5.1)
        toastEl.className = `toast align-items-center bg-${type} border-0`;
        
        toast.show();
    },

    // Enhanced alert system with better styling
    showAlert: function(message, type = 'info', duration = 5000) {
        const alertClass = type === 'error' ? 'danger' : type;
        const iconClass = {
            'success': 'bi-check-circle-fill',
            'danger': 'bi-exclamation-triangle-fill',
            'warning': 'bi-exclamation-triangle-fill',
            'info': 'bi-info-circle-fill'
        }[alertClass] || 'bi-info-circle-fill';

        const alertHtml = `
            <div class="alert alert-${alertClass} alert-dismissible fade show" role="alert">
                <div class="d-flex align-items-center">
                    <i class="bi ${iconClass} me-2 flex-shrink-0"></i>
                    <div class="flex-grow-1">${message}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            </div>
        `;
        
        $('#showMsg').html(alertHtml);
        
        // Auto-dismiss after duration
        if (duration > 0) {
            setTimeout(() => {
                $('.alert').alert('close');
            }, duration);
        }
    },

    // Loading states for buttons
    setButtonLoading: function(button, isLoading) {
        if (isLoading) {
            button.prop('disabled', true);
            const originalText = button.html();
            button.data('original-text', originalText);
            button.html('<i class="spinner-border spinner-border-sm"></i> Processing...');
        } else {
            button.prop('disabled', false);
            const originalText = button.data('original-text');
            if (originalText) {
                button.html(originalText);
            }
        }
    },

    initDataTables: function() {
        $('#definitionsTable').DataTable();
        $('#blocksTable').DataTable();
        $('#itemsTable').DataTable();
        $('#itemTypesTable').DataTable();
    },

    initIconPicker: function() {
        const icons = [
            { class: 'bi bi-grid', name: 'Grid' },
            { class: 'bi bi-layout-text-window-reverse', name: 'Text Window' },
            { class: 'bi bi-image', name: 'Image' },
            { class: 'bi bi-card-text', name: 'Card Text' },
            { class: 'bi bi-file-code', name: 'Code' },
            { class: 'bi bi-list', name: 'List' },
            { class: 'bi bi-table', name: 'Table' },
            { class: 'bi bi-calendar', name: 'Calendar' },
            { class: 'bi bi-person', name: 'Person' },
            { class: 'bi bi-people', name: 'People' },
            { class: 'bi bi-gear', name: 'Gear' },
            { class: 'bi bi-tools', name: 'Tools' },
            { class: 'bi bi-info-circle', name: 'Info Circle' },
            { class: 'bi bi-check-circle', name: 'Check Circle' },
            { class: 'bi bi-x-circle', name: 'X Circle' },
            { class: 'bi bi-exclamation-triangle', name: 'Warning' },
            { class: 'bi bi-question-circle', name: 'Question' },
            { class: 'bi bi-folder', name: 'Folder' },
            { class: 'bi bi-file-earmark', name: 'File' },
            { class: 'bi bi-link-45deg', name: 'Link' },
        ];

        let iconGridHtml = '<div class="icon-grid">';
        icons.forEach(icon => {
            iconGridHtml += `<div class="icon-item" data-icon-class="${icon.class}" title="${icon.name}">
                                <i class="${icon.class}"></i>
                             </div>`;
        });
        iconGridHtml += '</div>';

        // Populate icon pickers for definitions
        $('#addIconPickerContainer').html(iconGridHtml);
        $('#editIconPickerContainer').html(iconGridHtml);

        // Toggle picker visibility for definitions
        $('#showAddIconPicker').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            $('#addIconPickerContainer').slideToggle();
            $('.icon-picker-container').not('#addIconPickerContainer').slideUp();
        });

        $('#showEditIconPicker').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            $('#editIconPickerContainer').slideToggle();
            $('.icon-picker-container').not('#editIconPickerContainer').slideUp();
        });

        // Close icon pickers when clicking outside
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.icon-preview-wrapper').length) {
                $('.icon-picker-container').slideUp();
            }
        });

        // Handle icon selection for definitions
        $('#addIconPickerContainer, #editIconPickerContainer').on('click', '.icon-item', function(e) {
            e.preventDefault();
            e.stopPropagation();
            const iconClass = $(this).data('icon-class');
            const container = $(this).closest('.icon-picker-container');

            // Update hidden input and preview
            if (container.attr('id') === 'addIconPickerContainer') {
                $('#addDefinitionIcon').val(iconClass);
                $('#addIconPreview').html(`<i class="${iconClass}"></i>`);
            } else {
                $('#editDefinitionIcon').val(iconClass);
                $('#editIconPreview').html(`<i class="${iconClass}"></i>`);
            }

            // Highlight selected and hide picker
            container.find('.icon-item').removeClass('selected');
            $(this).addClass('selected');
            container.slideUp();
        });
    },

    bindEvents: function() {
        // Modal focus management
        $('.modal').on('hidden.bs.modal', function () {
            if (this._lastFocusedElement) {
                this._lastFocusedElement.focus();
                delete this._lastFocusedElement;
            }
        });

        $('.modal').on('show.bs.modal', function (e) {
            this._lastFocusedElement = $(e.relatedTarget);
        });

        // Keyboard support for confirmation modal
        $(document).on('keydown', (e) => {
            const confirmationModal = document.getElementById('confirmationModal');
            if (confirmationModal.classList.contains('show')) {
                if (e.key === 'Escape') {
                    bootstrap.Modal.getInstance(confirmationModal).hide();
                } else if (e.key === 'Enter' && !e.shiftKey) {
                    e.preventDefault();
                    $('#confirmActionBtn').click();
                }
            }
        });

        // Block Definition Events
        $(document).on('click', '.edit-definition', this.editDefinition.bind(this));
        $(document).on('submit', '#addDefinitionForm', this.submitDefinitionForm.bind(this));
        $(document).on('submit', '#editDefinitionForm', this.submitDefinitionForm.bind(this));
        $(document).on('click', '.delete-definition', this.deleteDefinition.bind(this));

        // Post Block Events
        $(document).on('click', '.add-block', this.showAddBlockModal.bind(this));
        $(document).on('click', '.edit-block', this.editBlock.bind(this));
        $(document).on('submit', '#addBlockForm', this.submitBlockForm.bind(this));
        $(document).on('submit', '#editBlockForm', this.submitBlockForm.bind(this));
        $(document).on('click', '.delete-block', this.deleteBlock.bind(this));
        $(document).on('change', '#filterByPost, #filterByStatus', this.filterBlocks.bind(this));
        $(document).on('click', '.change-order', this.showChangeOrderModal.bind(this));
        $(document).on('submit', '#changeOrderForm', this.submitOrderChange.bind(this));
        $(document).on('click', '.view-items', this.viewBlockItems.bind(this));
        $(document).on('click', '.view-block', this.viewBlockDetails.bind(this));

        // Block Item Events
        $(document).on('click', '#addItemBtn', this.showAddItemModal.bind(this));
        $(document).on('click', '.add-item', this.showAddItemModal.bind(this));
        $(document).on('click', '.edit-item', this.editItem.bind(this));
        $(document).on('click', '.view-item', this.viewItem.bind(this));
        $(document).on('submit', '#itemForm', this.submitItemForm.bind(this));
        $(document).on('click', '.delete-item', this.deleteItem.bind(this));
        $(document).on('change', '#filterByBlock, #filterByType', this.filterItems.bind(this));
        $(document).on('click', '.change-item-order', this.showChangeOrderModal.bind(this));

        // Item Type Events
        $(document).on('click', '#itemTypesTable .view-item-type', this.viewItemType.bind(this));
        $(document).on('click', '#itemTypesTable .edit-item-type', this.editItemType.bind(this));
        $(document).on('submit', '#addItemTypeForm', this.submitItemTypeForm.bind(this));
        $(document).on('submit', '#editItemTypeForm', this.submitItemTypeForm.bind(this));
        $(document).on('click', '.delete-item-type', this.deleteItemType.bind(this));
    },

    initSlugGeneration: function() {
        $('#addDefinitionModal input[name="name"], #editDefinitionModal input[name="name"], #addItemTypeModal input[name="name"], #editItemTypeModal input[name="name"]').on('keyup change', function() {
            const $slugField = $(this).closest('form').find('input[name="slug"]');
            const slug = $(this).val()
                .toLowerCase()
                .replace(/[^a-z0-9-]/g, '-')
                .replace(/-+/g, '-')
                .replace(/^-|-$/g, '');
            $slugField.val(slug);
        });
    },

    // Definition Methods
    editDefinition: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadDefinition(id);
    },

    loadDefinition: function(id) {
        this.doAjax(
            base_url + 'administrator/posts/blocks/definition/' + id,
            'GET',
            null,
            (response) => {
                if (response.success) {
                    const def = response.data;
                    const form = $('#editDefinitionForm');
                    
                    form[0].reset();
                    $('#editIconPickerContainer .icon-item').removeClass('selected');
                    $('#editIconPreview').html('<i class="bi bi-square"></i>');
                    
                    // Set form values
                    form.find('[name="id"]').val(def.id);
                    form.find('[name="name"]').val(def.name);
                    form.find('[name="slug"]').val(def.slug);
                    form.find('[name="category"]').val(def.category);
                    
                    // Handle icon
                    if (def.icon) {
                        form.find('[name="icon"]').val(def.icon);
                        $('#editIconPreview').html(`<i class="${def.icon}"></i>`);
                        $(`#editIconPickerContainer .icon-item[data-icon-class="${def.icon}"]`).addClass('selected');
                    }

                    form.find('[name="description"]').val(def.description || '');
                    form.find('[name="is_repeatable"]').val(def.is_repeatable || '0');
                    form.find('[name="max_instances"]').val(def.max_instances || '');
                    form.find('[name="is_active"]').val(def.is_active || '1');

                    // Pre-select item types
                    $('#editItemTypesCheckboxes input[type="checkbox"]').prop('checked', false);
                    if (def.item_types && def.item_types.length > 0) {
                        def.item_types.forEach(rel => {
                            $(`#editItemTypesCheckboxes input[type="checkbox"][value="${rel.item_type_definition_id}"]`).prop('checked', true);
                        });
                    }

                    $('#editDefinitionModal').modal('show');
                    $('#editIconPickerContainer').hide();
                } else {
                    this.showAlert(response.message || 'Error loading definition', 'error');
                }
            },
            () => {
                this.showAlert('Error loading definition', 'error');
            }
        );
    },

    // Updated delete functions using the new confirmation modal
    deleteDefinition: async function(e) {
        e.preventDefault();
        const button = $(e.currentTarget);
        const id = button.data('id');
        const name = button.data('name');
        
        const confirmed = await this.showConfirmation({
            title: 'Delete Block Definition',
            message: `Are you sure you want to delete the definition "${name}"?`,
            details: 'This will permanently remove the block definition and may affect existing blocks using this definition.',
            type: 'danger',
            icon: 'bi-trash',
            confirmText: 'Delete Definition'
        });

        if (confirmed) {
            this.setButtonLoading(button, true);
            
            this.doAjax(
                base_url + 'administrator/posts/blocks/definition/delete/' + id,
                'POST',
                { csrf_token: $('meta[name="csrf-token"]').attr('content') },
                (response) => {
                    this.setButtonLoading(button, false);
                    if (response.success) {
                        this.showToast('Block definition deleted successfully', 'success');
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        this.showAlert(response.message || 'Error deleting definition', 'error');
                    }
                },
                (xhr) => {
                    this.setButtonLoading(button, false);
                    this.showAlert('Error deleting definition: ' + (xhr.responseJSON?.message || 'Unknown error'), 'error');
                }
            );
        }
    },

    submitDefinitionForm: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const isEdit = form.find('[name="id"]').val();
        const url = isEdit ? 
            base_url + 'administrator/posts/blocks/definition/update' :
            base_url + 'administrator/posts/blocks/definition/add';

        // Show loading state
        const submitBtn = form.find('[type="submit"]');
        this.setButtonLoading(submitBtn, true);

        this.doAjax(
            url,
            'POST',
            form.serialize(),
            (response) => {
                this.setButtonLoading(submitBtn, false);
                if (response.success) {
                    this.showToast('Definition saved successfully', 'success');
                    const currentTab = localStorage.getItem('blocksActiveTab') || 'definitions';
                    setTimeout(() => window.location.href = `${window.location.pathname}?tab=${currentTab}`, 1000);
                } else {
                    this.showAlert(response.message || 'Error saving definition', 'error');
                }
            },
            () => {
                this.setButtonLoading(submitBtn, false);
                this.showAlert('Error saving definition', 'error');
            }
        );
    },

    // Item Type Methods
    editItemType: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadItemType(id);
    },

    loadItemType: function(id) {
        this.doAjax(
            base_url + 'administrator/posts/blocks/item-type/' + id,
            'GET',
            null,
            (response) => {
                if (response.success) {
                    const itemType = response.data;
                    const form = $('#editItemTypeForm');
                    
                    form[0].reset();
                    
                    form.find('[name="id"]').val(itemType.id);
                    form.find('[name="name"]').val(itemType.name);
                    form.find('[name="slug"]').val(itemType.slug);
                    form.find('[name="description"]').val(itemType.description || '');

                    $('#editItemTypeModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading item type', 'error');
                }
            },
            () => {
                this.showAlert('Error loading item type', 'error');
            }
        );
    },

    deleteItemType: async function(e) {
        e.preventDefault();
        const button = $(e.currentTarget);
        const id = button.data('id');
        const name = button.data('name');
        
        const confirmed = await this.showConfirmation({
            title: 'Delete Item Type',
            message: `Are you sure you want to delete the item type "${name}"?`,
            details: 'This will remove the item type definition and may affect existing items using this type.',
            type: 'danger',
            icon: 'bi-trash',
            confirmText: 'Delete Item Type'
        });

        if (confirmed) {
            this.setButtonLoading(button, true);
            
            this.doAjax(
                base_url + 'administrator/posts/blocks/item-type/delete/' + id,
                'POST',
                { csrf_token: $('meta[name="csrf-token"]').attr('content') },
                (response) => {
                    this.setButtonLoading(button, false);
                    if (response.success) {
                        this.showToast('Item type deleted successfully', 'success');
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        this.showAlert(response.message || 'Error deleting item type', 'error');
                    }
                },
                (xhr) => {
                    this.setButtonLoading(button, false);
                    this.showAlert('Error deleting item type: ' + (xhr.responseJSON?.message || 'Unknown error'), 'error');
                }
            );
        }
    },

    viewItemType: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadItemTypeForView(id);
    },

    loadItemTypeForView: function(id) {
        this.doAjax(
            base_url + 'administrator/posts/blocks/item-type/view/' + id,
            'GET',
            null,
            (response) => {
                if (response.success) {
                    const data = response.data;
                    const itemType = data.itemType;

                    // Populate view modal
                    $('#viewItemTypeId').text(itemType.id);
                    $('#viewItemTypeName').text(itemType.name);
                    $('#viewItemTypeSlug').text(itemType.slug);
                    $('#viewItemTypeDescription').text(itemType.description || 'No description');
                    $('#viewItemTypeCreated').text(itemType.created_at || 'N/A');
                    $('#viewItemTypeUpdated').text(itemType.updated_at || 'N/A');

                    // Show configuration details
                    let configHtml = '';
                    if (itemType.fields_config) {
                        try {
                            const fields = JSON.parse(itemType.fields_config);
                            configHtml += '<h6>Fields Configuration:</h6><ul>';
                            fields.forEach(field => {
                                configHtml += `<li><strong>${field.label}</strong> (${field.type})`;
                                if (field.required) configHtml += ' <span class="text-danger">*</span>';
                                configHtml += '</li>';
                            });
                            configHtml += '</ul>';
                        } catch (e) {
                            configHtml += '<p class="text-muted">Invalid fields configuration</p>';
                        }
                    }

                    if (itemType.settings_config) {
                        try {
                            const settings = JSON.parse(itemType.settings_config);
                            configHtml += '<h6>Settings Configuration:</h6><pre class="bg-light p-2 rounded"><code>' + JSON.stringify(settings, null, 2) + '</code></pre>';
                        } catch (e) {
                            configHtml += '<p class="text-muted">Invalid settings configuration</p>';
                        }
                    }

                    if (itemType.icon) {
                        configHtml += '<h6>Icon:</h6><p><i class="' + itemType.icon + '"></i> ' + itemType.icon + '</p>';
                    }

                    // Add usage statistics
                    if (data.usageCount !== undefined) {
                        configHtml += '<h6>Usage Statistics:</h6>';
                        configHtml += '<p>Used in <strong>' + data.usageCount + '</strong> block items</p>';
                    }

                    // Add associated blocks
                    if (data.associatedBlocks && data.associatedBlocks.length > 0) {
                        configHtml += '<h6>Associated Block Definitions:</h6><ul>';
                        data.associatedBlocks.forEach(block => {
                            configHtml += `<li><strong>${block.name}</strong> (${block.slug})</li>`;
                        });
                        configHtml += '</ul>';
                    }

                    $('#viewItemTypeConfig').html(configHtml || '<p class="text-muted">No configuration details available</p>');

                    // Set up edit button
                    $('.edit-item-type-btn').off('click').on('click', () => {
                        $('#viewItemTypeModal').modal('hide');
                        this.editItemType({ currentTarget: $(`.edit-item-type[data-id="${id}"]`)[0] });
                    });

                    $('#viewItemTypeModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading item type', 'error');
                }
            },
            () => {
                this.showAlert('Error loading item type', 'error');
            }
        );
    },

    submitItemTypeForm: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const isEdit = form.find('[name="id"]').val();
        const url = isEdit ?
            base_url + 'administrator/posts/blocks/item-type/update' :
            base_url + 'administrator/posts/blocks/item-type/add';

        // Show loading state
        const submitBtn = form.find('[type="submit"]');
        this.setButtonLoading(submitBtn, true);

        this.doAjax(
            url,
            'POST',
            form.serialize(),
            (response) => {
                this.setButtonLoading(submitBtn, false);
                if (response.success) {
                    this.showToast('Item type saved successfully', 'success');
                    setTimeout(() => location.reload(), 1000);
                } else {
                    this.showAlert(response.message || 'Error saving item type', 'error');
                }
            },
            () => {
                this.setButtonLoading(submitBtn, false);
                this.showAlert('Error saving item type', 'error');
            }
        );
    },

    // Block Methods
    showAddBlockModal: function(e) {
        const postId = $(e.currentTarget).data('post-id');
        
        // Load active definitions
        this.doAjax(
            base_url + 'administrator/posts/blocks/definitions/active',
            'GET',
            null,
            (response) => {
                if (response.success) {
                    const select = $('#addBlockForm [name="definition_id"]');
                    select.empty().append('<option value="">Select Definition</option>');
                    
                    response.data.forEach((def) => {
                        select.append(`<option value="${def.id}">${def.name} (${def.slug})</option>`);
                    });

                    if (postId) {
                        $('#addBlockForm [name="post_id"]').val(postId);
                    }
                    // Reset optional fields when showing add modal
                    const addForm = $('#addBlockForm');
                    addForm.find('[name="subtitle"]').val('');
                    addForm.find('[name="title_emphasized"]').val('');
                    addForm.find('[name="settings"]').val('');
                    addForm.find('[name="custom_css"]').val('');
                    addForm.find('[name="custom_classes"]').val('');
                    $('#addBlockModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading definitions', 'error');
                }
            },
            () => {
                this.showAlert('Error loading definitions', 'error');
            }
        );
    },

    editBlock: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadBlock(id);
    },

    loadBlock: function(id) {
        this.doAjax(
            base_url + 'administrator/posts/blocks/' + id,
            'GET',
            null,
            (response) => {
                if (response.success) {
                    const block = response.data;
                    const form = $('#editBlockForm');
                    
                    form.find('[name="id"]').val(block.id);
                    form.find('[name="block_cat"]').val(block.block_cat);
                    form.find('[name="heading"]').val(block.heading);
                    form.find('[name="heading_type"]').val(block.heading_type || '');
                    form.find('[name="color"]').val(block.color || '#000000');
                    form.find('[name="caption"]').val(block.caption || '');
                    form.find('[name="ordering"]').val(block.ordering);
                    form.find('[name="status"]').val(block.status);
                    form.find('[name="content"]').val(block.content);
                    form.find('[name="list_type"]').val(block.list_type || 'none');
                    form.find('[name="code"]').val(block.code || '');
                    form.find('[name="advert_code"]').val(block.advert_code || '');

                    // Populate new custom fields if present
                    form.find('[name="title_emphasized"]').val(block.title_emphasized || '');
                    form.find('[name="subtitle"]').val(block.subtitle || '');
                    // settings may be JSON string; place as-is
                    form.find('[name="settings"]').val(block.settings ? (typeof block.settings === 'string' ? block.settings : JSON.stringify(block.settings)) : '');
                    form.find('[name="custom_css"]').val(block.custom_css || '');
                    form.find('[name="custom_classes"]').val(block.custom_classes || '');

                    // Show existing photo in preview if available
                    const preview = $('#editBlockModal').find('.block-image-preview');
                    if (block.photo) {
                        preview.attr('src', base_url + '/media/files/' + block.photo).show();
                    } else {
                        preview.hide().attr('src', '');
                    }

                    $('#editBlockModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading block', 'error');
                }
            },
            () => {
                this.showAlert('Error loading block', 'error');
            }
        );
    },

    deleteBlock: async function(e) {
        e.preventDefault();
        const button = $(e.currentTarget);
        const id = button.data('id');
        const title = button.data('title');
        
        const confirmed = await this.showConfirmation({
            title: 'Delete Block',
            message: `Are you sure you want to delete the block "${title}"?`,
            details: 'This will permanently remove the block and all associated items. This action cannot be undone.',
            type: 'danger',
            icon: 'bi-trash',
            confirmText: 'Delete Block'
        });

        if (confirmed) {
            this.setButtonLoading(button, true);
            
            this.doAjax(
                base_url + 'administrator/posts/blocks/delete/' + id,
                'POST',
                { csrf_token: $('meta[name="csrf-token"]').attr('content') },
                (response) => {
                    this.setButtonLoading(button, false);
                    if (response.success) {
                        this.showToast('Block deleted successfully', 'success');
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        this.showAlert(response.message || 'Error deleting block', 'error');
                    }
                },
                (xhr) => {
                    this.setButtonLoading(button, false);
                    this.showAlert('Error deleting block: ' + (xhr.responseJSON?.message || 'Unknown error'), 'error');
                }
            );
        }
    },

    submitBlockForm: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const isEdit = form.attr('id') === 'editBlockForm';
        const url = isEdit ? 
            base_url + 'administrator/posts/blocks/update' :
            base_url + 'administrator/posts/blocks/add';

        // Show loading state
        const submitBtn = form.find('[type="submit"]');
        this.setButtonLoading(submitBtn, true);

        // Build AJAX options
        let ajaxOptions = {
            url: url,
            type: 'POST',
            dataType: 'json',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: (response) => {
                this.setButtonLoading(submitBtn, false);
                if (response.success) {
                    this.showToast('Block ' + (isEdit ? 'updated' : 'added') + ' successfully', 'success');
                    const currentTab = localStorage.getItem('blocksActiveTab') || 'definitions';
                    setTimeout(() => window.location.href = `${window.location.pathname}?tab=${currentTab}`, 1000);
                } else {
                    if (response.errors) {
                        Object.keys(response.errors).forEach(field => {
                            const input = form.find(`[name="${field}"]`);
                            input.addClass('is-invalid');
                            input.after(`<div class="invalid-feedback">${response.errors[field]}</div>`);
                        });
                    }
                    this.showAlert(response.message || 'Error saving block', 'error');
                }
            },
            error: (xhr) => {
                this.setButtonLoading(submitBtn, false);
                let errorMsg = 'Error saving block';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMsg = xhr.responseJSON.message;
                } else if (xhr.status === 403) {
                    errorMsg = 'You do not have permission to perform this action';
                } else if (xhr.status === 419 || xhr.status === 401) {
                    errorMsg = 'Your session has expired. Please refresh the page and try again.';
                }
                this.showAlert(errorMsg, 'error');
            }
        };

        if (form.find('input[type="file"]').length) {
            const fd = new FormData(form[0]);
            ajaxOptions.data = fd;
            ajaxOptions.processData = false;
            ajaxOptions.contentType = false;
        } else {
            ajaxOptions.data = form.serialize();
        }

        $.ajax(ajaxOptions);
    },

    // Item Methods
    showAddItemModal: function(e) {
        const form = $('#itemForm');
        form[0].reset();

        // Clear icon preview
        form.find('.item-icon-preview').html('<i class="bi bi-square"></i>');
        form.find('.item-icon-input').val('');

        if (e && $(e.currentTarget).data('block-id')) {
            const blockId = $(e.currentTarget).data('block-id');
            const blockType = $(e.currentTarget).data('block-type');
            form.find('[name="block_id"]').val(blockId);
            $('#itemModal .modal-title').html(`Add Item to <small class="text-muted">${blockType}</small>`);
        } else {
            $('#itemModal .modal-title').text('Add Block Item');
        }

        form.find('[name="id"]').val('');
        $('#itemModal').modal('show');
    },

    editItem: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadItem(id);
    },

    loadItem: function(id) {
        this.doAjax(
            base_url + 'administrator/posts/blocks/item/' + id,
            'GET',
            null,
            (response) => {
                if (response.success) {
                    const item = response.data;
                    const form = $('#itemForm');

                    form.find('[name="id"]').val(item.id);
                    form.find('[name="block_id"]').val(item.block_id);
                    form.find('[name="item_type"]').val(item.item_type);
                    form.find('[name="title"]').val(item.title);
                    form.find('[name="icon"]').val(item.icon);
                    form.find('[name="description"]').val(item.description);
                    form.find('[name="link"]').val(item.link);
                    form.find('[name="ordering"]').val(item.ordering);
                    form.find('[name="width"]').val(item.width);
                    form.find('[name="status"]').val(item.status);

                    // Set icon preview if icon exists
                    if (item.icon) {
                        form.find('.item-icon-preview').html(`<i class="${item.icon}"></i>`);
                        form.find('.item-icon-input').val(item.icon);
                    } else {
                        form.find('.item-icon-preview').html('<i class="bi bi-square"></i>');
                        form.find('.item-icon-input').val('');
                    }

                    $('#itemModal .modal-title').text('Edit Block Item');
                    $('#itemModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading item', 'error');
                }
            },
            () => {
                this.showAlert('Error loading item', 'error');
            }
        );
    },

    viewItem: function(e) {
        const id = (typeof e === 'object') ? $(e.currentTarget).data('id') : e;
        this.doAjax(
            base_url + 'administrator/posts/blocks/item/' + id,
            'GET',
            null,
            (response) => {
                if (response.success) {
                    const item = response.data;

                    // Populate view modal fields
                    $('#viewItemId').text(item.id || 'N/A');
                    $('#viewItemBlock').html(item.block_id ? `#${item.block_id}` : 'N/A');
                    $('#viewItemType').text(item.item_type || 'N/A');
                    $('#viewItemTitle').text(item.title || 'N/A');
                    $('#viewItemDescription').text(item.description || '');
                    if (item.link) {
                        $('#viewItemLink').html(`<a href="${item.link}" target="_blank">${item.link}</a>`);
                    } else {
                        $('#viewItemLink').text('-');
                    }
                    if (item.icon) {
                        $('#viewItemIcon').html(`<i class="${item.icon}"></i> ${item.icon}`);
                    } else {
                        $('#viewItemIcon').text('-');
                    }
                    $('#viewItemOrder').text(item.ordering || 0);
                    $('#viewItemStatus').html(item.status === 'active' ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>');

                    // Image preview if available
                    if (item.photo) {
                        $('#viewItemImage').attr('src', base_url + '/media/files/' + item.photo).show();
                        $('#viewItemImagePlaceholder').hide();
                    } else {
                        $('#viewItemImage').hide().attr('src', '');
                        $('#viewItemImagePlaceholder').show();
                    }

                    $('#viewItemModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading item details', 'error');
                }
            },
            () => {
                this.showAlert('Error loading item details', 'error');
            }
        );
    },

    deleteItem: async function(e) {
        e.preventDefault();
        const button = $(e.currentTarget);
        const id = button.data('id');
        const title = button.data('title');
        
        const confirmed = await this.showConfirmation({
            title: 'Delete Item',
            message: `Are you sure you want to delete the item "${title}"?`,
            details: 'This item will be permanently removed from the block.',
            type: 'warning',
            icon: 'bi-exclamation-triangle',
            confirmText: 'Delete Item'
        });

        if (confirmed) {
            this.setButtonLoading(button, true);
            
            this.doAjax(
                base_url + 'administrator/posts/blocks/item/delete/' + id,
                'POST',
                { csrf_token: $('meta[name="csrf-token"]').attr('content') },
                (response) => {
                    this.setButtonLoading(button, false);
                    if (response.success) {
                        this.showToast('Item deleted successfully', 'success');
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        this.showAlert(response.message || 'Error deleting item', 'error');
                    }
                },
                (xhr) => {
                    this.setButtonLoading(button, false);
                    this.showAlert('Error deleting item: ' + (xhr.responseJSON?.message || 'Unknown error'), 'error');
                }
            );
        }
    },

    submitItemForm: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const isEdit = form.find('[name="id"]').val();
        const url = isEdit ? 
            base_url + 'administrator/posts/blocks/item/update' :
            base_url + 'administrator/posts/blocks/item/add';

        // Show loading state
        const submitBtn = form.find('[type="submit"]');
        this.setButtonLoading(submitBtn, true);

        // Support file uploads
        let ajaxOptions = {
            url: url,
            type: 'POST',
            dataType: 'json',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: (response) => {
                this.setButtonLoading(submitBtn, false);
                if (response.success) {
                    this.showToast('Item saved successfully', 'success');
                    setTimeout(() => location.reload(), 1000);
                } else {
                    this.showAlert(response.message || 'Error saving item', 'error');
                }
            },
            error: (xhr) => {
                this.setButtonLoading(submitBtn, false);
                let msg = 'Error saving item';
                if (xhr.responseJSON && xhr.responseJSON.message) msg = xhr.responseJSON.message;
                this.showAlert(msg, 'error');
            }
        };

        if (form.find('input[type="file"]').length) {
            const fd = new FormData(form[0]);
            ajaxOptions.data = fd;
            ajaxOptions.processData = false;
            ajaxOptions.contentType = false;
        } else {
            ajaxOptions.data = form.serialize();
        }

        $.ajax(ajaxOptions);
    },

    // Order Management
    showChangeOrderModal: function(e) {
        const id = $(e.currentTarget).data('id');
        const currentOrder = $(e.currentTarget).data('current');
        const type = $(e.currentTarget).hasClass('change-item-order') ? 'item' : 'block';
        
        $('#changeOrderForm [name="id"]').val(id);
        $('#changeOrderForm [name="type"]').val(type);
        $('#changeOrderForm [name="ordering"]').val(currentOrder);
        
        $('#changeOrderModal').modal('show');
    },

    submitOrderChange: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const type = form.find('[name="type"]').val();
        
        const url = type === 'item' ? 
            base_url + 'administrator/posts/blocks/item/update-order' :
            base_url + 'administrator/posts/blocks/update-order';

        // Show loading state
        const submitBtn = form.find('[type="submit"]');
        this.setButtonLoading(submitBtn, true);

        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            dataType: 'json',
            success: (response) => {
                this.setButtonLoading(submitBtn, false);
                if (response.success) {
                    this.showToast('Order updated successfully', 'success');
                    setTimeout(() => window.location.reload(), 1000);
                } else {
                    this.showAlert(response.message || 'Error updating order', 'error');
                }
            },
            error: (xhr) => {
                this.setButtonLoading(submitBtn, false);
                this.showAlert('Error updating order. Please try again.', 'error');
                if (xhr.status === 403) {
                    setTimeout(() => window.location.reload(), 2000);
                }
            }
        });
    },

    // View Methods
    viewBlockDetails: function(e) {
        e.preventDefault();
        const blockId = $(e.currentTarget).data('id');
        
        this.doAjax(
            base_url + 'administrator/posts/block/' + blockId,
            'GET',
            null,
            (response) => {
                if (response.success) {
                    const block = response.data.block;
                    const items = response.data.items;

                    // Update block information
                    $('#blockPostTitle').text(block.post_title || 'N/A');
                    $('#blockType').text(block.block_type);
                    $('#blockDefinitionName').text(block.definition_name || 'N/A');
                    $('#blockDefinitionDesc').text(block.definition_description || '');
                    $('#blockCategory').text(block.block_cat).addClass('bg-secondary');
                    $('#blockHeading').text(block.heading || 'N/A');
                    $('#blockOrder').html(`<span class="badge bg-primary">${block.ordering}</span>`);
                    $('#blockStatus').html(block.status === 'active' ? 
                        '<span class="badge bg-success">Active</span>' : 
                        '<span class="badge bg-secondary">Inactive</span>'
                    );

                    // Update block items
                    if (items && items.length > 0) {
                        let itemsHtml = '<div class="table-responsive"><table class="table table-sm">';
                        itemsHtml += '<thead><tr><th>Title</th><th>Type</th><th>Order</th><th>Status</th></tr></thead>';
                        itemsHtml += '<tbody>';
                        
                        items.forEach(item => {
                            itemsHtml += `<tr>
                                <td>${item.title || 'N/A'}</td>
                                <td><code>${item.item_type}</code></td>
                                <td><span class="badge bg-primary">${item.ordering}</span></td>
                                <td>${item.status === 'active' ? 
                                    '<span class="badge bg-success">Active</span>' : 
                                    '<span class="badge bg-secondary">Inactive</span>'}</td>
                            </tr>`;
                        });
                        
                        itemsHtml += '</tbody></table></div>';
                        $('#blockItemsContainer').html(itemsHtml);
                    } else {
                        $('#blockItemsContainer').html('<div class="alert alert-info">No items found in this block.</div>');
                    }

                    // Set up edit button
                    $('.edit-block-btn').off('click').on('click', () => {
                        $('#viewBlockModal').modal('hide');
                        this.editBlock({ currentTarget: $(`.edit-block[data-id="${blockId}"]`)[0] });
                    });

                    $('#viewBlockModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading block details', 'error');
                }
            },
            () => {
                this.showAlert('Error loading block details', 'error');
            }
        );
    },

    viewBlockItems: function(e) {
        const blockId = $(e.currentTarget).data('block-id');
        
        this.doAjax(
            base_url + 'administrator/posts/blocks/items/' + blockId,
            'GET',
            null,
            (response) => {
                if (response.success) {
                    $('#itemsListContainer').html(response.html);
                    $('#viewItemsModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading items', 'error');
                }
            },
            () => {
                this.showAlert('Error loading items', 'error');
            }
        );
    },

    // Filter Methods
    filterBlocks: function() {
        const postId = $('#filterByPost').val();
        const status = $('#filterByStatus').val();
        const table = $('#blocksTable').DataTable();
        
        $.fn.dataTable.ext.search.push(
            function(settings, data, dataIndex) {
                const row = table.row(dataIndex).node();
                const rowPostId = $(row).data('post-id');
                const rowStatus = $(row).data('status');
                
                let showRow = true;
                
                // Filter by post
                if (postId && rowPostId != postId) {
                    showRow = false;
                }
                
                // Filter by status
                if (status && rowStatus != status) {
                    showRow = false;
                }
                
                return showRow;
            }
        );
        
        table.draw();
        
        // Remove the filter function after drawing to avoid duplication
        $.fn.dataTable.ext.search.pop();
    },

    filterItems: function() {
        const blockId = $('#filterByBlock').val();
        const type = $('#filterByType').val();
        const table = $('#itemsTable').DataTable();
        
        $.fn.dataTable.ext.search.push(
            function(settings, data, dataIndex) {
                const row = table.row(dataIndex).node();
                const rowBlockId = $(row).data('block-id');
                const rowItemType = $(row).data('item-type');
                
                let showRow = true;
                
                // Filter by block
                if (blockId && rowBlockId != blockId) {
                    showRow = false;
                }
                
                // Filter by type
                if (type && rowItemType != type) {
                    showRow = false;
                }
                
                return showRow;
            }
        );
        
        table.draw();
        
        // Remove the filter function after drawing to avoid duplication
        $.fn.dataTable.ext.search.pop();
    }
};

// Item Type Manager
const ItemTypeManager = {
    init: function() {
        this.bindEvents();
        this.initItemIconPicker();
        // Ensure file preview handler is attached on init so add-modal previews work
        this.initFilePreviews();
    },

    initItemIconPicker: function() {
        // Handle icon picker for items
        $(document).on('click', '.show-item-icon-picker', function(e) {
            e.preventDefault();
            e.stopPropagation();
            const container = $(this).closest('.icon-preview-wrapper').find('.icon-picker-container');

            // Create and populate the icon grid if it doesn't exist
            if (!container.find('.icon-grid').length) {
                let iconGridHtml = '<div class="icon-grid">';
                [
                    { class: 'bi bi-grid', name: 'Grid' },
                    { class: 'bi bi-layout-text-window-reverse', name: 'Text Window' },
                    { class: 'bi bi-image', name: 'Image' },
                    { class: 'bi bi-card-text', name: 'Card Text' },
                    { class: 'bi bi-file-code', name: 'Code' },
                    { class: 'bi bi-list', name: 'List' },
                    { class: 'bi bi-table', name: 'Table' },
                    { class: 'bi bi-calendar', name: 'Calendar' },
                    { class: 'bi bi-person', name: 'Person' },
                    { class: 'bi bi-people', name: 'People' },
                    { class: 'bi bi-gear', name: 'Gear' },
                    { class: 'bi bi-tools', name: 'Tools' },
                    { class: 'bi bi-info-circle', name: 'Info Circle' },
                    { class: 'bi bi-check-circle', name: 'Check Circle' },
                    { class: 'bi bi-x-circle', name: 'X Circle' },
                    { class: 'bi bi-exclamation-triangle', name: 'Warning' },
                    { class: 'bi bi-question-circle', name: 'Question' },
                    { class: 'bi bi-folder', name: 'Folder' },
                    { class: 'bi bi-file-earmark', name: 'File' },
                    { class: 'bi bi-link-45deg', name: 'Link' },
                ].forEach(icon => {
                    iconGridHtml += `<div class="icon-item" data-icon-class="${icon.class}" title="${icon.name}">
                                    <i class="${icon.class}"></i>
                                 </div>`;
                });
                iconGridHtml += '</div>';
                container.html(iconGridHtml);
            }

            // Close other open icon pickers
            $('.icon-picker-container').not(container).slideUp();
            container.slideToggle();
        });

        // Handle icon selection for items
        $(document).on('click', '.item-icon-picker .icon-item', function(e) {
            e.preventDefault();
            e.stopPropagation();
            const iconClass = $(this).data('icon-class');
            const wrapper = $(this).closest('.icon-preview-wrapper');

            wrapper.find('.item-icon-input').val(iconClass);
            wrapper.find('.item-icon-preview').html(`<i class="${iconClass}"></i>`);

            // Update visual state
            $(this).closest('.icon-picker-container').find('.icon-item').removeClass('selected');
            $(this).addClass('selected');
            $(this).closest('.icon-picker-container').slideUp();
        });
    },

    bindEvents: function() {
        // Handle item type change
        $('#itemForm [name="item_type"]').on('change', function() {
            const selectedOption = $(this).find(':selected');
            const fields = selectedOption.data('fields');
            const settings = selectedOption.data('settings');

            // Update fields based on selection
            ItemTypeManager.updateDynamicFields(fields, settings);
        });

        // Close icon pickers when clicking outside
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.icon-preview-wrapper').length) {
                $('.icon-picker-container').slideUp();
            }
        });
    },

    updateDynamicFields: function(fieldsConfig, settingsConfig) {
        const container = $('#dynamicFields');
        container.empty();

        if (!fieldsConfig) return;

        try {
            const fields = JSON.parse(fieldsConfig);
            const settings = settingsConfig ? JSON.parse(settingsConfig) : {};

            fields.forEach(field => {
                container.append(this.createFieldHtml(field, settings));
            });

            this.initFilePreviews();
        } catch (e) {
            console.error('Error parsing fields configuration:', e);
        }
    },

    createFieldHtml: function(field, settings) {
        let html = '';
        const fieldId = `field_${field.name}`;
        
        switch (field.type) {
            case 'text':
            case 'url':
            case 'email':
            case 'number':
                html = `
                    <div class="mb-3">
                        <label class="form-label" for="${fieldId}">
                            ${field.label}
                            ${field.required ? '<span class="text-danger">*</span>' : ''}
                        </label>
                        <input type="${field.type}" 
                               class="form-control" 
                               id="${fieldId}" 
                               name="fields[${field.name}]"
                               ${field.required ? 'required' : ''}
                               ${field.placeholder ? `placeholder="${field.placeholder}"` : ''}>
                        ${field.description ? `<div class="form-text">${field.description}</div>` : ''}
                    </div>`;
                break;

            case 'textarea':
                html = `
                    <div class="mb-3">
                        <label class="form-label" for="${fieldId}">
                            ${field.label}
                            ${field.required ? '<span class="text-danger">*</span>' : ''}
                        </label>
                        <textarea class="form-control" 
                                 id="${fieldId}" 
                                 name="fields[${field.name}]"
                                 rows="${field.rows || 3}"
                                 ${field.required ? 'required' : ''}
                                 ${field.placeholder ? `placeholder="${field.placeholder}"` : ''}></textarea>
                        ${field.description ? `<div class="form-text">${field.description}</div>` : ''}
                    </div>`;
                break;

            case 'image':
                html = `
                    <div class="mb-3">
                        <label class="form-label" for="${fieldId}">
                            ${field.label}
                            ${field.required ? '<span class="text-danger">*</span>' : ''}
                        </label>
                        <input type="file" 
                               class="form-control field-file-input" 
                               id="${fieldId}" 
                               name="fields_files[${field.name}]"
                               accept="image/*"
                               ${field.required ? 'required' : ''}>
                        ${field.description ? `<div class="form-text">${field.description}</div>` : ''}
                        <div class="mt-2"><img id="preview_${fieldId}" src="" style="max-width:200px; display:none;" class="img-fluid img-thumbnail"/></div>
                    </div>`;
                break;

            case 'select':
                const options = field.options || [];
                html = `
                    <div class="mb-3">
                        <label class="form-label" for="${fieldId}">
                            ${field.label}
                            ${field.required ? '<span class="text-danger">*</span>' : ''}
                        </label>
                        <select class="form-select" 
                                id="${fieldId}" 
                                name="fields[${field.name}]"
                                ${field.required ? 'required' : ''}>
                            <option value="">${field.placeholder || 'Select an option'}</option>
                            ${options.map(opt => `
                                <option value="${opt.value}">${opt.label}</option>
                            `).join('')}
                        </select>
                        ${field.description ? `<div class="form-text">${field.description}</div>` : ''}
                    </div>`;
                break;
        }
        
        return html;
    },

    initFilePreviews: function() {
        const handleImagePreview = function(input) {
            // Try to find a nearby preview box; support card-body, modal-body, form-group, or direct sibling
            let previewBox = $(input).closest('.card-body, .modal-body, .mb-3, .form-group').find('.image-preview-box');
            if (!previewBox.length) {
                previewBox = $(input).siblings('.image-preview-box');
            }
            // Fallback: try preview element by ID convention (preview_<input.id>)
            let previewImg = $();
            let previewText = $();
            if (!previewBox.length && input.id) {
                const byId = $(`#preview_${input.id}`);
                if (byId.length) {
                    previewImg = byId;
                }
            }

            if (previewBox.length) {
                previewImg = previewBox.find('img');
                previewText = previewBox.find('.preview-text');
            }

            // If still nothing found, give up
            if (!previewImg || !previewImg.length) return;

            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    previewImg.attr('src', e.target.result).show();
                    if (previewText && previewText.length) previewText.hide();
                };
                reader.readAsDataURL(input.files[0]);
            } else {
                previewImg.attr('src', '').hide();
                if (previewText && previewText.length) previewText.show();
            }
        };

        // Ensure we don't bind the handler multiple times
        $(document).off('change', '.block-photo-input, .item-photo-input, .field-file-input[accept*="image"]');
        // Delegated event for all photo inputs
        $(document).on('change', '.block-photo-input, .item-photo-input, .field-file-input[accept*="image"]', function() {
            handleImagePreview(this);
        });
    },
};

// Tab persistence functionality
const TabManager = {
    init: function() {
        const activeTab = localStorage.getItem('blocksActiveTab') || 'definitions';
        this.activateTab(activeTab);
        
        $('button[data-bs-toggle="tab"]').on('shown.bs.tab', (e) => {
            const tabId = $(e.target).attr('id');
            const tabName = tabId.replace('-tab', '');
            localStorage.setItem('blocksActiveTab', tabName);
        });
    },

    activateTab: function(tabName) {
        $(`#${tabName}-tab`).tab('show');
    }
};

// Initialize when document is ready
$(document).ready(function() {
    // Setup CSRF handling for AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            'X-Requested-With': 'XMLHttpRequest'
        },
        error: function(xhr, status, error) {
            if (xhr.status === 403) {
                BlockSystem.showAlert('Your session has expired. The page will refresh to restore your session.', 'warning');
                setTimeout(() => window.location.reload(), 2000);
            }
        }
    });

    // Add CSRF token to all forms
    $('form').each(function() {
        if (!$(this).find('input[name="csrf_token"]').length) {
            $(this).append('<input type="hidden" name="csrf_token" value="' + $('meta[name="csrf-token"]').attr('content') + '">');
        }
    });

    ItemTypeManager.init();
    BlockSystem.init();
    TabManager.init();
    
    // Update URLs with tab information
    const updateUrlWithTab = () => {
        const urlParams = new URLSearchParams(window.location.search);
        const activeTab = localStorage.getItem('blocksActiveTab');
        if (activeTab) {
            urlParams.set('tab', activeTab);
            const newUrl = `${window.location.pathname}?${urlParams.toString()}`;
            history.replaceState({}, '', newUrl);
        }
    };
    
    $('button[data-bs-toggle="tab"]').on('shown.bs.tab', updateUrlWithTab);
    updateUrlWithTab();
});
</script>

<?= $this->endSection(); ?>