<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Edit Post</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/posts') ?> ">All Posts</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<?php if(session()->getTempdata('info')): ?>
			<div class="alert alert-info" role="alert"><?= session()->getTempdata('info');?></div>
		<?php endif;?>
        <?php if(session()->getTempdata('warning')): ?>
			<div class="alert alert-warning" role="alert"><?= session()->getTempdata('warning');?></div>
		<?php endif;?>
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Create/Post !-->
<form method="POST" action="<?= base_url('administrator/posts/block-post/update')?>" enctype="multipart/form-data" id="post-form">
    <?= csrf_field(); ?>
    
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <!-- Save/New/Cancel Btns !-->
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                    <button type="submit" class="btn btn-sm btn-success align-items-center"> Update & Close</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-warning bg-opacity-50 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                    <a href="<?= base_url('administrator/posts/block-post/view/'.$singlePost['id'].'-'.$singlePost['alias']) ?>" class="btn btn-sm bg-warning bg-opacity-25">View Post</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-plus-lg"></i></button>
                    <a href="<?= base_url('administrator/posts/block-post/add') ?>" class="btn btn-sm btn-light">Add New</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-danger  text-white rounded-0"><i class="bi bi-x-lg"></i></button>
                    <button type="button" class="btn btn-sm bg-danger text-white" onclick="location.href = '<?= base_url('administrator/posts/block-posts')?>'">Close</button>
                    </div>
                </div>
            </div>
            <!-- END Save/New/Cancel Btns !-->
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-7">
                    <div class="mb-3">
                    <input type="hidden" name="post_id" value="<?= $singlePost['id'] ?>">
                    <label class="form-label"><strong>Title</strong></label>
                    <input type="text" name="title" value="<?= $singlePost['title'] ?>" class="form-control">
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="mb-3">
                    <label class="form-label"><strong>Alias</strong></label>
                    <input type="text" name="alias" value="<?= $singlePost['alias'] ?>" class="form-control bg-secondary bg-opacity-10" readonly>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-9">
                  <!-- Main post content !-->
                  <div class="mb-3" id="editPostArea">
                    <label class="form-label"><strong>Content</strong></label>
                    <!-- Display Blocks -->
                     <?php foreach ($blockData as $block): ?>
                        <div class="block-item mb-3">
                            <!-- EDIT Menu -->
                            <div class="dropdown dropstart float-md-end">
                                <a href="#" role="button" id="dropdownMenuLink<?= $block->id ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-three-dots fs-3"></i>
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink<?= $block->id ?>">
                                    <li>
                                        <a class="dropdown-item" title="Edit Block" onclick="editBlock(<?= $block->id ?>)" style="cursor: pointer;">
                                            <small>Edit</small>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" title="Delete Block" onclick="deleteBlock(<?= $block->id ?>)" style="cursor: pointer;">
                                            <small>Delete</small>
                                        </a>
                                    </li>
                                </ul>
                            </div>

                            <!-- BLOCK CONTENT -->
                            <div class="block-content">
                                <?php switch ($block->block_type):
                                    case 'text': ?>
                                        <p><?= nl2br($block->content) ?></p>
                                        <?php break;

                                    case 'image': ?>
                                        <div>
                                            <img src="<?= $block->photo ?>" alt="<?= esc($block->caption) ?>" class="img-fluid mb-2">
                                            <?php if (!empty($block->caption)): ?>
                                                <p class="text-muted"><small><?= esc($block->caption) ?></small></p>
                                            <?php endif; ?>
                                        </div>
                                        <?php break;

                                    case 'heading': ?>
                                        <<?= $block->heading_type ?> style="color: <?= $block->color ?>">
                                            <?= esc($block->heading) ?>
                                        </<?= $block->heading_type ?>>
                                        <?php break;

                                    case 'cards': ?>
                                        <h3><?= esc($block->heading) ?></h3>
                                        <?php break;

                                    case 'stats': ?>
                                        <h3><?= esc($block->heading) ?></h3>
                                        <?php break;

                                    case 'list': ?>
                                        <?php if ($block->list_type === 'ol'): ?>
                                            <ol>
                                                <?php foreach (explode("\n", $block->content) as $item): ?>
                                                    <li><?= esc(trim($item)) ?></li>
                                                <?php endforeach; ?>
                                            </ol>
                                        <?php else: ?>
                                            <ul type="square">
                                                <?php foreach (explode("\n", $block->content) as $item): ?>
                                                    <li><?= esc(trim($item)) ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php endif; ?>
                                        <?php break;

                                    case 'code': ?>
                                        <pre><code><?= esc($block->code) ?></code></pre>
                                        <?php break;

                                    case 'advert': ?>
                                        <div class="advert-block">
                                            <pre><code><?= $block->advert_code ?></code></pre>
                                        </div>
                                        <?php break;

                                    case 'gallery': ?>
                                        <h3><?= esc($block->heading) ?></h3>
                                        <p><?= esc($block->content) ?></p>
                                        <?php break;
                                endswitch; ?>
                            </div>
                            <!-- CHILD ITEMS SECTION -->
                            <?php if (in_array($block->block_type, ['stats','cards','gallery'])): ?>
                                <div class="child-items mt-3">
                                    <h6><?= ucfirst($block->block_type) ?> Items</h6>
                                    <div class="row">
                                        <?php foreach ($block->children as $item): ?>
                                            <div class="col-md-4 mb-2">
                                                <div class="border p-2 rounded">
                                                    <?php if ($block->block_type === 'gallery' || $block->block_type === 'cards' && $item->photo): ?>
                                                        <img src="<?= $item->photo ?>" class="img-fluid mb-2">
                                                        <strong><?= esc($item->caption) ?></strong>
                                                    <?php endif; ?>

                                                    <?php if ($block->block_type === 'stats' || $block->block_type === 'cards'): ?>
                                                        <i class="<?= esc($item->icon) ?> fs-3 d-flex"></i>
                                                    <?php endif; ?>

                                                    <strong><?= esc($item->title) ?></strong>
                                                    <?php if ($block->block_type === 'stats'): ?>
                                                        <p class="m-0"><?= esc($item->value) ?></p>
                                                    <?php endif; ?>

                                                    <?php if ($block->block_type === 'stats' || $block->block_type === 'cards'): ?>
                                                    <p class="small"><?= esc($item->description) ?></p>
                                                    <?php endif; ?>

                                                    <?php if ($block->block_type === 'cards' && $item->link):?>
                                                    <a href="<?= esc($item->link) ?>" class="btn btn-outline-secondary btn-sm">More...</a>
                                                    <?php endif; ?>

                                                    <div class="mt-1 d-flex justify-content-end">
                                                        <div class="btn-group ">
                                                            <button type="button" class="btn btn-sm btn-outline-primary rounded-circle me-1" onclick="editChildItem(<?= $item->id ?>, '<?= $item->item_type ?>')"><i class="bi bi-pencil"></i></button>
                                                            <button type="button" class="btn btn-sm btn-outline-danger rounded-circle" onclick="deleteChildItem(<?= $item->id ?>, '<?= $item->item_type ?>')"><small><i class="bi bi-trash"></i></small></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-success mt-2" onclick="openChildItemModal('<?= $block->block_type ?>', <?= $block->id ?>)">+ Add Item</button>
                                </div>
                            <?php endif; ?>
                           
                        </div>
                    <?php endforeach; ?>
                    <!-- END Display Blocks -->
                    <!-- Block Add Buttons !-->
                    <div class="d-flex mb-3">
                        <div class="btn-group dropup">
                            <button class="btn btn-dark dropdown-toggle" type="button" id="dropdownMenuButton2" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="bi bi-plus fs-5"></i> Add Block
                            </button>
                            <ul class="dropdown-menu dropdown-menu-dark" aria-labelledby="dropdownMenuButton2" style="font-size: 13px">
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="heading">Add Heading</a></li>
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="text">Add Text</a></li>
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="image">Add Image</a></li>
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="list">Add List</a></li>
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="cards">Add Card</a></li>
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="stats">Add Stats</a></li>
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="gallery">Add Gallery</a></li>
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="code">Add Code</a></li>
                                <li><a class="dropdown-item border-bottom border-secondary" data-block="video">Add Video</a></li>
                                <li><a class="dropdown-item" data-block="advert">Add Advert</a></li>
                            </ul>
                        </div>
                    </div>
                    <!-- End Block Add Buttons !-->

                    <!-- UNIFIED ADD / EDIT BLOCK FORM !-->
                    <div class="block-element" style="display:none;">
                        <?= view('Modules\Posts\Views\block-post\partials\blockform-tab') ?>
                    </div>
                    <!-- END UNIFIED !-->

                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Excerpt text</strong></label>
                    <textarea name="excerpt" class="form-control"  rows="2" placeholder="Write summary text here.."><?= $singlePost['excerpt'] ?></textarea>
                  </div>
                  
                  <!-- END Main post content  !-->
                </div>
                <div class="col-lg-3">
                 <!-- Main post params !-->
                 <div class="mb-3">
                    <label class="form-label" for="start_date"><strong>Start Publishing</strong></label>
                    <div class="row g-2">
                    <div class="col-8"><input type="date" name="pdate" class="form-control" id="start_date" value="<?= date('Y-m-d', strtotime($singlePost['published_date'])) ?>"/></div><div class="col-4">
                    <input type="time" name="ptime" class="form-control" id="start_date" value="<?= date('H:i:s', strtotime($singlePost['published_date'])) ?>"/></div>
                    </div>
                 </div><!-- Set Publish Date !-->
                <div class="mb-3">
                    <?php function generateSelectOptions($categories, $indent = '', $singlePost = null) { ?>
                        <?php foreach ($categories as $category) { ?>
                            <option value="<?= $category['id'] ?>" <?php if ($singlePost && $category['id'] == $singlePost['category_id']) echo "selected"; ?>><?= $indent . $category['name'] ?></option>
                            <?php if (isset($category['subcategories']) && is_array($category['subcategories'])) { ?>
                                <?php generateSelectOptions($category['subcategories'], $indent . '- ', $singlePost); ?>
                            <?php } ?>
                        <?php } ?>
                    <?php } ?>
                    <label class="form-label"><strong>Category</strong></label>
                    <?php if($singlePost['category_id'] == 1):?>
                        <select name="category_id" class="form-select" required>
                            <option value="<?= $singlePost['category_id'];?>">PAGES</option>
                        </select>
                    <?php else:?>
                        <select name="category_id" class="form-select" required>
                            <option value="">Select Category</option>
                            <?php generateSelectOptions($categoryTree, '', $singlePost); ?>
                        </select>
                    <?php endif;?>
                </div><!-- Post Category !-->
                  <div class="mb-3">
                    <label class="form-label"><strong>Status</strong></label>
                    <select name="status" class="form-select bg-success bg-opacity-75 text-white" >
                        <option value="Published" <?php if($singlePost['status'] == "Published" ) echo "selected";?> >Published</option>
                        <option value="Unpublished" <?php if($singlePost['status'] == "Unpublished" ) echo "selected";?>>Unpublished</option>
                        <option value="Archived" <?php if($singlePost['status'] == "Archived" ) echo "selected";?>>Archived</option>
                        <option value="Trashed" <?php if($singlePost['status'] == "Trashed" ) echo "selected";?>>Trashed</option>
                    </select>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Access</strong></label>
                    <select name="access" class="form-select">
                        <option value="Public" <?php if($singlePost['access'] == "Public" ) echo "selected";?>>Public</option>
                        <option value="Private" <?php if($singlePost['access'] == "Private" ) echo "selected";?>>Private</option>
                        <option value="Users" <?php if($singlePost['access'] == "Users" ) echo "selected";?>>Users</option>
                    </select>
                  </div>
                  <div class="mb-3">
                    <div style="height: 150px; background: #F2F9FF; border-radius: 5px;">
                    <div id="postImgPreview"></div>
                    <small class="d-flex text-muted p-2">Add Photo to post</small>
                    </div>
                    <input type="file" name="photo" id="post_image" class="postImg upload-photo" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp">
                    <img src="<?= $singlePost['photo']?>" width="80px">
                  </div>
                  <div class="mb-3">
                    <small>
                        <strong>Available Tags: </strong>
                        <?php foreach($postTags as $tag): ?>
                            <span class="badge bg-primary me-1"><?= $tag->tag; ?></span> 
                        <?php endforeach; ?>
                    </small><br/>
                    <label for="tags-input" class="form-label">Tags</label>
                    <select  class="" id="tags-input" name="tags[]" autocomplete="off" placeholder="Enter Tags separated by comma" multiple></select>
                    <span class="d-flex text-danger" onclick="addPostTag()" style="cursor: pointer"><small>Add New Tag</small></span>
                  </div><!-- Tags for Post !-->
                  <div class="mb-3">
                    <label class="form-label"><strong>Author</strong></label>
                    <select name="author_id" class="form-select">
                        <option value="" >Select Author</option>
                        <?php foreach($authors as $a): ?>
                            <option value="<?= $a->id;?>" <?php if($a->id == $singlePost['author_id']) echo "selected";?>><?= $a->first_name.' '.$a->last_name;?></option>
                        <?php endforeach;?>
                    </select>
                  </div>
                <!-- END Main post params  !-->
                </div>
            </div>
            <div class="row mb-4">
                <div class="accordion accordion-flush" id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-info bg-opacity-10                                    " type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                           Add SEO meta description and keywords
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="row">
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Description</strong></label>
                    <textarea name="metadesc" class="form-control"   placeholder="Provide description(150 words) for SEO experience"><?=$singlePost['metadesc']?></textarea>
                  </div>
                </div>
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Keywords</strong></label>
                    <textarea name="metakey" class="form-control"   placeholder="SEO Keywords separated by comma"><?=$singlePost['metakey']?></textarea>
                  </div>
                </div>
            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<!-- End Create/Post !--> 
<!-- Create Blocks -->
<form id="block-form" method="POST" action="<?= base_url('administrator/posts/block/save')?>" enctype="multipart/form-data" style="display:none;">
</form>
<!-- End Create Blocks -->

<!-- Modal !-->
 <?= view('Modules\Posts\Views\block-post\modals\\edit-blockModal') ?>
<?= view('Modules\Posts\Views\tags\modals\\addTag_Modal') ?>
 <?= view('Modules\Posts\Views\block-post\modals\\child-blockModal') ?>

<!---- JS --->
<script src="<?= base_url();?>/assets/admin_assets/js/modules/tags.js"></script> 
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>
<script src="<?= base_url();?>/assets/admin_assets/js/modules/block-posts.js"></script> 
<?= $this->endSection();?>