<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class TagsModel extends Model
{

  protected $table = 'tags';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'alias', 'description', 'status', 'updated_at'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getAll()
    {
        $builder = $this->db->table('tags');
        $builder->where('deleted_at', null);
        $results = $builder->get()->getResult();
        return $results;
    }

    //Used in selectize
    public function getAllTags()
    {
        $builder = $this->db->table('tags');
        $builder->where('deleted_at', null);
        $results = $builder->get()->getResultArray(); // Retrieve results as an array
        return $results;
    }

    //Get Single Tag
    public function getSingleTag($id)
    {
      $builder = $this->db->table('tags');
      $builder->where('id', $id);
      $builder->orWhere('alias', $id);
      $results = $builder->get()->getRow();
      return $results;
    }

    //Get Single Tag
    public function checkSingleTag($id)
    {
      $builder = $this->db->table('tags');
      $builder->where('id', $id);
      $builder->orWhere('alias', $id);
      $results = $builder->get()->getRow();
      return $results;
    }
    /**
     * Get tags with post counts
     */
    public function getTagsWithCounts()
    {
        $builder = $this->db->table('usc_tags as t');
        $builder->select('t.*, COUNT(pt.id) as post_count');
        $builder->join('usc_post_tags as pt', 'pt.tag_id = t.id', 'left');
        $builder->join('usc_posts as p', 'p.id = pt.post_id AND p.deleted_at IS NULL AND p.status = "published"', 'left');
        $builder->where('t.status', '1');
        $builder->where('t.deleted_at', null);
        $builder->groupBy('t.id');
        $builder->orderBy('t.name', 'ASC');
        
        return $builder->get()->getResultArray();
    }

    /**
     * Search tags by name
     */
    public function searchTags($searchTerm)
    {
        $builder = $this->db->table('tags');
        $builder->select('*');
        $builder->where('deleted_at', null);
        if (!empty($searchTerm)) {
            $builder->groupStart()
                    ->like('name', $searchTerm)
                    ->orLike('alias', $searchTerm)
                    ->orLike('description', $searchTerm)
                    ->groupEnd();
        }
        $builder->orderBy('name', 'ASC');

        return $builder->get()->getResultArray();
    }

    /**
     * Get tags by post ID
     */
    public function getTagsByPostId($postId)
    {
        $builder = $this->db->table('usc_tags as t');
        $builder->select('t.*');
        $builder->join('usc_post_tags as pt', 'pt.tag_id = t.id');
        $builder->where('pt.post_id', $postId);
        $builder->where('t.status', '1');
        $builder->where('t.deleted_at', null);
        $builder->orderBy('t.name', 'ASC');
        
        return $builder->get()->getResultArray();
    }

}