<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class PostsCategoryModel extends Model
{

  protected $table = 'post_category';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'alias', 'photo','master_category_id', 'description', 'created_by', 'updated_at', 'updated_by'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    //Search for Categories
    public function searchCategories($searchTerm)
    {
        $builder = $this->db->table('post_category as pc');
        $builder->select('pc.*,  pmc.master_category_id, pmc.name as master_category, pmc.alias as master_category_alias ');
        $builder->join('post_category as pmc', 'pmc.id=pc.master_category_id');
        $builder->join('posts as p', 'p.category_id = pc.id');
        if (!empty($searchTerm)) {
            $builder->like('pc.name', $searchTerm)
                    ->orWhere('pc.alias', $searchTerm)
                    ->groupBy('pc.id');
        }
        $query = $builder->get();
        return $query->getResultArray();
    }

    //Get all Post Categories
    public function getAll()
    {
      $builder = $this->db->table('post_category');
      $builder->where('deleted_at', null);
      $builder->orderBy('id', 'DESC');
		  $result = $builder->get()->getResult();
		  return $result;
    }

    //Get All other categories apart from PAGES
    public function getOtherCategories()
    {
      $page = [1];
      $builder = $this->db->table('post_category');
      $builder->where('deleted_at', null);
      $builder->whereNotIn('id', $page);
      $builder->orderBy('id', 'DESC');
	  $result = $builder->get()->getResult();
	   return $result;
    }

    public function getSingleCategory($id){
      $builder = $this->db->table('post_category');
      $builder->where('id', $id);
      $builder->orWhere('alias', $id);
	  $result = $builder->get()->getRow();
	   return $result;
    }

    public function getParentCategory($id)
    {
        $builder = $this->db->table('post_category');
        $builder->select('master_category_id');
        $builder->where('id', $id); // Use 'id' instead of 'master_category_id'
        $result = $builder->get()->getRow();

        if ($result !== null) {
            $masterCategoryId = $result->master_category_id;

            // Fetch the master category name based on the master category ID
            $masterCategory = $this->db->table('post_category')
                ->select('name')
                ->where('id', $masterCategoryId)
                ->get()
                ->getRow();

            return $masterCategory;
        }

        return null;
    }

    public function getMainCategories()
    {
        $builder = $this->db->table('post_category');
        return $this->where('master_category_id', null)->findAll();
    }
    public function getSubcategoriesByMasterCategory($masterCategoryId)
    {
        $builder = $this->db->table('post_category');
        return $this->where('master_category_id', $masterCategoryId)->findAll();
    }

    // Recursive function to get categories and subcategories
    public function getCategoryList()
    {
        $categories = $this->findAll(); // Fetch all categories

        // Create a hierarchical structure for categories and subcategories
        $categoryTree = [];

        foreach ($categories as $category) {
            if ($category['master_category_id'] === null && $category['id'] != 1) {
                // This is a parent category (exclude category with id = 1)
                $categoryTree[$category['id']] = [
                    'name' => $category['name'],
                    'subcategories' => [],
                    'id' => $category['id'],
                ];
            } elseif ($category['id'] != 1) {
                // This is a subcategory (exclude category with id = 1)
                $categoryTree[$category['master_category_id']]['subcategories'][] = [
                    'id' => $category['id'],
                    'name' => $category['name'],
                ];
            }
        }

        return $categoryTree;
    }

    

}
