<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class PostCommentsModel extends Model
{

  protected $table = 'post_comments';
    protected $primaryKey = 'id';

    protected $allowedFields = ['post_id', 'parent_comment_id', 'reply_id','description', 'user_id', 'likes_count', 'dislikes_count', 'is_reported', 'report_count', 'user_agent',  'created_by', 'updated_at', 'updated_by'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    //Get All Post Comments
    public function getAll()
    {
      $builder = $this->db->table('post_comments as com');
      $builder->select('com.*, p.title as post_title, p.alias as post_alias, pc.name as post_category, first_name');
      $builder->join('posts as p', 'p.id=com.post_id');
      $builder->join('post_category as pc', 'pc.id=p.category_id');
      $builder->join('users as u', 'u.id=com.user_id');
      $builder->where('com.deleted_at', null);
      $results = $builder->get()->getResult();
      return $results;
    }

    //Get comments for a particular post
    public function getPostComments($post)
    {
      $builder = $this->db->table('post_comments as com');
      $builder->select('com.*, p.title as post_title, pc.name as post_category, first_name');
      $builder->join('posts as p', 'p.id=com.post_id');
      $builder->join('post_category as pc', 'pc.id=p.category_id');
      $builder->join('users as u', 'u.id=com.user_id');
      $builder->where('com.deleted_at', null);
      $builder->where('com.post_id', $post);
      $results = $builder->get()->getResult();
      return $results;
    }
}