<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class ContentTypesModel extends Model
{
    protected $table = 'content_types';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'name', 'slug', 'description', 'icon', 'fields_config', 
        'template_restrictions', 'is_hierarchical', 'supports_blocks', 
        'menu_position', 'is_active', 'created_by'
    ];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    /**
     * Get all active content types
     */
    public function getActiveTypes()
    {
        return $this->where('is_active', 1)
                    ->where('deleted_at', null)
                    ->orderBy('menu_position', 'ASC')
                    ->findAll();
    }
    /**
     * Get all active content types for menus
     */

    /**
     * Get content type by slug
     */
    public function getBySlug($slug)
    {
        return $this->where('slug', $slug)
                    ->where('deleted_at', null)
                    ->first();
    }

    /**
     * Get content type by ID
     */
    public function getById($id)
    {
        return $this->where('id', $id)
                    ->where('deleted_at', null)
                    ->first();
    }

    /**
     * Get content types with post counts
     */
    public function getWithPostCounts()
    {
        $builder = $this->db->table('usc_content_types as ct');
        $builder->select('ct.*, COUNT(p.id) as post_count');
        $builder->join('usc_posts as p', 'p.content_type_id = ct.id AND p.deleted_at IS NULL', 'left');
        $builder->where('ct.deleted_at', null);
        $builder->where('ct.is_active', 1);
        $builder->groupBy('ct.id');
        $builder->orderBy('ct.menu_position', 'ASC');
        return $builder->get()->getResultArray();
    }

 /**
     * Get available content items by type
     */
    
    public function getContentByType($contentTypeSlug, $onlyPublished = true)
    {
        $contentType = $this->getBySlug($contentTypeSlug);
        if (!$contentType) {
            return [];
        }

        $postsModel = new PostsModel();
        $builder = $postsModel->builder();
        
        $builder->select('id, title, alias, menu_link, content_type_id, status');
        $builder->where('content_type_id', $contentType['id']);
        $builder->where('deleted_at', null);
        
        if ($onlyPublished) {
            $builder->where('status', 'published');
        }
        
        $builder->orderBy('title', 'ASC');
        
        return $builder->get()->getResultArray();
    }
}
