<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4><?= $singleGroup->name; ?></h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/menu/groups') ?> ">Menu Groups</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- Notification messages !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Pages Detailed List !-->
<div class="row">
    
    <div class="col-lg-12 col-md-12 col-sm-12">
        <!-- Details of Menu Group !-->
        <div class="card card-body">
            <h4 class="fw-bold"><?= $singleGroup->name; ?>  <a href="<?= base_url('administrator/menu/groups'); ?>" class="btn btn-sm btn-dark rounded-0 float-sm-end">Back to Groups</a><a href="<?= base_url('administrator/menu/item/add'); ?>" class="btn btn-sm btn-primary rounded-0 float-sm-end">Add Menu Item</a></h4>
        <table id="menu-list" class="table table-hover">
                    <thead class="bg-primary bg-opacity-10" style="font-size: 13px;">
                        <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Parent</th>
                        <th>Menu Type</th>
                        <th>Level</th>
                        <th>Menu Group</th>
                        <th>Status</th>
                        <th></th>
                        </tr>
                    </thead>
                    <tbody style="font-size: 13px;">
                         
                        <?php foreach($menu_items as $item): ?>
                            <tr>
                            <td><?= $item->id; ?></td>
                            <td>
                                <a href="<?= base_url('administrator/menu/item/edit/'.$item->id.'-'.$item->alias) ?>"><?= $item->title; ?></a> <br>
                                <small class="text-muted"> <?= $item->link; ?></small>
                            </td>
                            <td><?= $item->parent_item ?? '<span class="text-muted">---</span>'; ?></td>
                            <td><?= $item->menu_type; ?></td>
                            <td><?= $item->level; ?></td>
                            <td><?= $item->menu_category; ?></td>
                                                        <td>
                                <?php
                                $status = $item->status;
                                $displayText = '';
                                $badgeClass = 'secondary';
                            
                                switch($status) {
                                    case 1: // Active
                                        $displayText = 'Active';
                                        $badgeClass = 'success';
                                        break;
                                    case 0: // Inactive
                                        $displayText = 'Inactive';
                                        $badgeClass = 'warning'; // Or danger, depending on desired visual
                                        break;
                                    default:
                                        $displayText = 'Unknown';
                                        $badgeClass = 'secondary';
                                        break;
                                }
                                ?>
                                <span class="badge rounded-pill bg-<?= $badgeClass ?>"><?= $displayText ?></span>
                            </td>                            <td>
                                <div class="btn-group dropstart">
                                <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="bi bi-three-dots-vertical"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="<?= base_url('administrator/menu/item/edit/'.$item->id.'-'.$item->alias) ?>"><small>Edit</small></a></li>
                                    <li><a  class="dropdown-item" onclick="delete_menuItem(<?= $item->id ?>, '<?= $item->title ?>')" style="cursor: pointer"><small>Delete</small></a></li>
                                </ul>
                                </div>
                            </td>
                            </tr>
                        <?php endforeach;?> 
                    </tbody>
                </table>
        </div>
        <!-- End Details of Menu Group !-->
    </div>
</div>
</div><!-- Container !-->     

<!-- Modal !-->
<?= view('Modules\Menu\Views\\modals\\edit_menuModal') ?>

<!---- JS --->  
<script type="text/javascript">
      $(document).ready(function () {
          $('#menu-list').DataTable();
      });

</script>       
<script src="<?= base_url();?>/assets/admin_assets/js/modules/admin-menu.js"></script>  
<?= $this->endSection();?>