<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Add Menu Item</h4>
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/menu/groups') ?> ">Menu Groups</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
	</div>
</div>

<div class="row">
    <div class="col">
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <div id="showMsg"></div>
</div></div>

<div class="card card-body">
    <div class="mb-2"><h5>&nbsp; <span class="float-end"><a href="<?= base_url('administrator/menu/groups'); ?>" class="btn btn-sm btn-dark rounded-0 float-sm-end">Back to Groups</a></span></h5></div>
    
    <div class="alert alert-success">
        <strong>Create Menu</strong>:  
        <small>Create menus based on content types from your database. The available options will change dynamically based on your selection.</small>
    </div>
    
    <?= form_open('administrator/menu/item/add', ['id' => 'menuForm']); ?>
    <div class="row g-md-5">
        <div class="col-lg-6 col-md-7">
            <div class="mb-3">
                <label class="form-label fw-bold" for="name">Name *</label>
                <input type="text" class="form-control" name="title" placeholder="Add Menu Name" required/>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-bold" for="menuType">Content Type</label>
                <select class="form-select" name="menu_type" id="menuType" required>
                    <option value="">Select Content Type</option>
                    <?php foreach($contentTypes as $type): ?>
                        <?php
                        // Map database slugs back to legacy slugs for JS compatibility
                        $jsSlug = $type['slug'];
                        if ($type['slug'] === 'blog') {
                            $jsSlug = 'post'; // JS expects 'post' for blog content
                        }
                        ?>
                        <option value="<?= $jsSlug ?>"><?= $type['name'] ?></option>
                    <?php endforeach; ?>
                    <option value="category">Category</option>
                    <option value="custom">Custom Link</option>
                </select>
            </div>

            <!-- Dynamic Content Selection -->
            <div id="contentOptions" class="mb-3" style="display: none;">
                <label class="form-label fw-bold">Select Content</label>
                <div id="contentDropdown"></div>
            </div>

            <!-- Custom Link Input -->
            <div id="customLinkOptions" class="mb-3" style="display: none;">
                <label class="form-label fw-bold">Custom Link</label>
                <input type="text" name="custom" class="form-control" placeholder="https://example.com/page" />
            </div>
        </div>

        <div class="col-lg-4 col-md-5">
            <div class="mb-3">
                <label class="form-label fw-bold">Menu Category</label>
                <select class="form-select" name="category_id" id="menuCategory" required>
                    <option value="">Select Menu Category</option>
                    <?php foreach($menuGroups as $group):?>
                    <option value="<?= $group->id ?>"><?= $group->name ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Parent Menu Item</label>
                <select class="form-select" name="parent_id" id="parentMenu">
                    <option value="">Select Parent</option>
                    <!-- Will be populated dynamically -->
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Level</label>
                <select class="form-select" name="level">
                    <option value="1">Level 1</option>
                    <option value="2">Level 2</option>
                    <option value="3">Level 3</option>
                    <option value="4">Level 4</option>
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Status</label>
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" name="status_toggle" id="statusToggle" value="1" checked>
                    <label class="form-check-label" for="statusToggle">
                        <span id="statusText">Active</span>
                    </label>
                </div>
                <input type="hidden" name="status" id="statusValue" value="1">
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Access</label>
                <select name="access" class="form-select">
                    <option value="Public">Public</option>
                    <option value="Private">Private</option>
                    <option value="Users">Users</option>
                </select>
            </div>
        </div>
        
        <div class="col-lg-2 col-md-2 col-sm-12 d-none d-lg-block">
            <div class="alert alert-primary">
                <h5>NOTE</h5>
                <p>To add a menu, you will need to ensure the Menu category is selected and proper menu type picked.<br/> Levels are also critically important in setup of the menu.</p>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12 mb-3">
            <label class="form-label fw-bold">Menu Link</label>
            <input type="text" class="form-control form-control-lg" name="link" id="menu_link_preview" placeholder="Link will be generated automatically" readonly/>
        </div>
        
        <div class="col-lg-12 col-md-12 col-sm-12">
            <button type="reset" class="btn btn-lg btn-secondary">Reset</button>
            <button type="submit" class="btn btn-lg btn-danger">Add Menu Item</button>
        </div>
    </div>
    <?= form_close(); ?>
</div>
</div>

<script>
window.baseUrl = '<?= base_url() ?>';
</script>

<script>
window.baseUrl = '<?= base_url() ?>';
</script>
<script src="<?= base_url();?>/assets/admin_assets/js/modules/admin-menu.js"></script>  
<?= $this->endSection();?>