<?php

namespace Modules\Menu\Models;

use CodeIgniter\Model;

class MenusCategoryModel extends Model
{

    protected $table = 'usc_menu_type';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name','alias','description','created_at','created_by','updated_at','updated_by','deleted_at'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    //Get all Post Categories
    public function getAll()
    {
      $builder = $this->db->table('usc_menu_type');
      $builder->where('deleted_at', null);
      $builder->orderBy('id', 'DESC');
		  $result = $builder->get()->getResult();
		  return $result;
    }

    public function getSingleGroup($id)
    {
      $builder = $this->db->table('usc_menu_type');
      $builder->where('alias', $id);
      $builder->where('deleted_at', null);
      return $result = $builder->get()->getRow();
    }

}
