<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="row">
    <div class="col">
        <?php if(session()->getTempdata('success')): ?>
            <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
        <?php endif;?>
        <?php if(session()->getTempdata('error')): ?>
            <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
        <?php endif;?>
        <?php if(isset($validation)): ?>
            <div class="alert alert-danger">
                <?= $validation->listErrors()?>
            </div>
        <?php endif;?>
        <div id="showMsg"></div>
    </div>
</div>

<form method="POST" action="<?= base_url('administrator/jobs/update')?>" enctype="multipart/form-data">
<?= csrf_field();?>
    <div class="card rounded-0 shadow-sm">
        <input type="hidden" name="id" value="<?= $singleJob->id; ?>" >
        <div class="card-header bg-light bg-opacity-100">
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                        <button type="submit" class="btn btn-sm btn-success align-items-center"> &nbsp; Update &nbsp;</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                        <a href="#" class="btn btn-sm btn-light">Save & Close</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-plus-lg"></i></button>
                        <a href="#" class="btn btn-sm btn-light">Save & New</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-danger bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                        <button type="reset" class="btn btn-sm btn-danger">Reset</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                        <a href="<?= base_url('administrator/jobs/dashboard') ?>" class="btn btn-sm btn-primary">Back to Jobs</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-7">
                    <div class="mb-3">
                        <label class="form-label"><strong>Title</strong></label>
                        <input type="text" name="title" value="<?= $singleJob->title ?>" class="form-control" required>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="mb-3">
                        <label class="form-label"><strong>Category</strong></label>
                        <select name="category_id" class="form-select" required>
                            <?php foreach ($categories as $value => $label): ?>
                                <option value="<?= $value ?>" <?= ($singleJob->category_id == $value) ? 'selected' : '' ?>>
                                    <?= $label ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-9">
                    <div class="mb-3">
                        <label class="form-label"><strong>Job Description</strong></label>
                        <textarea id="tiny" name="description" class="form-control" cols="10" rows="10" placeholder="Write summary job description here.."><?= $singleJob->description ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Upload File (JED)</label>
                        <input type="file" name="file" class="form-control form-control-lg" accept=".pdf, .docx, .doc,.xls,.xlsx, .zip,.7z, .ppt, .pptx">
                        <?php if($singleJob->file): ?>
                            <small><i>Current file: <a href="<?= base_url('media/downloads/documents/'.$singleJob->file); ?>" target="_blank">Download</a></i></small>
                        <?php else: ?>
                            <small><i>No file attached</i></small>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Available Positions</label>
                        <input type="number" name="positions" value="<?= $singleJob->positions ?>" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><strong>Job Type</strong></label>
                        <select name="job_type" class="form-select">
                            <option value="FullTime" <?= ($singleJob->job_type == "FullTime") ? "selected" : "" ?>>FullTime</option>
                            <option value="PartTime" <?= ($singleJob->job_type == "PartTime") ? "selected" : "" ?>>PartTime</option>
                            <option value="Contract" <?= ($singleJob->job_type == "Contract") ? "selected" : "" ?>>Contract</option>
                            <option value="Temporary" <?= ($singleJob->job_type == "Temporary") ? "selected" : "" ?>>Temporary</option>
                            <option value="Seasonal" <?= ($singleJob->job_type == "Seasonal") ? "selected" : "" ?>>Seasonal</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Deadline Date</label>
                        <input type="date" name="deadline_date" value="<?= date('Y-m-d', strtotime($singleJob->deadline_date)) ?>" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><strong>Status</strong></label>
                        <select name="status" class="form-select bg-success bg-opacity-75 text-white">
                            <option value="Published" <?= ($singleJob->status == "Published") ? "selected" : "" ?>>Published</option>
                            <option value="Unpublished" <?= ($singleJob->status == "Unpublished") ? "selected" : "" ?>>Unpublished</option>
                            <option value="Archived" <?= ($singleJob->status == "Archived") ? "selected" : "" ?>>Archived</option>
                            <option value="Trashed" <?= ($singleJob->status == "Trashed") ? "selected" : "" ?>>Trashed</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <div style="height: 150px; background: #F2F9FF; border-radius: 5px;">
                            <div id="postImgPreview"></div>
                            <small class="d-flex text-muted p-2">Add Photo</small>
                        </div>
                        <input type="file" name="photo" id="post_image" class="postImg upload-photo" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp">
                        <?php if($singleJob->photo): ?>
                            <div class="mt-2">
                                <small>Current photo:</small><br>
                                <img src="<?= base_url('media/downloads/images/'.$singleJob->photo); ?>" width="80px" class="mt-1">
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Url</label>
                        <input type="text" name="urls" value="<?= $singleJob->urls ?>" class="form-control">
                    </div>
                </div>
            </div>
            <div class="row mb-4">
                <div class="accordion accordion-flush" id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                            <button class="accordion-button collapsed bg-info bg-opacity-10 fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                                CONTACT DETAILS
                            </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                            <div class="accordion-body">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label class="form-label"><strong>Email</strong></label>
                                            <input type="email" name="email" value="<?= $singleJob->email ?>" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label class="form-label"><strong>Phone Number</strong></label>
                                            <input type="text" name="phone" value="<?= $singleJob->phone ?>" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label class="form-label"><strong>Address</strong></label>
                                            <textarea name="address" class="form-control"><?= $singleJob->address ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script src="<?= base_url();?>/assets/admin_assets/js/modules/jobs.js"></script>  
<?= $this->endSection();?>