<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="row">
    <div class="col">
        <?php if(session()->getTempdata('success')): ?>
            <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
        <?php endif;?>
        <?php if(session()->getTempdata('error')): ?>
            <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
        <?php endif;?>
        <?php if(isset($validation)): ?>
            <div class="alert alert-danger">
                <?= $validation->listErrors()?>
            </div>
        <?php endif;?>
        <div id="showMsg"></div>
    </div>
</div>

<div class="card card-body">
    <div class="d-flex bd-highlight mb-3">
        <div class="p-2 bd-highlight">
            <a href="<?= base_url('administrator/jobs/add'); ?>" class="btn btn-sm btn-success w-100"><i class="bi bi-plus"></i> Add New Job</a>
        </div>
        <div class="p-2 bd-highlight">
            <a href="<?= base_url('administrator/jobs/categories'); ?>" class="btn btn-sm btn-info w-100"><i class="bi bi-folder"></i> Categories</a>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-pencil-square"></i></button>
                <a href="#" class="btn btn-sm btn-light">Edit</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                <a href="#" class="btn btn-sm btn-light">Publish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-x-circle-fill text-danger"></i></button>
                <a href="#" class="btn btn-sm btn-light">Unpublish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-hdd-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Archived</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-trash-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Trashed</a>
            </div>
        </div>
        <div class="p-2 bd-grow-1 bd-highlight"> &nbsp;</div>
    </div>
    <div class="table-responsive">
        <table id="postslist" class="table table-stripped table-hover">
            <thead class="bg-primary bg-opacity-10" style="font-size: 14px">
                <tr>
                    <th>#</th>
                    <th>Title</th>
                    <th>Category</th>
                    <th>Positions</th>
                    <th>Created By</th>
                    <th>Deadline Date</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($jobs as $p): ?>
                    <tr>
                        <td><span class="badge rounded-pill bg-info"><?= $p->id; ?></span></td>
                        <td>
                            <a href="<?= base_url('administrator/jobs/edit/').$p->id; ?>" style="font-size: 15px;">
                                <?= $p->title; ?>
                            </a> 
                            <br/>
                            <small class="text-muted">
                                <?php if($p->file): ?>
                                    File: <a href="<?= base_url('media/downloads/documents/'.$p->file); ?>" target="_blank">Download</a>
                                <?php else: ?>
                                    No file attached
                                <?php endif; ?>
                            </small>
                        </td>
                        <td><?= $p->category_name ?? 'Uncategorized'; ?></td>
                        <td><?= $p->positions; ?></td>
                        <td><small><?= $p->first_name . ' ' . $p->last_name; ?></small></td>
                        <td><?= date('jS, M Y', strtotime($p->deadline_date)); ?></td>
                        <td>
                            <?php if($p->status == 'Published'):?>
                                <span class="badge rounded-pill bg-success"><?= $p->status ?></span> 
                            <?php elseif($p->status == 'Unpublished'):?>
                                <span class="badge rounded-pill bg-danger"><?= $p->status ?></span>
                            <?php elseif($p->status == 'Archived'):?>
                                <span class="badge rounded-pill bg-info"><?= $p->status ?></span>
                            <?php else:?>
                                <span class="badge rounded-pill bg-secondary"><?= $p->status ?></span>
                            <?php endif;?>
                        </td>
                        <td>
                            <div class="btn-group dropstart">
                                <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-three-dots-vertical"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="<?= base_url('administrator/jobs/edit/').$p->id; ?>"><small>Edit</small></a></li>
                                    <li><a class="dropdown-item" onclick="delete_job(<?=$p->id ?>, '<?=$p->title ?>')"><small>Delete</small></a></li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach;?>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#postslist').DataTable({
            pageLength: 10,
            order: [[0, "desc"]],
        });
    });

    function delete_job(id, name) {
        // Use modal-based confirmation if available
        if (typeof $ === 'function' && $('#delJobModal').length) {
            $('#jobname').text(name);
            $('#delJobModal').modal('show');
            $('#del-Jobbtn').off('click').on('click', function(){
                window.location.href = base_url+"administrator/jobs/delete/"+id;
            });
            return;
        }
        var confirmation = confirm('Are you sure you want to delete the job: '+name+'?');
        if(confirmation == true){
            window.location.href = base_url+"administrator/jobs/delete/"+id;
        }
    }
</script>
<?= view('Modules\Jobs\Views\modals\del_jobModal') ?>
<script src="<?= base_url();?>/assets/admin_assets/js/modules/jobs.js"></script>   
<?= $this->endSection();?>