<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="row">
    <div class="col">
        <?php if(session()->getTempdata('success')): ?>
            <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
        <?php endif;?>
        <?php if(session()->getTempdata('error')): ?>
            <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
        <?php endif;?>
        <?php if(isset($validation)): ?>
            <div class="alert alert-danger">
                <?= $validation->listErrors()?>
            </div>
        <?php endif;?>
        <div id="showMsg"></div>
    </div>
</div>

<form method="POST" action="<?= base_url('administrator/jobs/categories/add')?>">
<?= csrf_field();?>
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                        <button type="submit" class="btn btn-sm btn-success align-items-center"> &nbsp; Save &nbsp;</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                        <a href="<?= base_url('administrator/jobs/categories') ?>" class="btn btn-sm btn-primary">Back to Categories</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label"><strong>Name</strong></label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label"><strong>Parent Category</strong></label>
                        <select name="parent_id" class="form-select">
                            <option value="">None</option>
                            <?php foreach ($categories as $category): ?>
                                <option value="<?= $category->id ?>"><?= $category->name ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<?= $this->endSection();?>