<?php

namespace Modules\Jobs\Models;

use CodeIgniter\Model;

class JobsModel extends Model
{
    protected $table = 'usc_jobs';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title', 'alias', 'photo', 'file', 'deadline_date', 'positions', 'description', 'job_type', 'status', 'urls', 'phone', 'email', 'address', 'category_id', 'created_by', 'updated_at', 'updated_by'];

    protected $returnType = 'array';
    protected $useTimestamps = true;
    protected $useSoftDeletes = true;

    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    // Get all jobs with category and user
    public function getAll()
    {
        $builder = $this->db->table('usc_jobs as j');
        $builder->select('j.*, c.name as category_name, u.first_name, u.last_name');
        $builder->join('usc_jobs_category as c', 'c.id = j.category_id', 'left');
        $builder->join('usc_users as u', 'u.id = j.created_by', 'left');
        $builder->where('j.deleted_at', null);
        $builder->orderBy('j.id', 'DESC');
        $result = $builder->get()->getResult();
        return $result;
    }

    // Get single job with category and user
    public function getSingleJob($id)
    {
        $builder = $this->db->table('usc_jobs as j');
        $builder->select('j.*, c.name as category_name, u.first_name, u.last_name');
        $builder->join('usc_jobs_category as c', 'c.id = j.category_id', 'left');
        $builder->join('usc_users as u', 'u.id = j.created_by', 'left');
        $builder->where('j.id', $id);
        $builder->where('j.deleted_at', null);
        $result = $builder->get()->getRow();
        return $result;
    }

    // All Jobs for Homepage
    public function forHomePage()
    {
        $builder = $this->db->table('usc_jobs as j');
        $builder->select('j.*, u.first_name, u.last_name, c.name as category_name');
        $builder->join('usc_jobs_category as c', 'c.id = j.category_id', 'left');
        $builder->join('usc_users as u', 'u.id = j.created_by', 'left');
        $builder->where('j.deleted_at', null);
        $builder->where('j.status', 'Published');
        $result = $builder->get()->getResult();
        return $result;
    }

    // Generate slug from title
    public function generateSlug($title)
    {
        return preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($title)));
    }
}