<?php

namespace Modules\Jobs\Config;

use Config\Services;

$routes = Services::routes();

if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

$routes->group('administrator/jobs', [
    'filter' => 'isLoggedIn', 
    'filter' => 'checkPermission', 
    'namespace' => 'Modules\Jobs\Controllers'
], static function($routes) {
    $routes->get('dashboard', 'Jobs::index');
    $routes->match(['get', 'post'], 'add', 'Jobs::addJob');
    $routes->get('edit/(:num)', 'Jobs::editJob/$1');
    $routes->post('update', 'Jobs::updateJob');
    $routes->get('delete/(:num)', 'Jobs::delJob/$1');

    // Categories
    $routes->get('categories', 'Jobs::categories');
    $routes->match(['get', 'post'], 'categories/add', 'Jobs::addCategory');
    $routes->get('categories/edit/(:num)', 'Jobs::editCategory/$1');
    $routes->post('categories/update', 'Jobs::updateCategory');
    $routes->get('categories/delete/(:num)', 'Jobs::deleteCategory/$1');
});