<?php
$currentValue = isset($currentValue) ? $currentValue : '';
$inputName = isset($inputName) ? $inputName : 'currency_id';
$required = isset($required) ? 'required' : '';
?>

<div class="currency-selector-container">
    <input type="text" 
           class="form-control currency-search" 
           placeholder="Search country or currency..." 
           autocomplete="off">
    <input type="hidden" 
           name="<?= $inputName ?>" 
           class="currency-id-input" 
           value="<?= $currentValue ?>" 
           <?= $required ?>>
    <div class="currency-dropdown" style="display: none;">
        <div class="currency-list">
            <!-- Currency items will be populated here -->
        </div>
    </div>
</div>

<style>
.currency-selector-container {
    position: relative;
}
.currency-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white;
    border: 1px solid #ddd;
    border-radius: 4px;
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    margin-top: 2px;
}
.currency-item {
    padding: 8px 12px;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 10px;
    border-bottom: 1px solid #f0f0f0;
}
.currency-item:last-child {
    border-bottom: none;
}
.currency-item:hover {
    background-color: #f5f5f5;
}
.currency-item.selected {
    background-color: #e8f0fe;
}
.currency-item img {
    width: 32px;
    height: 24px;
    object-fit: contain;
    border: 1px solid #eee;
    border-radius: 2px;
}
.currency-item .currency-details {
    flex: 1;
}
.currency-item .currency-name {
    font-weight: bold;
    color: #333;
    font-size: 0.95em;
}
.currency-item .currency-code {
    color: #666;
    font-size: 0.85em;
}
.currency-search {
    padding-right: 30px;
}
.currency-search-icon {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    color: #666;
    pointer-events: none;
}
.currency-loading {
    padding: 1rem;
    text-align: center;
    color: #666;
}
.currency-error {
    padding: 1rem;
    text-align: center;
    color: #dc3545;
    font-size: 0.9em;
}
.currency-empty {
    padding: 1rem;
    text-align: center;
    color: #666;
    font-style: italic;
    font-size: 0.9em;
}
</style>

<script>
$(document).ready(function() {
    const container = $('.currency-selector-container');
    const searchInput = container.find('.currency-search');
    const dropdown = container.find('.currency-dropdown');
    const hiddenInput = container.find('.currency-id-input');
    let debounceTimeout;

    // Function to load currencies
    function loadCurrencies(search = '') {
        $.get('<?= base_url('administrator/forex/search-currencies') ?>', { search: search }, function(response) {
            const list = dropdown.find('.currency-list');
            list.empty();
            
            if (!response.success) {
                list.append(`<div class="currency-error">Error: ${response.message || 'Failed to load currencies'}</div>`);
                return;
            }
            
            if (response.data.length === 0) {
                list.append('<div class="currency-empty">No currencies found</div>');
                return;
            }
            
            response.data.forEach(country => {
                // Use the country code from countries table
                const countryCode = country.sortname ? country.sortname.toLowerCase() : 'xx';
                const flagUrl = `https://flagcdn.com/w40/${countryCode}.png`;
                
                const item = $(`
                    <div class="currency-item" data-id="${country.id}" data-code="${country.currency_code || ''}" data-symbol="${country.currency_symbol || ''}">
                        <img src="${flagUrl}" 
                             alt="${country.currency_code || countryCode}" 
                             onerror="this.onerror=null; this.src='https://flagcdn.com/w40/xx.png'"
                             loading="lazy">
                        <div class="currency-details">
                            <div class="currency-name">${country.currency_name} (${country.name})</div>
                            <div class="currency-code">${country.currency_code || ''} ${country.currency_symbol ? `(${country.currency_symbol})` : ''}</div>
                        </div>
                    </div>
                `);
                list.append(item);
            });
        }).fail(function(xhr, status, error) {
            const list = dropdown.find('.currency-list');
            list.empty().append(`<div class="currency-error">Failed to load currencies</div>`);
        });
    }

    // Search input handler
    searchInput.on('input', function() {
        clearTimeout(debounceTimeout);
        debounceTimeout = setTimeout(() => {
            loadCurrencies($(this).val());
            dropdown.show();
        }, 300);
    });

    // Click handler for currency items
    dropdown.on('click', '.currency-item', function() {
        const id = $(this).data('id');
        const name = $(this).find('.currency-name').text();
        hiddenInput.val(id);
        searchInput.val(name);
        dropdown.hide();
    });

    // Handle clicking outside
    $(document).on('click', function(e) {
        if (!container.is(e.target) && container.has(e.target).length === 0) {
            dropdown.hide();
        }
    });

    // Show dropdown when clicking the search input
    searchInput.on('click', function() {
        dropdown.show();
        if (!dropdown.find('.currency-item').length) {
            loadCurrencies();
        }
    });

    // Initial load if there's a pre-selected value
    if (hiddenInput.val()) {
        $.get('<?= base_url('administrator/forex/search-currencies') ?>', { id: hiddenInput.val() }, function(response) {
            if (response.success && response.data.length > 0) {
                searchInput.val(response.data[0].currency_name);
            }
        });
    }
});
</script>