<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- print success message !-->
<div class="row">
    <div class="col">
			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
            <?php endif;?>
            <div id="showMsg"></div>
    </div>
</div>

<!-- Edit Form !-->
<form method="POST" action="<?= base_url('administrator/downloads/update')?>" enctype="multipart/form-data">
<?= csrf_field(); ?>
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <!-- Save/New/Cancel Btns !-->
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                    <button type="submit" class="btn btn-sm btn-success align-items-center"> &nbsp; Update &nbsp;</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                    <a href="#" class="btn btn-sm btn-light">Save & Close</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-plus-lg"></i></button>
                    <a href="#" class="btn btn-sm btn-light">Save & New</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-danger bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <button type="reset" class="btn btn-sm btn-danger">Reset</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <a href="<?= base_url('administrator/downloads') ?>" class="btn btn-sm btn-primary">Back to Downloads</a>
                    </div>
                </div>
            </div>
            <!-- END Save/New/Cancel Btns !-->
        </div>
        <div class="card-body">
            <input type="hidden" name="id" value="<?= $singleDownload['id']; ?>">
            <div class="row">
                <div class="col-md-7">
                    <div class="mb-3">
                    <label class="form-label"><strong>Title <span class="text-danger">*</span></strong></label>
                    <input type="text" name="title" class="form-control <?= (isset($validation) && $validation->hasError('title')) ? 'is-invalid' : '' ?>" 
                           value="<?= old('title', $singleDownload['title']) ?>" required>
                    <?php if (isset($validation) && $validation->hasError('title')): ?>
                        <div class="invalid-feedback">
                            <?= $validation->getError('title') ?>
                        </div>
                    <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="mb-3">
                    <label class="form-label"><strong>Alias</strong></label>
                    <input type="text" name="alias" class="form-control bg-secondary bg-opacity-10" 
                           value="<?= old('alias', $singleDownload['alias']) ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-9">
                  <!-- Main post content !-->
                  <div class="mb-3">
                    <label class="form-label"><strong>Upload File</strong></label>
                    <input type="file" class="form-control form-control-lg" name="file">
                    <?php if(!empty($singleDownload['file'])): ?>
                        <div class="mt-2">
                            <small class="text-success">Current file: </small>
                            <a href="<?= base_url('media/downloads/files/' . $singleDownload['file']); ?>" target="_blank" class="text-primary">
                                <i class="bi bi-download"></i> <?= $singleDownload['file']; ?>
                            </a>
                        </div>
                        <small class="text-info d-block mt-1">Leave empty to keep the current file</small>
                    <?php else: ?>
                        <small class="text-danger">No file currently uploaded</small>
                    <?php endif; ?>
                  </div><!-- File / Document !-->
                  
                  <div class="mb-3">
                    <label class="form-label"><strong>Brief text <span class="text-danger">*</span></strong></label>
                    <textarea name="excerpt" class="form-control <?= (isset($validation) && $validation->hasError('excerpt')) ? 'is-invalid' : '' ?>"  
                              rows="2" placeholder="Write summary text here.." required><?= old('excerpt', $singleDownload['excerpt']) ?></textarea>
                    <?php if (isset($validation) && $validation->hasError('excerpt')): ?>
                        <div class="invalid-feedback">
                            <?= $validation->getError('excerpt') ?>
                        </div>
                    <?php endif; ?>
                  </div><!-- Excerpt !-->
                  
                  <div class="mb-3">
                    <label class="form-label"><strong>Content</strong></label>
                    <textarea id="tiny" name="content" class="form-control"  rows="5" placeholder="Write full text here.."><?= old('content', $singleDownload['content']) ?></textarea>
                  </div><!-- Content !-->
                  
                  <div class="mb-3">
                    <label class="form-label"><strong>Document Link</strong></label>
                    <input type="text" name="urls" class="form-control" placeholder="Provide Full document link if external file" 
                           value="<?= old('urls', $singleDownload['urls']) ?>">
                    <?php if(!empty($singleDownload['urls'])): ?>
                        <small class="text-muted">Current URL: <a href="<?= $singleDownload['urls'] ?>" target="_blank"><?= $singleDownload['urls']; ?></a></small>
                    <?php endif; ?>
                  </div><!-- URLs !-->
                  
                  <!-- END Main post content  !-->
                </div>
                <div class="col-lg-3">
                 <!-- Main post params !-->
                 <div class="mb-3">
                    <label class="form-label"><strong>Category <span class="text-danger">*</span></strong></label>
                    <select name="category_id" class="form-select <?= (isset($validation) && $validation->hasError('category_id')) ? 'is-invalid' : '' ?>" required>
                        <option value="">Select Category</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?= $cat->id;?>" <?= (old('category_id', $singleDownload['category_id']) == $cat->id) ? 'selected' : '' ?>>
                                <?= $cat->name;?>
                            </option>
                        <?php endforeach;?>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('category_id')): ?>
                        <div class="invalid-feedback">
                            <?= $validation->getError('category_id') ?>
                        </div>
                    <?php endif; ?>
                  </div>
                   <div class="mb-3">
                    <div style="height: 150px; background: #F2F9FF; border-radius: 5px; overflow: hidden;" id="photoPreviewContainer">
                        <div id="postImgPreview" class="h-100 d-flex align-items-center justify-content-center">
                            <?php if(!empty($singleDownload['photo'])): ?>
                                <img src="<?= base_url('media/downloads/photos/' . $singleDownload['photo']); ?>" class="img-fluid" style="max-height: 150px; object-fit: cover;" alt="<?= $singleDownload['title'] ?>">
                            <?php else: ?>
                                <small class="text-muted">No photo uploaded</small>
                            <?php endif; ?>
                        </div>
                    </div>
                    <input type="file" name="photo" id="post_image" class="form-control mt-2" accept=".jpg,.jpeg,.png,.gif,.webp">
                    <small class="text-muted">Leave empty to keep current photo</small>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Status</strong></label>
                    <select name="status" class="form-select">
                        <option value="Published" <?= (old('status', $singleDownload['status']) == 'Published') ? 'selected' : '' ?>>Published</option>
                        <option value="Unpublished" <?= (old('status', $singleDownload['status']) == 'Unpublished') ? 'selected' : '' ?>>Unpublished</option>
                        <option value="Archived" <?= (old('status', $singleDownload['status']) == 'Archived') ? 'selected' : '' ?>>Archived</option>
                        <option value="Trashed" <?= (old('status', $singleDownload['status']) == 'Trashed') ? 'selected' : '' ?>>Trashed</option>
                    </select>
                  </div>
                  
                  <div class="mb-3">
                    <label class="form-label"><strong>Access</strong></label>
                    <select name="access" class="form-select">
                        <option value="Public" <?= (old('access', $singleDownload['access']) == 'Public') ? 'selected' : '' ?>>Public</option>
                        <option value="Private" <?= (old('access', $singleDownload['access']) == 'Private') ? 'selected' : '' ?>>Private</option>
                        <option value="Users" <?= (old('access', $singleDownload['access']) == 'Users') ? 'selected' : '' ?>>Users</option>
                    </select>
                  </div>
                
                  <div class="mb-3">
                    <label class="form-label"><strong>Ordering</strong></label>
                    <input type="number" name="ordering" class="form-control" min="0" max="99" 
                           value="<?= old('ordering', $singleDownload['ordering']) ?>" placeholder="0">
                    <small class="text-muted">Lower numbers appear first</small>
                  </div>
                <!-- END Main post params  !-->
                </div>
            </div>
            
            <!-- Required Fields Note -->
            <div class="row mb-3">
                <div class="col-12">
                    <small class="text-muted"><span class="text-danger">*</span> indicates required fields</small>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="accordion accordion-flush" id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-info bg-opacity-10" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                           Add SEO meta description and keywords
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="row">
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Description</strong></label>
                    <textarea name="metadesc" class="form-control" placeholder="Provide description(150 words) for SEO experience"><?= old('metadesc', $singleDownload['metadesc']) ?></textarea>
                  </div>
                </div>
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Keywords</strong></label>
                    <textarea name="metakey" class="form-control" placeholder="SEO Keywords separated by comma"><?= old('metakey', $singleDownload['metakey']) ?></textarea>
                  </div>
                </div>
            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<!-- End Edit Form !-->

<script>
// Photo preview functionality for edit form
document.getElementById('post_image').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const previewContainer = document.getElementById('photoPreviewContainer');
    const preview = document.getElementById('postImgPreview');
    
    if (file) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            preview.innerHTML = `<img src="${e.target.result}" class="img-fluid" style="max-height: 150px; object-fit: cover;">`;
        }
        
        reader.readAsDataURL(file);
    } else {
        // If no file selected, show current photo if exists
        <?php if(!empty($singleDownload['photo'])): ?>
            preview.innerHTML = '<img src="<?= base_url('media/downloads/photos/' . $singleDownload['photo']); ?>" class="img-fluid" style="max-height: 150px; object-fit: cover;" alt="<?= $singleDownload['title'] ?>">';
        <?php else: ?>
            preview.innerHTML = '<small class="text-muted">No photo uploaded</small>';
        <?php endif; ?>
    }
});
</script>

<?= $this->endSection();?>