<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- Post Category ADD/EDIT/DELETE/Detailed List !-->
<div class="container">
<div class="row">
    <div class="col">

			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <div id="showMsg"></div>
</div></div>
<div class="row">
    <div class="col-lg-4"> 
        <div class="card">
                <?php if(!isset($singleCategory)):?>
				<div class="card-header"><h6 class="card-title fw-bold">Add Category</h6></div>
				<div class="card-body ">
                <!-- Add Category  !-->
                <form method="POST" action="<?= base_url('administrator/downloads/categories/add');?>">
                <?= csrf_field(); ?>
                <div class="row">
                    <div class="mb-3">
                        <label class="form-label">Category Name</label>
                        <input type="text" class="form-control" name="name">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" style="height: 80px;"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Parent Category</label>
                        <select class="form-select" name="parent_category_id" >
                            <option value="">Select Parent</option>
                            <?php foreach($categories as $c): ?>
                                <option value="<?= $c->id; ?>"><?= $c->name; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-outline-danger w-100" >Save</button>
                    </div>
                </div>
                </form>
            </div>
                <!-- End Add Category  !-->
                <?php else:?>
                <div class="card-header"><h6 class="card-title fw-bold">Edit Category</h6></div>
                <div class="card-body ">
                <!-- Edit Category  !-->
                    <form method="POST" action="<?= base_url('administrator/downloads/categories/update');?>">
                    <?= csrf_field(); ?>
                    <div class="row">
                        <div class="mb-3">
                            <label class="form-label">Category Name</label>
                            <input type="text" class="form-control" name="name" value="<?= $singleCategory['name']; ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" style="height: 80px;"><?= $singleCategory['description']; ?></textarea>
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Parent Category</label>
                        <select class="form-select" name="parent_category_id" >
                            <option value="">Select Parent</option>
                            <?php foreach($categories as $c): ?>
                                <option value="<?= $c->id; ?>" <?php if($c->id == $singleCategory['parent_category_id']) echo "selected";?>><?= $c->name; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                        <div class="mb-3">
                            <input type="hidden" name="id" value="<?= $singleCategory['id']; ?>" >
                            <button type="submit" class="btn btn-outline-danger w-100" >Edit</button>
                        </div>
                    </div>
                    </form>
                <!-- End Edit Category  !-->
                </div>
                <?php endif; ?>
        </div>
    </div>
    <div class="col-lg-8 "> 
        <!-- Display all categories !-->
        <div class="card">
        <div class="card-header"><h6 class="card-title fw-bold">All Categories <a href="<?= base_url('administrator/downloads') ?>" class="btn btn-sm btn-secondary float-end">Back to Downloads</a></h6></div> 
            <div class="card-body">
        <div class="table-responsive">
            <table id="catlist" class="table table-hover">
                <thead class="bg-primary bg-opacity-10" style="font-size: 14px;">
                    <tr>
                    <th>#</th>
                    <th>Title</th>
                    <th><i class="bi bi-check-lg text-success fw-bold"></i></th>
                    <th><i class="bi bi-x-circle-fill text-danger"></i></th>
                    <th><i class="bi bi-hdd-fill"></i></th>
                    <th><i class="bi bi-trash"></i></th>
                    <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($categories as $c): ?>
                        <tr>
                        <td><?= $c->id; ?></td>
                        <td><?= $c->name; ?> <small class="text-muted"> (<?= $c->alias; ?>)</small></td>
                        <td> <span class="badge rounded-pill bg-success"> - </span> </td>
                        <td> <span class="badge rounded-pill bg-danger"> - </span> </td>
                        <td> <span class="badge rounded-pill bg-secondary"> - </span> </td>
                        <td> <span class="badge rounded-pill bg-dark"> - </span> </td>
                        <td>
                        <div class="btn-group" role="group" aria-label="edit category">
                        <a href="<?= base_url('administrator/downloads/categories/edit/').'/'.$c->id; ?>" type="button" class="btn btn-success p-1 rounded-left"><small><i class="bi bi-pencil-square mx-0 "></i></small></a>
                        <button type="button" class="btn btn-danger p-1 rounded-right" data-bs-toggle="modal" data-bs-target="#delCategoryModal" onclick='deleteCategory(<?= $c->id; ?>, <?= json_encode($c->name); ?>)'><small><i class="bi bi-trash mx-0 "></i></small></button>

                        </div>
                        </td>
                        </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </div></div>
            
<!-- END Post Category ADD/EDIT/DELETE/Detailed List !-->
<!-- Modals !-->
<?= view('Modules\Downloads\Views\\modals\\del_categoryModal') ?>
<!---- JS --->  
<script type="text/javascript">
    $(document).ready(function () {
    $('#catlist').DataTable({
        pageLength: 10,
        order: [[0, "Desc"]],
    });
    });

</script>        
<script src="<?= base_url();?>/assets/admin_assets/js/modules/downloads.js"></script>  

<?= $this->endSection();?>