<?= $this->extend('Modules\Admin\Views\index'); ?>

<?= $this->section('content');?>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Show All Posts !-->
<div class="card card-body">
    <div class="d-flex bd-highlight mb-3">
        <div class="p-2 bd-highlight">
        <a href="<?= base_url('administrator/downloads/add'); ?>" class="btn btn-sm btn-success w-100"><i class="bi bi-plus"></i> Add New</a>
        </div>
        <div class="p-2 bd-highlight">
        <a href="<?= base_url('administrator/downloads/categories'); ?>" class="btn btn-sm btn-info w-100"><i class="bi bi-plus"></i> All Categories</a>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-pencil-square"></i></button>
                <a href="#" class="btn btn-sm btn-light">Edit</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                <a href="#" class="btn btn-sm btn-light">Publish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-x-circle-fill text-danger"></i></button>
                <a href="#" class="btn btn-sm btn-light">Unpublish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-hdd-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Arhived</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-trash-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Trashed</a>
            </div>
        </div>
        <div class="p-2 bd-grow-1 bd-highlight"> &nbsp;</div>
    </div>
    <div class="table-responsive">
        <table id="postslist" class="table table-stripped table-hover">
            <thead class="bg-primary bg-opacity-10" style="font-size: 14px"><tr>
                <th>#</th>
                <th></th>
                <th>Title</th>
                <th>Category</th>
                <th>Access</th>
                <th>Author</th>
                <th>Hits</th>
                <th>Date Created</th>
                <th>Status</th>
                <th></th>
            </tr></thead>
            <tbody>
            <?php foreach($downloads as $p): ?>
                    <tr>
                    <td><span class="badge rounded-pill bg-info"> <?= $p->id; ?> </span></td>
                    <td>
                        <?php if(!empty($p->photo)):?>
                            <img src="<?= base_url('media/downloads/photos/' . $p->photo); ?>" width="50px" alt="<?= $p->title; ?>">
                        <?php else: ?>
                            <div class="bg-light d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="bi bi-file-earmark text-muted"></i>
                            </div>
                        <?php endif;?>
                    </td>
                    <td>
                        <a href="<?= base_url('administrator/downloads/edit/').$p->id.'-'.$p->alias; ?>" style="font-size: 15px;"><?= $p->title; ?></a><br>
                        <?php if(!empty($p->file)): ?>
                            <small class="text-muted">
                                <a href="<?= base_url('media/downloads/files/' . $p->file); ?>" target="_blank" class="text-primary">
                                    <i class="bi bi-download"></i> <?= $p->file; ?>
                                </a>
                            </small>
                        <?php else: ?>
                            <small class="text-muted">No file uploaded</small>
                        <?php endif; ?>
                    </td>
                    <td><small><?= $p->category_name; ?></small></td>
                    <td><small><?= $p->access; ?></small></td>
                    <td><small><a href="#"><?= $p->first_name; ?></a></small></td>
                    <td><small><span class="badge bg-warning"><?= number_format($p->hits ?? 0) ?></span></small></td>
                    
                    <td><small><?= date('Y-m-d', strtotime($p->created_at)); ?></small></td>
                    <td>
                        <?php if($p->status == 'Published'):?>
                            <span class="badge rounded-pill bg-success"><?= $p->status ?></span> 
                        <?php elseif($p->status == 'Unpublished'):?>
                            <span class="badge rounded-pill bg-danger"><?= $p->status ?></span>
                        <?php elseif($p->status == 'Archived'):?>
                            <span class="badge rounded-pill bg-info"><?= $p->status ?></span>
                        <?php else:?>
                            <span class="badge rounded-pill bg-secodary"><?= $p->status ?></span>
                        <?php endif;?>
                    </td>
                    <td>
                    <div class="btn-group dropstart">
                    <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-three-dots-vertical"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?= base_url('administrator/downloads/edit/').$p->id.'-'.$p->alias; ?>"><small>Edit</small></a></li>
                        <?php if($userdata->group_id==1):?>
                        <li><a class="dropdown-item delete-download-link" data-id="<?= $p->id ?>" data-name="<?= $p->title ?>" style="cursor: pointer"><small>Delete</small></a></li>
                        <?php endif;?>
                    </ul>
                    </div>
                    </td>
                    </tr>
                    <?php endforeach;?>
            </tbody>
        </table>
    </div>
</div>
            
<!-- ... your existing HTML ... -->

<!---- Modals --->
<?= view('Modules\Downloads\Views\modals\del_downloadsModal') ?>

<!---- JS --->
<script type="text/javascript">
  $(document).ready(function () {
      $('#postslist').DataTable({
        pageLength: 10,
        order: [[0, "Desc"]],
      });
  });
</script>               
<script src="<?= base_url();?>/assets/admin_assets/js/modules/downloads.js"></script>   
<?= $this->endSection();?>