<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- print success message !-->
<div class="row">
    <div class="col">

			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
            <?php endif;?>
            <div id="showMsg"></div>
</div></div>
<!-- Create/Post !-->
<form method="POST" action="<?= base_url('administrator/downloads/add')?>" enctype="multipart/form-data">
<?= csrf_field(); ?>
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <!-- Save/New/Cancel Btns !-->
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                    <button type="submit" class="btn btn-sm btn-success align-items-center"> &nbsp; Save &nbsp;</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                    <a href="#" class="btn btn-sm btn-light">Save & Close</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-plus-lg"></i></button>
                    <a href="#" class="btn btn-sm btn-light">Save & New</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-danger bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <button type="reset" class="btn btn-sm btn-danger">Reset</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <a href="<?= base_url('administrator/downloads') ?>" class="btn btn-sm btn-primary">Back to Downloads</a>
                    </div>
                </div>
            </div>
            <!-- END Save/New/Cancel Btns !-->
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-7">
                    <div class="mb-3">
                    <label class="form-label"><strong>Title <span class="text-danger">*</span></strong></label>
                    <input type="text" name="title" class="form-control <?= (isset($validation) && $validation->hasError('title')) ? 'is-invalid' : '' ?>" 
                           value="<?= old('title') ?>" required>
                    <?php if (isset($validation) && $validation->hasError('title')): ?>
                        <div class="invalid-feedback">
                            <?= $validation->getError('title') ?>
                        </div>
                    <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="mb-3">
                    <label class="form-label"><strong>Alias</strong></label>
                    <input type="text" name="alias" class="form-control bg-secondary bg-opacity-10" value="<?= old('alias') ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-9">
                  <!-- Main post content !-->
                  <div class="mb-3">
                    <label class="form-label"><strong>Upload File <span class="text-danger">*</span></strong></label>
                    <input type="file" class="form-control form-control-lg <?= (isset($validation) && $validation->hasError('file')) ? 'is-invalid' : '' ?>" 
                           name="file" required>
                    <?php if (isset($validation) && $validation->hasError('file')): ?>
                        <div class="invalid-feedback">
                            <?= $validation->getError('file') ?>
                        </div>
                    <?php endif; ?>
                    <small class="text-muted">Please upload the document file (PDF, DOC, etc.) - Max 5MB</small>
                  </div><!-- File / Document !-->
                  
                  <div class="mb-3">
                    <label class="form-label"><strong>Brief text <span class="text-danger">*</span></strong></label>
                    <textarea name="excerpt" class="form-control <?= (isset($validation) && $validation->hasError('excerpt')) ? 'is-invalid' : '' ?>"  
                              rows="2" placeholder="Write summary text here.." required><?= old('excerpt') ?></textarea>
                    <?php if (isset($validation) && $validation->hasError('excerpt')): ?>
                        <div class="invalid-feedback">
                            <?= $validation->getError('excerpt') ?>
                        </div>
                    <?php endif; ?>
                  </div><!-- Excerpt !-->
                  
                  <div class="mb-3">
                    <label class="form-label"><strong>Content</strong></label>
                    <textarea id="tiny" name="content" class="form-control"  rows="5" placeholder="Write full text here.."><?= old('content') ?></textarea>
                  </div><!-- Content !-->
                  
                  <div class="mb-3">
                    <label class="form-label"><strong>Document Link</strong></label>
                    <input type="text" name="urls" class="form-control" placeholder="Provide Full document link if external file" value="<?= old('urls') ?>">
                    <small class="text-muted">Optional: External URL if file is hosted elsewhere</small>
                  </div><!-- URLs !-->
                  
                  <!-- END Main post content  !-->
                </div>
                <div class="col-lg-3">
                 <!-- Main post params !-->
                 <div class="mb-3">
                    <label class="form-label"><strong>Category <span class="text-danger">*</span></strong></label>
                    <select name="category_id" class="form-select <?= (isset($validation) && $validation->hasError('category_id')) ? 'is-invalid' : '' ?>" required>
                        <option value="">Select Category</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?= $cat->id;?>" <?= old('category_id') == $cat->id ? 'selected' : '' ?>>
                                <?= $cat->name;?>
                            </option>
                        <?php endforeach;?>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('category_id')): ?>
                        <div class="invalid-feedback">
                            <?= $validation->getError('category_id') ?>
                        </div>
                    <?php endif; ?>
                  </div>
                    <div class="mb-3">
                    <div style="height: 150px; background: #F2F9FF; border-radius: 5px; overflow: hidden;" id="photoPreviewContainer">
                        <div id="postImgPreview" class="h-100 d-flex align-items-center justify-content-center">
                            <small class="text-muted">Photo preview will appear here</small>
                        </div>
                    </div>
                    <input type="file" name="photo" id="post_image" class="form-control mt-2" accept=".jpg,.jpeg,.png,.gif,.webp">
                    <small class="text-muted">Optional: Upload a photo - Max 2MB, JPG, PNG, GIF, WEBP</small>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Status</strong></label>
                    <select name="status" class="form-select bg-success bg-opacity-75 text-white">
                        <option value="Published" <?= old('status', 'Published') == 'Published' ? 'selected' : '' ?>>Published</option>
                        <option value="Unpublished" <?= old('status') == 'Unpublished' ? 'selected' : '' ?>>Unpublished</option>
                        <option value="Archived" <?= old('status') == 'Archived' ? 'selected' : '' ?>>Archived</option>
                        <option value="Trashed" <?= old('status') == 'Trashed' ? 'selected' : '' ?>>Trashed</option>
                    </select>
                  </div>
                  
                  <div class="mb-3">
                    <label class="form-label"><strong>Access</strong></label>
                    <select name="access" class="form-select">
                        <option value="Public" <?= old('access', 'Public') == 'Public' ? 'selected' : '' ?>>Public</option>
                        <option value="Private" <?= old('access') == 'Private' ? 'selected' : '' ?>>Private</option>
                        <option value="Users" <?= old('access') == 'Users' ? 'selected' : '' ?>>Users</option>
                    </select>
                  </div>
                
                  <div class="mb-3">
                    <label class="form-label"><strong>Ordering</strong></label>
                    <select name="ordering" class="form-select">
                        <option value="">Select Order</option>
                        <option value="1" <?= old('ordering') == '1' ? 'selected' : '' ?>>1</option>
                        <option value="2" <?= old('ordering') == '2' ? 'selected' : '' ?>>2</option>
                        <option value="3" <?= old('ordering') == '3' ? 'selected' : '' ?>>3</option>
                        <option value="4" <?= old('ordering') == '4' ? 'selected' : '' ?>>4</option>
                        <option value="5" <?= old('ordering') == '5' ? 'selected' : '' ?>>5</option>
                        <option value="6" <?= old('ordering') == '6' ? 'selected' : '' ?>>6</option>
                        <option value="7" <?= old('ordering') == '7' ? 'selected' : '' ?>>7</option>
                        <option value="8" <?= old('ordering') == '8' ? 'selected' : '' ?>>8</option>
                        <option value="9" <?= old('ordering') == '9' ? 'selected' : '' ?>>9</option>
                        <option value="0" <?= old('ordering') == '0' ? 'selected' : '' ?>>0</option>
                    </select>
                  </div>
                <!-- END Main post params  !-->
                </div>
            </div>
            
            <!-- Required Fields Note -->
            <div class="row mb-3">
                <div class="col-12">
                    <small class="text-muted"><span class="text-danger">*</span> indicates required fields</small>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="accordion accordion-flush" id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-info bg-opacity-10" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                           Add SEO meta description and keywords
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="row">
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Description</strong></label>
                    <textarea name="metadesc" class="form-control" placeholder="Provide description(150 words) for SEO experience"><?= old('metadesc') ?></textarea>
                  </div>
                </div>
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Keywords</strong></label>
                    <textarea name="metakey" class="form-control" placeholder="SEO Keywords separated by comma"><?= old('metakey') ?></textarea>
                  </div>
                </div>
            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<!-- End Create/Post !-->
<!---- JS --->
<script>
// Photo preview functionality
document.getElementById('post_image').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const previewContainer = document.getElementById('photoPreviewContainer');
    const preview = document.getElementById('postImgPreview');
    
    if (file) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            preview.innerHTML = `<img src="${e.target.result}" class="img-fluid" style="max-height: 150px; object-fit: cover;">`;
        }
        
        reader.readAsDataURL(file);
    } else {
        preview.innerHTML = '<small class="text-muted">Photo preview will appear here</small>';
    }
});
</script>
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>  
<?= $this->endSection();?>