<?php

namespace Modules\Downloads\Models;

use CodeIgniter\Model;

class DownloadsModel extends Model
{

      protected $table = 'usc_downloads';    protected $primaryKey = 'id';

    protected $allowedFields = ['title', 'alias', 'photo','file', 'metadesc', 'metakey', 'content','excerpt', 'category_id', 'ordering', 'status', 'access', 'hits', 'tags', 'urls', 'metadesc', 'metakey', 'created_by', 'updated_at', 'updated_by'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    //Get all Post Categories
    public function getAll()
    {
      $builder = $this->db->table('downloads as d');
      $builder->select('d.*, dc.name as category_name, first_name, last_name, ');
      $builder->join('usc_downloads_category as dc', 'dc.id=d.category_id');
      $builder->join('users as u', 'u.id=d.created_by');
      $builder->where('d.deleted_at', null);
      $builder->orderBy('id', 'DESC');
		  $result = $builder->get()->getResult();
		  return $result;
    }
    public function getSinglePost($id)
    {
      $builder = $this->db->table('downloads as d');
      $builder->select('d.*, pc.name as category_name, first_name, last_name, ');
      $builder->where('id', $id);
      $builder->join('usc_downloads_category as dc', 'dc.id=d.category_id');
      $builder->join('users as u', 'u.id=d.created_by');
		  $result = $builder->get()->getRow();
		  return $result;
    }
    //Published Cat Posts
    public function getPublishedPosts($id)
    {
      $builder = $this->db->table('downloads');
      $builder->where('id', $id);
      $builder->where('status', 'Published');
      echo $builder->countAll();
    }

    //All Posts for Homepage
    public function forHomePage()
    {
      $builder = $this->db->table('downloads as d');
      $builder->select('d.*, dc.name as category_name, first_name, last_name, ');
      $builder->join('usc_downloads_category as dc', 'dc.id=d.category_id');
      $builder->join('users as u', 'u.id=d.created_by');
      $builder->where('d.status', 'Published');
		  $result = $builder->get()->getResult();
		  return $result;
    }

    //Get downloads by category
    public function getByCategory($category_id)
    {
      $builder = $this->db->table('downloads as d');
      $builder->select('d.*, dc.name as category_name, first_name, last_name, ');
      $builder->join('usc_downloads_category as dc', 'dc.id=d.category_id');
      $builder->join('users as u', 'u.id=d.created_by');
      $builder->where('d.category_id', $category_id);
      $builder->where('d.deleted_at', null);
      $builder->orderBy('d.id', 'DESC');
		  $result = $builder->get()->getResult();
		  return $result;
    }
}
