<?php

namespace Modules\Downloads\Models;

use CodeIgniter\Model;

class DownloadsCategoryModel extends Model
{

  protected $table = 'downloads_category';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'alias', 'parent_category_id', 'description', 'created_by', 'updated_at', 'updated_by'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    //Get all Post Categories
 public function getAll()
{
$builder = $this->db->table($this->table);
$builder->where('deleted_at', null); // Only non-deleted
$builder->orderBy('id', 'DESC');
$result = $builder->get()->getResult();
return $result;
}

}
