<?php

namespace Modules\Downloads\Controllers;

use App\Controllers\Auth\AuthController;
use Modules\Downloads\Models\DownloadsCategoryModel;
use Modules\Downloads\Models\DownloadsModel;

class Downloads extends AuthController
{

  public $downloadscategoryModel;
  public $downloadsModel;
  public function initController($request, $response, $logger)
  {
    parent::initController($request, $response, $logger);
    $this->downloadscategoryModel = new DownloadsCategoryModel();
    $this->downloadsModel = new DownloadsModel();

  }
  public function index()
  {	
    // display header information
		$this->data['title'] = "Downloads";
    $this->data['bcrumb'] = "Downloads";

    $this->data['downloads'] = $this->downloadsModel->getAll();

		return view('Modules\Downloads\Views\all', $this->data);
  }
/**========================================================================
 * DOWNLOADS /ADD/EDIT/DELETE
 ==========================================================================*/
  public function addDownload()
  {
    $this->data['title'] = "Add Download";
    $this->data['bcrumb'] = "Add Download";

    $this->data['authors'] = $this->usersModel->getAll();
    $this->data['categories']=$this->downloadscategoryModel->getAll();
    if($this->request->getMethod() == 'POST'){

      $rules = [
        'title' => ['label'=>'Post Title', 'rules'=>'required'],
      ];
      $photoRules = [
        'photo' => [
            'label' => 'Image File',
            'rules' => 'uploaded[photo]'
                . '|is_image[photo]'
                . '|mime_in[photo,image/jpg,image/jpeg,image/gif,image/png,image/webp]'
                . '|max_size[photo,2024]'
        ],
      ];
      $fileRules = [
        'file' => [
            'label' => 'File',
            'rules' => 'uploaded[file]'
                . '|max_size[file,5024]'
        ],
      ];
      if($this->validate($rules))
      {
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));
        $doc = $this->request->getFile('file');
        $file1 = $this->request->getFile('photo');

        //Upload Document file
        if($this->validate($fileRules)){
          $size = $doc->getSizeByUnit('kb');
          $ext = $doc->guessExtension();
          $newDoc4 = $doc->getClientName();
          $doc->move(ROOTPATH . 'media/downloads/files', $newDoc4);
          $doc4 = $newDoc4; // Save only filename

          // Upload Photo if provided
          $photoName = '';
          if ($file1 && $file1->isValid() && !$file1->hasMoved()) {
              if($this->validate($photoRules)) { 
                  $newName4 = $file1->getRandomName();
                  $file1->move(ROOTPATH . 'media/downloads/photos', $newName4);
                  $photoName = $newName4; // Save only filename
              } else {
                  $this->data['validation'] = $this->validator;
                  session()->setTempdata('error', 'Invalid photo file. Please check the format and size.', 3);
                  return redirect()->to('administrator/downloads/add');
              }
          }

          $postData = [
            'title'          => $this->request->getVar("title"),
            'alias'          => $slug,
            'file'           => $doc4,
            'photo'          => $photoName,
            'content'        => $this->request->getVar("content"),
            'excerpt'        => $this->request->getVar("excerpt"),
            'ordering'       => $this->request->getVar("ordering"),
            'category_id'    => $this->request->getVar("category_id"),
            'status'         => $this->request->getVar("status"), 
            'access'         => $this->request->getVar("access"),
            'urls'           => $this->request->getVar("urls"),
            'tags'           => $this->request->getVar("tags"),
            'metadesc'       => $this->request->getVar("metadesc"),
            'metakey'        => $this->request->getVar("metakey"),
            'created_by'     => $this->userdata->user_id,
          ];
          
          $results = $this->downloadsModel->save($postData);
          
          if($results)
          {
            // Use standardized notification method
            $adminmessage = 'New Download created: ' . $this->request->getVar("title");
            $notificationType = 'content';
            $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

            session()->setTempdata('success', 'Document added successfully', 3);
            return redirect()->to('administrator/downloads');
          }else{
            session()->setTempdata('error', 'Document  NOT added', 3);
            return redirect()->to('administrator/downloads/add');
          }

        }else{
            session()->setTempdata('error', 'File is to big. Must be less than 5MB', 3);
            return redirect()->to('administrator/downloads/add');
        }
      }else{
        session()->setTempdata('error', 'Download Title can not be empty', 3);
        return redirect()->to('administrator/downloads/add');
      }
    }

    return view('Modules\Downloads\Views\add_download', $this->data);
  }
  public function editDownload($id = null)
  {
    $this->data['title'] = "Edit Download";
    $this->data['bcrumb'] = "Edit Download";

    $this->data['authors'] = $this->usersModel->getAll();
    $this->data['categories']=$this->downloadscategoryModel->getAll();
    $this->data['singleDownload'] = $this->downloadsModel->where('id', $id)->first($id);

    return view('Modules\Downloads\Views\edit_download', $this->data);
  }
 public function updateDownload()
{
    $this->data['title'] = "Edit Download";
    $this->data['bcrumb'] = "Edit Download";

    $this->data['authors'] = $this->usersModel->getAll();
    $this->data['categories'] = $this->downloadscategoryModel->getAll();

    if ($this->request->getMethod() == 'POST') {
        $id = $this->request->getVar('id');

        $rules = [
            'title' => ['label' => 'Post Title', 'rules' => 'required'],
        ];

        if ($this->validate($rules)) {

            $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));

            $postData = [
                'title' => $this->request->getVar("title"),
                'alias' => $slug,
                'content' => $this->request->getVar("content"),
                'excerpt' => $this->request->getVar("excerpt"),
                'ordering' => $this->request->getVar("ordering"),
                'category_id' => $this->request->getVar("category_id"),
                'status' => $this->request->getVar("status"),
                'access' => $this->request->getVar("access"),
                'urls' => $this->request->getVar("urls"),
                'tags' => $this->request->getVar("tags"),
                'metadesc' => $this->request->getVar("metadesc"),
                'metakey' => $this->request->getVar("metakey"),
                'created_by' => $this->userdata->user_id,
            ];

            $doc = $this->request->getFile('file');
            $file1 = $this->request->getFile('photo');

            // Handle document file upload
            if ($doc && $doc->isValid() && !$doc->hasMoved()) {
                $fileRules = [
                    'file' => [
                        'label' => 'File',
                        'rules' => 'uploaded[file]|max_size[file,5024]',
                    ],
                ];

                if ($this->validate($fileRules)) {
                    $size = $doc->getSizeByUnit('kb');
                    $ext = $doc->guessExtension();
                    $newDoc4 = $doc->getClientName();
                    $doc->move(ROOTPATH . 'media/downloads/files', $newDoc4);
                    $postData['file'] = $newDoc4; // Save only filename
                } else {
                    session()->setTempdata('error', 'File is too big. Must be less than 5MB', 3);
                    return redirect()->to('administrator/downloads/edit/' . $id . '-' . $slug);
                }
            }

            // Handle photo file upload
            if ($file1 && $file1->isValid() && !$file1->hasMoved()) {
                $photoRules = [
                    'photo' => [
                        'label' => 'Image File',
                        'rules' => 'uploaded[photo]|is_image[photo]'
                            . '|mime_in[photo,image/jpg,image/jpeg,image/gif,image/png,image/webp]'
                            . '|max_size[photo,2024]',
                    ],
                ];

                if ($this->validate($photoRules)) {
                    $newName4 = $file1->getRandomName();
                    $file1->move(ROOTPATH . 'media/downloads/photos', $newName4);
                    $postData['photo'] = $newName4; // Save only filename
                } else {
                    $this->data['validation'] = $this->validator;
                    session()->setTempdata('error', 'Invalid photo file. Please check the format and size.', 3);
                    return redirect()->to('administrator/downloads/edit/' . $id . '-' . $slug);
                }
            }

            if ($this->downloadsModel->update($id, $postData)) {
                // Use standardized notification method
                $adminmessage = 'Download updated: ' . $this->request->getVar("title");
                $notificationType = 'content';
                $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

                session()->setTempdata('success', 'Download updated successfully', 3);
                return redirect()->to('administrator/downloads');
            } else {
                session()->setTempdata('error', 'Download NOT updated', 3);
                return redirect()->to('administrator/downloads/edit/' . $id . '-' . $slug);
            }
        } else {
            $this->data['validation'] = $this->validator;
        }
    }

    return view('Modules\Downloads\Views\edit_download', $this->data);
}

  public function delDownload($id)
  {
    $download = $this->downloadsModel->where('id', $id)->first($id);
    
    if (empty($download)) {
      session()->setTempdata('error', 'Download not found', 3);
      return redirect()->to('administrator/downloads');
    }

    // delete the record
    $this->downloadsModel->where('id', $id)->delete($id);

    // support both object and array result shapes
    $title = is_object($download) ? ($download->title ?? '') : ($download['title'] ?? '');

    // Use standardized notification method
    $adminmessage = 'Download deleted: ' . $title;
    $notificationType = 'content';
    $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

    session()->setTempdata('success', 'Download deleted successfully', 3);
    return redirect()->to('administrator/downloads');
  }
/**========================================================================
 * DOWNLOAD CATEGORY /ADD/EDIT/DELETE
 ==========================================================================*/
  public function downloadsCategories()
  {
    // display header information
		$this->data['title'] = "Downloads Categories";
    $this->data['bcrumb'] = "Downloads Categories";

    $this->data['categories'] = $this->downloadscategoryModel->getAll();

    return view('Modules\Downloads\Views\category', $this->data);
  }

  public function addCategory()
  {    
    $this->data['categories'] = $this->downloadscategoryModel->getAll();
   
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'name' => ['label'=>'Category Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
          $productData = [
              'name'          => $this->request->getVar("name"),
              'alias'         => $slug,
              'description'   => $this->request->getVar("description"),
              'parent_category_id'   => $this->request->getVar("parent_category_id"),
              'created_by'    => $this->userdata->user_id,
          ];
          
          if($this->downloadscategoryModel->save($productData))
          {
            // Use standardized notification method
            $adminmessage = 'New Download Category created: ' . $this->request->getVar("name");
            $notificationType = 'content';
            $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

            session()->setTempdata('success', 'Category added successfully', 3);
            return redirect()->to('administrator/downloads/categories');
          }else{
              session()->setTempdata('error', 'Category NOT added', 3);
              return redirect()->to('administrator/downloads/categories');
          }
      }else{
        session()->setTempdata('error', 'Category Name can not be empty', 3);
        return redirect()->to('administrator/downloads/categories');
      }
    }
    return view('Modules\Posts\Views\category', $this->data);
  }
  public function editCategory($id = null)
  {
    $this->data['title'] = "Downloads  Categories";
    $this->data['bcrumb'] = "Downloads  Categories";

    $this->data['categories'] = $this->downloadscategoryModel->getAll();
    $this->data['singleCategory'] = $this->downloadscategoryModel->where('id', $id)->first($id);

    return view('Modules\Downloads\Views\category', $this->data);
  }
  public function updateCategory()
  {
    $this->data['title'] = "Downloads Categories";
    $this->data['bcrumb'] = "Downloads  Categories";

    $this->data['categories'] = $this->downloadscategoryModel->getAll();
   
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'name' => ['label'=>'Category Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {

          $id = $this->request->getVar("id");
          $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
          $productData = [
              'name'          => $this->request->getVar("name"),
              'alias'         => $slug,
              'description'   => $this->request->getVar("description"),
              'parent_category_id'   => $this->request->getVar("parent_category_id"),
              'updated_by'    => $this->userdata->user_id,
              'updated_at'    => date("Y-m-d H:i:s"),
          ];
          
          if($this->downloadscategoryModel->update($id, $productData))
          {
            // Use standardized notification method
            $adminmessage = 'Download Category updated: ' . $this->request->getVar("name");
            $notificationType = 'content';
            $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

            session()->setTempdata('success', 'Category updated successfully', 3);
            return redirect()->to('administrator/downloads/categories');
          }else{
              session()->setTempdata('error', 'Category NOT updated', 3);
              return redirect()->to('administrator/downloads/categories');
          }
      }else{
        session()->setTempdata('error', 'Category Name can not be empty', 3);
        return redirect()->to('administrator/downloads/categories');
      }
    }
    return view('Modules\Downloads\Views\category', $this->data);
  }
  public function delCategory($id)
{
    $category = $this->downloadscategoryModel->where('id', $id)->first($id);

    if (empty($category)) {
        // If the request was AJAX, return JSON
        if ($this->request->isAJAX()) {
            return $this->response->setJSON([
                'error' => true,
                'msg'   => 'Category not found'
            ]);
        }
        session()->setTempdata('error', 'Category not found', 3);
        return redirect()->to('administrator/downloads/categories');
    }

    // Delete the category using the correct model
    $this->downloadscategoryModel->where('id', $id)->delete($id);

    // Support both object and array shapes
    $name = is_object($category) ? ($category->name ?? '') : ($category['name'] ?? '');

    // Use standardized notification method
    $adminmessage = 'Download Category deleted: ' . $name;
    $notificationType = 'content';
    $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

    // If the request was AJAX, return JSON so the client can parse it
    if ($this->request->isAJAX()) {
        $response = [
            'error' => false,
            'msg'   => 'Category deleted successfully',
        ];
        return $this->response->setJSON($response);
    }

    // Non-AJAX fallback: set flash data and redirect back to categories list
    session()->setTempdata('success', 'Category deleted successfully', 3);
    return redirect()->to('administrator/downloads/categories');
}
  
}