<?php

namespace Modules\Downloads\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}


//setting up Inventory routes.
$routes->group('administrator/downloads', ['filter' => 'isLoggedIn', 'filter' => 'checkPermission',  'namespace' => 'Modules\Downloads\Controllers'],   static function($routes){

    $routes->GET('/', 'Downloads::index');
    $routes->GET('add', 'Downloads::addDownload');
    $routes->POST('add', 'Downloads::addDownload');
    $routes->GET('edit/(:any)', 'Downloads::editDownload/$1');
    $routes->POST('update', 'Downloads::updateDownload');
    $routes->GET('delete/(:any)', 'Downloads::delDownload/$1');
    // Accept POST for delete as some modules perform AJAX POST requests for deletes
    $routes->POST('delete/(:any)', 'Downloads::delDownload/$1');

    $routes->GET('categories', 'Downloads::downloadsCategories');
    $routes->POST('categories/add', 'Downloads::addCategory');
    $routes->GET('categories/edit/(:any)', 'Downloads::editCategory/$1');
    $routes->POST('categories/update',  'Downloads::updateCategory');
    // Support GET deletes (used by simple redirects) and POST (used by AJAX)
    $routes->GET('categories/delete/(:any)', 'Downloads::delCategory/$1');
    $routes->POST('categories/delete/(:num)', 'Downloads::delCategory/$1');

});
