<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- Post Category ADD/EDIT/DELETE/Detailed List !-->
<div class="container">
    <div class="row">
        <div class="col-lg-12">
            <div class="row">
                <div class="col-lg-4">
                    <a href="<?= base_url('administrator/feedback');?>">
                       <div class="card card-body">
                           <h4>Customer Feedback</h4>
                       </div>
                    </a>
                </div>
                <div class="col-lg-4">
                    <a href="<?= base_url('administrator/feedback/responses');?>">
                       <div class="card card-body">
                           <h4>ABC Responses</h4>
                       </div>
                    </a>
                </div>
                <div class="col-lg-4">
                    <a href="<?= base_url('administrator/feedback/subjects');?>">
                       <div class="card card-body">
                           <h4>Subjects / Questions</h4>
                       </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- print success message !-->
<div class="row mt-2">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
    <div class="card card-body mt-3">
        <h4>Customer Feedback</h4>
        <div class="table-responsive">
            <table id="postslist" class="table table-stripped table-hover">
                <thead class="bg-primary bg-opacity-10" style="font-size: 14px"><tr>
                    <th>#</th>
                    <th>Aurthor</th>
                    <th>Feedback / Message</th>
                    <th>Date</th>
                    <th></th>
                </tr></thead>
                <tbody>
                <?php foreach($feedback as $p): ?>
                        <tr>
                        <td><span class="badge rounded-pill bg-info"> <?= $p->id; ?> </span></td>
                        <td>
                            <strong><?= $p->name; ?></strong><br>
                            <small class="text-muted">
                                <?= $p->email; ?><br>
                                <?= $p->phone; ?>
                            </small>
                        </td>
                        <td>
                            <strong><?= $p->subject_name; ?></strong><br>
                            <small class="text-muted"><?= $p->account_name; ?></small>
                            <p><?= $p->message; ?></p>
                        </td>
                        <td><?= date('jS, M Y', strtotime($p->created_at)); ?></td>
                        <td>
                        <div class="btn-group dropstart">
                        <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-three-dots-vertical"></i>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?= base_url('administrator/feedback/edit/').'/'.$p->id; ?>"><small>Edit</small></a></li>
                            <li><a href="<?= base_url('administrator/feedback/delete/').'/'.$p->id; ?>" class="dropdown-item"  ><small>Delete</small></a></li>
                        </ul>
                        </div>
                        </td>
                        </tr>
                        <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- END Feedback/Customer Care ADD/EDIT/DELETE/Detailed List !-->
 <!---- JS ---->
<script type="text/javascript">
      $(document).ready(function () {
          $('#postslist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
          });
      });

</script>
<?= $this->endSection();?>
