<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- Customer Feedback Management !-->
<div class="container">
    <!-- Navigation Tabs -->
    <ul class="nav nav-tabs" id="customerCareTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="customer-feedback-tab" data-bs-toggle="tab" data-bs-target="#customer-feedback" type="button" role="tab" aria-controls="customer-feedback" aria-selected="true">
                <h5>Customer Feedback</h5>
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="abc-responses-tab" data-bs-toggle="tab" data-bs-target="#abc-responses" type="button" role="tab" aria-controls="abc-responses" aria-selected="false">
                <h5>ABC Responses</h5>
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="subjects-tab" data-bs-toggle="tab" data-bs-target="#subjects" type="button" role="tab" aria-controls="subjects" aria-selected="false">
                <h5>Subjects / Questions</h5>
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="subject-answers-tab" data-bs-toggle="tab" data-bs-target="#subject-answers" type="button" role="tab" aria-controls="subject-answers" aria-selected="false">
                <h5>Subject Answers</h5>
            </button>
        </li>
    </ul>

    <!-- print success message !-->
    <div class="row mt-2">
        <div class="col">
            <?php if(session()->getTempdata('success')): ?>
                <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
            <?php endif;?>
            <!-- print failure message !-->
            <?php if(session()->getTempdata('error')): ?>
                <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
            <?php endif;?>
            <?php if(isset($validation)): ?>
                <div class="alert alert-danger">
            <?= $validation->listErrors()?>
            </div>
            <?php endif;?>
            <div id="showMsg"></div>
        </div>
    </div>

    <!-- Tab Content -->
    <div class="tab-content" id="customerCareTabContent">
        <div class="tab-pane fade show active" id="customer-feedback" role="tabpanel" aria-labelledby="customer-feedback-tab">
        <div class="card card-body mt-3">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4>Customer Feedback</h4>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addFeedbackModal">
                    <i class="bi bi-plus-circle"></i> Add Feedback
                </button>
            </div>
            <div class="table-responsive">
                <table id="feedbacklist" class="table table-stripped table-hover">
                    <thead class="bg-primary bg-opacity-10" style="font-size: 14px"><tr>
                        <th>#</th>
                        <th>Author</th>
                        <th>Feedback / Message</th>
                        <th>Date</th>
                        <th></th>
                    </tr></thead>
                    <tbody>
                    <?php foreach($feedback as $p): ?>
                            <tr>
                            <td><span class="badge rounded-pill bg-info"> <?= $p->id; ?> </span></td>
                            <td>
                                <strong><?= $p->name; ?></strong><br>
                                <small class="text-muted">
                                    <?= $p->email; ?><br>
                                    <?= $p->phone; ?>
                                </small>
                            </td>
                            <td>
                                <strong><?= $p->subject_name; ?></strong><br>
                                <small class="text-muted"><?= $p->account_name; ?></small>
                                <p><?= $p->message; ?></p>
                            </td>
                            <td><?= date('jS, M Y', strtotime($p->created_at)); ?></td>
                            <td>
                            <div class="btn-group dropstart">
                            <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-three-dots-vertical"></i>
                            </button>
                            <ul class="dropdown-menu">
                                <!-- <li><button class="dropdown-item" onclick="editFeedback(<?= $p->id; ?>)"><small>Edit</small></button></li> -->
                                <li><button class="dropdown-item" onclick="deleteFeedback(<?= $p->id; ?>)"><small>Delete</small></button></li>
                            </ul>
                            </div>
                            </td>
                            </tr>
                            <?php endforeach;?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- ABC Responses Tab Content -->
    <div class="tab-pane fade" id="abc-responses" role="tabpanel" aria-labelledby="abc-responses-tab">
        <div class="card card-body mt-3">
            <h4>ABC Responses to Customer Feedback</h4>
            <div class="table-responsive">
                <table id="responseslist" class="table table-stripped table-hover">
                    <thead class="bg-primary bg-opacity-10" style="font-size: 14px">
                        <tr>
                            <th>#</th>
                            <th>Customer</th>
                            <th>Feedback</th>
                            <th>Response Status</th>
                            <th>Response Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach($feedback as $p): ?>
                        <tr>
                            <td><span class="badge rounded-pill bg-info"> <?= $p->id; ?> </span></td>
                            <td>
                                <strong><?= $p->name; ?></strong><br>
                                <small class="text-muted">
                                    <?= $p->email; ?><br>
                                    <?= $p->phone; ?>
                                </small>
                            </td>
                            <td>
                                <strong><?= $p->subject_name; ?></strong><br>
                                <small class="text-muted"><?= substr($p->message, 0, 100); ?>...</small>
                            </td>
                            <td>
                                <?php if(empty($p->response)): ?>
                                    <span class="badge bg-warning">Pending Response</span>
                                <?php else: ?>
                                    <span class="badge bg-success">Responded</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?= !empty($p->responded_at) ? date('jS, M Y', strtotime($p->responded_at)) : 'N/A'; ?>
                            </td>
                            <td>
                                <div class="btn-group dropstart">
                                    <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-three-dots-vertical"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#responseModal<?= $p->id; ?>"><small>Add Response</small></a></li>
                                        <?php if(!empty($p->response)): ?>
                                            <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#viewResponseModal<?= $p->id; ?>"><small>View Response</small></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach;?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Subjects Tab Content -->
    <div class="tab-pane fade" id="subjects" role="tabpanel" aria-labelledby="subjects-tab">
        <div class="row">
            <div class="col-lg-4">
                <div class="card">
                        <?php if(!isset($singleSubject)):?>
                        <div class="card-header"><h6 class="card-title fw-bold">Add Question</h6></div>
                        <div class="card-body ">
                        <!-- Add Category  !-->
      <form method="POST" action="<?= base_url('administrator/feedback/subject/add');?>">
        <?= csrf_field() ?>
                        <div class="row">
                            <div class="mb-3">
                                <label class="form-label">Question</label>
                                <input type="text" class="form-control" name="title">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description" style="height: 80px;"></textarea>
                            </div>
                            <div class="mb-3">
                                <button type="submit" class="btn btn-outline-danger w-100" >Save</button>
                            </div>
                        </div>
                        </form>
                    </div>
                        <!-- End Add Category  !-->
                        <?php else:?>
                        <div class="card-header"><h6 class="card-title fw-bold">Edit Question</h6></div>
                        <div class="card-body ">
                        <!-- Edit Category  !-->
                            <form method="POST" action="<?= base_url('administrator/feedback/subject/update');?>">
                            <?= csrf_field() ?>
                            <div class="row">
                                <div class="mb-3">
                                    <label class="form-label">Question</label>
                                    <input type="text" class="form-control" name="title" value="<?= $singleSubject['title']; ?>">
                                    <input type="hidden" name="id" value="<?= $singleSubject['id']; ?>" >
                                    <button type="submit" class="btn btn-outline-danger w-100" >Edit</button>
                                </div>
                            </div>
                            </form>
                        <!-- End Edit Category  !-->
                        </div>
                        <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-8 ">
                <!-- Display all categories !-->
                <div class="card">
                <div class="card-header"><h6 class="card-title fw-bold">Pre-Defined Questions</h6></div>
                    <div class="card-body">
                <div class="table-responsive">
                    <table id="catlist" class="table table-hover">
                        <thead class="bg-primary bg-opacity-10" style="font-size: 14px;">
                            <tr>
                            <th>#</th>
                            <th>Subject</th>
                            <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($subjects as $c): ?>
                                <tr>
                                <td><?= $c->id; ?></td>
                                <td>
                                    <strong><?= $c->title; ?></strong><br>
                                    <p><small><?= $c->description; ?></small></p>
                                </td>
                                <td>
                                <div class="btn-group dropstart">
                                <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="bi bi-three-dots-vertical"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><button class="dropdown-item" onclick="editSubject(<?= $c->id; ?>)"><small>Edit</small></button></li>
                                    <li><button class="dropdown-item" onclick="deleteSubject(<?= $c->id; ?>)"><small>Delete</small></button></li>
                                </ul>
                                </div>
                                </td>
                                </tr>
                            <?php endforeach;?>
                        </tbody>
                    </table>
                </div>
            </div></div>

        </div>
    </div>
</div>

    <!-- Subject Answers Tab Content -->
    <div class="tab-pane fade" id="subject-answers" role="tabpanel" aria-labelledby="subject-answers-tab">
        <div class="card card-body mt-3">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4>Subject Answers</h4>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSubjectAnswerModal">
                    <i class="bi bi-plus-circle"></i> Add Subject Answer
                </button>
            </div>
            <div class="table-responsive">
                <table id="subjectanswerslist" class="table table-stripped table-hover">
                    <thead class="bg-primary bg-opacity-10" style="font-size: 14px"><tr>
                        <th>#</th>
                        <th>Subject</th>
                        <th>Answer</th>
                        <th>Status</th>
                        <th></th>
                    </tr></thead>
                    <tbody>
                    <?php foreach($subject_answers as $sa): ?>
                        <tr>
                            <td><?= $sa->id; ?></td>
                            <td><?= $sa->subject_name; ?></td>
                            <td><?= substr($sa->answer, 0, 100); ?>...</td>
                            <td>
                                <?php if($sa->status == 1): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group dropstart">
                                    <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-three-dots-vertical"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><button class="dropdown-item" onclick="editSubjectAnswer(<?= $sa->id; ?>)"><small>Edit</small></button></li>
                                        <li><button class="dropdown-item" onclick="deleteSubjectAnswer(<?= $sa->id; ?>)"><small>Delete</small></button></li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

<!-- Add Subject Answer Modal -->
<div class="modal fade" id="addSubjectAnswerModal" tabindex="-1" aria-labelledby="addSubjectAnswerModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addSubjectAnswerModalLabel">Add Subject Answer</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="<?= base_url('subjectanswers/add'); ?>">
        <?= csrf_field() ?>
        <div class="modal-body">
          <div class="row">
            <div class="col-md-12 mb-3">
              <label class="form-label">Subject</label>
              <select class="form-control" name="subject_id" required>
                <option value="">Select Subject</option>
                <?php foreach($subjects as $subject): ?>
                  <option value="<?= $subject->id; ?>"><?= $subject->title; ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-12 mb-3">
              <label class="form-label">Answer</label>
              <textarea class="form-control" name="answer" rows="4" required></textarea>
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">Status</label>
              <select class="form-control" name="status" required>
                <option value="1">Active</option>
                <option value="0">Inactive</option>
              </select>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Add Subject Answer</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Edit Subject Answer Modal -->
<div class="modal fade" id="editSubjectAnswerModal" tabindex="-1" aria-labelledby="editSubjectAnswerModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editSubjectAnswerModalLabel">Edit Subject Answer</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="<?= base_url('subjectanswers/update'); ?>">
        <div class="modal-body" id="editSubjectAnswerModalBody">
          <!-- Content will be loaded via AJAX -->
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update Subject Answer</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Delete Subject Answer Modal -->
<div class="modal fade" id="deleteSubjectAnswerModal" tabindex="-1" aria-labelledby="deleteSubjectAnswerModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="deleteSubjectAnswerModalLabel">Delete Subject Answer</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        Are you sure you want to delete this subject answer? This action cannot be undone.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-danger" id="confirmDeleteSubjectAnswer">Delete</button>
      </div>
    </div>
  </div>
</div>

<!-- Add Feedback Modal -->
<div class="modal fade" id="addFeedbackModal" tabindex="-1" aria-labelledby="addFeedbackModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addFeedbackModalLabel">Add Customer Feedback</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="<?= base_url('administrator/feedback/add'); ?>">
        <?= csrf_field() ?>
        <div class="modal-body">
          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label">Name</label>
              <input type="text" class="form-control" name="name" required>
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">Email</label>
              <input type="email" class="form-control" name="email" required>
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">Phone</label>
              <input type="text" class="form-control" name="phone">
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">Subject</label>
              <select class="form-control" name="subject_id" required>
                <option value="">Select Subject</option>
                <?php foreach($subjects as $subject): ?>
                  <option value="<?= $subject->id; ?>"><?= $subject->title; ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-6 mb-3">
              <label class="form-label">Account Type</label>
              <select class="form-control" name="account_type">
                <option value="">Select Account Type</option>
                <?php foreach($accountTypes as $type): ?>
                  <option value="<?= $type->id; ?>"><?= $type->title; ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-12 mb-3">
              <label class="form-label">Message</label>
              <textarea class="form-control" name="message" rows="4" required></textarea>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Add Feedback</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Response Modals -->
<?php foreach($feedback as $p): ?>
<!-- Add Response Modal -->
<div class="modal fade" id="responseModal<?= $p->id; ?>" tabindex="-1" aria-labelledby="responseModalLabel<?= $p->id; ?>" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="responseModalLabel<?= $p->id; ?>">Add Response to <?= $p->name; ?>'s Feedback</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="<?= base_url('administrator/feedback/response/add/'.$p->id); ?>">
        <?= csrf_field() ?>
        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Customer Feedback:</label>
            <div class="border p-2 bg-light">
              <strong>Subject:</strong> <?= $p->subject_name; ?><br>
              <strong>Message:</strong> <?= $p->message; ?>
            </div>
          </div>
          <div class="mb-3">
            <label for="response<?= $p->id; ?>" class="form-label">Your Response:</label>
            <textarea class="form-control" id="response<?= $p->id; ?>" name="response" rows="5" required></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Send Response</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- View Response Modal -->
<?php if(!empty($p->response)): ?>
<div class="modal fade" id="viewResponseModal<?= $p->id; ?>" tabindex="-1" aria-labelledby="viewResponseModalLabel<?= $p->id; ?>" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="viewResponseModalLabel<?= $p->id; ?>">Response to <?= $p->name; ?>'s Feedback</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label class="form-label">Original Feedback:</label>
          <div class="border p-2 bg-light">
            <strong>Subject:</strong> <?= $p->subject_name; ?><br>
            <strong>Message:</strong> <?= $p->message; ?>
          </div>
        </div>
        <div class="mb-3">
          <label class="form-label">ABC Response:</label>
          <div class="border p-2">
            <?= $p->response; ?>
          </div>
        </div>
        <div class="mb-3">
          <small class="text-muted">Responded on: <?= date('jS, M Y H:i', strtotime($p->responded_at)); ?></small>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>
<?php endforeach; ?>

<!-- END Customer Feedback Management !-->
<!-- Edit Feedback Modal -->
<div class="modal fade" id="editFeedbackModal" tabindex="-1" aria-labelledby="editFeedbackModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editFeedbackModalLabel">Edit Customer Feedback</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="<?= base_url('administrator/feedback/update'); ?>">
        <div class="modal-body" id="editFeedbackModalBody">
          <!-- Content will be loaded via AJAX -->
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update Feedback</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Delete Feedback Modal -->
<div class="modal fade" id="deleteFeedbackModal" tabindex="-1" aria-labelledby="deleteFeedbackModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="deleteFeedbackModalLabel">Delete Feedback</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        Are you sure you want to delete this feedback? This action cannot be undone.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-danger" id="confirmDeleteFeedback">Delete</button>
      </div>
    </div>
  </div>
</div>

<!-- Edit Subject Modal -->
<div class="modal fade" id="editSubjectModal" tabindex="-1" aria-labelledby="editSubjectModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editSubjectModalLabel">Edit Subject</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="<?= base_url('administrator/feedback/subject/update'); ?>">
        <div class="modal-body" id="editSubjectModalBody">
          <!-- Content will be loaded via AJAX -->
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update Subject</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Delete Subject Modal -->
<div class="modal fade" id="deleteSubjectModal" tabindex="-1" aria-labelledby="deleteSubjectModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="deleteSubjectModalLabel">Delete Subject</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        Are you sure you want to delete this subject? This action cannot be undone.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-danger" id="confirmDeleteSubject">Delete</button>
      </div>
    </div>
  </div>
</div>

<!---- JS ---->
<script type="text/javascript">
    // Helper function to get CSRF token from cookie
    function getCsrfToken() {
        var name = 'csrf_test_name='; // Fixed: use correct token name from Security config
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for(var i = 0; i <ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return '';
    }

    $(document).ready(function () {
        // Initialize Bootstrap tabs
        var triggerTabList = [].slice.call(document.querySelectorAll('#customerCareTabs button'));
        triggerTabList.forEach(function (triggerEl) {
            var tabTrigger = new bootstrap.Tab(triggerEl);
            triggerEl.addEventListener('click', function (event) {
                event.preventDefault();
                tabTrigger.show();
            });
        });

        // Initialize DataTables
        $('#feedbacklist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
        });

        $('#responseslist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
        });

        $('#catlist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
        });

        $('#subjectanswerslist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
        });
    });

    // Edit Subject Answer Function
    function editSubjectAnswer(id) {
        $.ajax({
            url: '<?= base_url('subjectanswers/answer/get/'); ?>' + id,
            type: 'GET',
            success: function(data) {
                $('#editSubjectAnswerModalBody').html(data);
                $('#editSubjectAnswerModal').modal('show');
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
                console.error('Response:', xhr.responseText);
                alert('Error loading subject answer data. Please try again.');
            }
        });
    }

    // Delete Subject Answer Function
    function deleteSubjectAnswer(id) {
        $('#confirmDeleteSubjectAnswer').attr('onclick', 'confirmDeleteSubjectAnswer(' + id + ')');
        $('#deleteSubjectAnswerModal').modal('show');
    }

    function confirmDeleteSubjectAnswer(id) {
        window.location.href = '<?= base_url('subjectanswers/delete/'); ?>' + id;
    }

    // Edit Feedback Function
  function editFeedback(id) {
    $.ajax({
      // route is defined under `subjectanswers` group in module routes
      url: '<?= base_url('subjectanswers/get/'); ?>' + id,
      type: 'GET',
      success: function(data) {
        $('#editFeedbackModalBody').html(data);
        $('#editFeedbackModal').modal('show');
      },
      error: function(xhr, status, error) {
        console.error('AJAX Error:', error);
        console.error('Response:', xhr.responseText);
        alert('Error loading feedback data. Please try again.');
      }
    });
  }

    // Delete Feedback Function
    function deleteFeedback(id) {
        $('#confirmDeleteFeedback').attr('onclick', 'confirmDeleteFeedback(' + id + ')');
        $('#deleteFeedbackModal').modal('show');
    }

    function confirmDeleteFeedback(id) {
        window.location.href = '<?= base_url('administrator/feedback/delete/'); ?>' + id;
    }

    // Edit Subject Function
  function editSubject(id) {
    $.ajax({
      // route is defined under `subjectanswers` group in module routes
      url: '<?= base_url('subjectanswers/subject/get/'); ?>' + id,
      type: 'GET',
      success: function(data) {
        $('#editSubjectModalBody').html(data);
        $('#editSubjectModal').modal('show');
      },
      error: function(xhr, status, error) {
        console.error('AJAX Error:', error);
        console.error('Response:', xhr.responseText);
        alert('Error loading subject data. Please try again.');
      }
    });
  }

    // Delete Subject Function
    function deleteSubject(id) {
        $('#confirmDeleteSubject').attr('onclick', 'confirmDeleteSubject(' + id + ')');
        $('#deleteSubjectModal').modal('show');
    }

    function confirmDeleteSubject(id) {
        window.location.href = '<?= base_url('administrator/feedback/subject/delete/'); ?>' + id;
    }
</script>
<?= $this->endSection();?>
