<?php

namespace Modules\CustomerCare\Models;

use CodeIgniter\Model;

class SubjectAnswersModel extends Model
{
    protected $table = 'subject_answers';
    protected $primaryKey = 'id';

    protected $allowedFields = ['subject_id', 'answer', 'status'];

    protected $returnType     = 'object';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    public function getAll()
    {
        return $this->findAll();
    }

    public function getAllWithSubjects()
    {
        $builder = $this->db->table('subject_answers');
        $builder->select('subject_answers.*, feedback_subject.title as subject_name');
        $builder->join('feedback_subject', 'feedback_subject.id = subject_answers.subject_id');
        $builder->where('subject_answers.deleted_at IS NULL');
        $builder->orderBy('subject_answers.id', 'DESC');
        $result = $builder->get()->getResult();
        return $result;
    }

    public function getById($id)
    {
        return $this->find($id);
    }
}
