<?= $this->extend('Modules\Admin\Views\index') ?>

<?php $validation = \Config\Services::validation(); ?>

<?= $this->section('content') ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
    .image-popup-overlay { 
        position: fixed; 
        top: 0; 
        left: 0; 
        width: 100%; 
        height: 100%; 
        background-color: rgba(0,0,0,0.8); 
        display:flex; 
        align-items:center; 
        justify-content:center; 
        z-index:9999; 
    }
    .image-popup { 
        max-width:90%; 
        max-height:90%; 
    }
    .banner-thumbnail { 
        width:150px; 
        height:150px; 
        object-fit:cover; 
        cursor:pointer; 
    }
    .preview-thumbnail { 
        width:50px; 
        height:50px; 
        object-fit:cover; 
        cursor:pointer; 
    }
    .link-search-results {
        position: absolute;
        z-index: 1000;
        background: white;
        border: 1px solid #ccc;
        max-height: 200px;
        overflow-y: auto;
        width: 100%;
        display: none;
    }
    .link-search-item {
        padding: 8px 12px;
        cursor: pointer;
        border-bottom: 1px solid #eee;
    }
    .link-search-item:hover {
        background-color: #f8f9fa;
    }
</style>

<div class="container-fluid">
    <div class="row mb-md-3">
        <div class="col">
            <h4>Banners Management</h4>
        </div>
    </div>

    <?php if (session()->getFlashdata('success')) : ?>
        <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')) : ?>
        <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
    <?php endif; ?>
    <?php if (isset($validation) && $validation->getErrors()) : ?>
        <div class="alert alert-danger">
            <ul>
                <?php foreach ($validation->getErrors() as $error) : ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title fw-bold"><?= isset($banner) ? 'Edit Banner' : 'Add Banner' ?></h6>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?= isset($banner) ? base_url('administrator/banners/update/' . $banner['id']) : base_url('administrator/banners/create') ?>" enctype="multipart/form-data">
                        <?= csrf_field() ?>

                        <div class="mb-3">
                            <label class="form-label">Name *</label>
                            <input type="text" class="form-control" name="name" value="<?= isset($banner) ? esc($banner['name']) : old('name') ?>" minlength="3" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Link URL *</label>
                            <input type="text" class="form-control" id="link" name="url" value="<?= isset($banner) ? esc($banner['url']) : old('url') ?>" autocomplete="off" required>
                            <div id="linkSearchResults" class="link-search-results"></div>
                            <input type="hidden" name="selected_link_id" id="selected_link_id" value="<?= isset($selected_link_meta) ? esc($selected_link_meta['id']) : '' ?>">
                            <input type="hidden" name="selected_link_type" id="selected_link_type" value="<?= isset($selected_link_meta) ? esc($selected_link_meta['type']) : '' ?>">
                            <small class="text-muted">Start typing to search available pages/posts</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Title</label>
                            <input type="text" class="form-control" id="title" name="title" value="<?= isset($banner) ? esc($banner['title']) : old('title') ?>">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" style="height:80px;"><?= isset($banner) ? esc($banner['description']) : old('description') ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Link Text</label>
                            <input type="text" class="form-control" id="link_text" name="link_text" value="<?= isset($banner) ? esc($banner['link_text']) : old('link_text') ?>">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Photo</label>
                            <input type="file" class="form-control" name="photo" accept="image/*">
                            <?php if (isset($banner) && $banner['photo']) : ?>
                                <div class="mt-2">
                                    <img src="<?= base_url('media/files/' . $banner['photo']) ?>" class="preview-thumbnail" onclick="showImagePopup(this)" alt="Current banner">
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-control" name="status">
                                <option value="1" <?= (isset($banner) && $banner['status'] == '1') ? 'selected' : '' ?>>Active</option>
                                <option value="0" <?= (isset($banner) && $banner['status'] == '0') ? 'selected' : '' ?>>Inactive</option>
                            </select>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary"><?= isset($banner) ? 'Update Banner' : 'Save Banner' ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title fw-bold">All Banners</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="banners-table" class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Image</th>
                                    <th>Details</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($banners as $b) : ?>
                                    <tr>
                                        <td><?= $b['id'] ?></td>
                                        <td>
                                            <?php if ($b['photo']) : ?>
                                                <img src="<?= base_url('media/files/' . $b['photo']) ?>" class="banner-thumbnail" onclick="showImagePopup(this)" alt="<?= esc($b['name']) ?>">
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <strong><?= esc($b['name']) ?></strong>
                                            <?php if ($b['title']) : ?>
                                                <br><small><?= esc($b['title']) ?></small>
                                            <?php endif; ?>
                                            <?php if ($b['url']) : ?>
                                                <br><small class="text-primary"><?= esc($b['url']) ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge <?= $b['status'] == '1' ? 'bg-success' : 'bg-danger' ?>">
                                                <?= $b['status'] == '1' ? 'Active' : 'Inactive' ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?= base_url('administrator/banners/edit/' . $b['id']) ?>" class="btn btn-sm btn-info" title="Edit">
                                                    <i class="bi bi-pencil-square"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger delete-banner" data-id="<?= $b['id'] ?>" title="Delete">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Banner</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this banner?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="" method="POST" id="deleteForm">
                    <?= csrf_field() ?>
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
// Store initial metadata for prefill
window.initialSelectedLinkMeta = <?= json_encode($selected_link_meta ?? null) ?>;

function showImagePopup(img) {
    const overlay = document.createElement('div');
    overlay.classList.add('image-popup-overlay');
    const image = document.createElement('img');
    image.src = img.src;
    image.classList.add('image-popup');
    overlay.appendChild(image);
    document.body.appendChild(overlay);
    overlay.onclick = function() {
        document.body.removeChild(overlay);
    };
}

document.addEventListener('DOMContentLoaded', function() {
    // Initialize DataTable
    $('#banners-table').DataTable({
        pageLength: 10,
        order: [[0, 'desc']],
        responsive: true
    });

    // Link autocomplete functionality
    const linkInput = document.getElementById('link');
    const resultsContainer = document.getElementById('linkSearchResults');
    const selectedLinkId = document.getElementById('selected_link_id');
    const selectedLinkType = document.getElementById('selected_link_type');
    const titleInput = document.getElementById('title');
    const descriptionInput = document.getElementById('description');
    const linkTextInput = document.getElementById('link_text');

    let searchTimeout;

    linkInput.addEventListener('input', function() {
        clearTimeout(searchTimeout);
        const query = this.value.trim();
        
        if (query.length < 2) {
            resultsContainer.style.display = 'none';
            return;
        }

        searchTimeout = setTimeout(() => {
            fetch(`<?= base_url('administrator/posts/searchLinks') ?>?q=${encodeURIComponent(query)}`)
                .then(response => response.json())
                .then(data => {
                    resultsContainer.innerHTML = '';
                    if (data.length > 0) {
                        data.forEach(item => {
                            const div = document.createElement('div');
                            div.className = 'link-search-item';
                            div.innerHTML = `
                                <strong>${item.title}</strong><br>
                                <small>${item.menu_link || item.slug || item.alias}</small>
                            `;
                            div.addEventListener('click', () => {
                                selectLinkItem(item);
                            });
                            resultsContainer.appendChild(div);
                        });
                        resultsContainer.style.display = 'block';
                    } else {
                        resultsContainer.style.display = 'none';
                    }
                })
                .catch(error => {
                    console.error('Search error:', error);
                    resultsContainer.style.display = 'none';
                });
        }, 300);
    });

    function selectLinkItem(item) {
        // Set the canonical link (menu_link > slug > alias)
        const canonicalLink = item.menu_link || item.slug || item.alias;
        linkInput.value = canonicalLink;
        
        // Store selection metadata
        selectedLinkId.value = item.id;
        selectedLinkType.value = item.type;
        
        // Populate other fields if they exist and are empty
        if (item.title && !titleInput.value) {
            titleInput.value = item.title;
            titleInput.readOnly = true;
        }
        
        if (item.excerpt && !descriptionInput.value) {
            descriptionInput.value = item.excerpt;
            descriptionInput.readOnly = true;
        }
        
        if (!linkTextInput.value) {
            linkTextInput.value = item.title || 'Learn More';
            linkTextInput.readOnly = true;
        }

        // Hide results
        resultsContainer.style.display = 'none';
    }

    // Clear selection if user empties the link input
    linkInput.addEventListener('change', function() {
        if (!this.value.trim()) {
            selectedLinkId.value = '';
            selectedLinkType.value = '';
            // Make fields editable again
            titleInput.readOnly = false;
            descriptionInput.readOnly = false;
            linkTextInput.readOnly = false;
        }
    });

    // Hide results when clicking outside
    document.addEventListener('click', function(e) {
        if (!linkInput.contains(e.target) && !resultsContainer.contains(e.target)) {
            resultsContainer.style.display = 'none';
        }
    });

    // Prefill form if editing with existing link metadata
    if (window.initialSelectedLinkMeta) {
        const meta = window.initialSelectedLinkMeta;
        selectLinkItem(meta);
    }

    // Handle delete button clicks
    document.querySelectorAll('.delete-banner').forEach(button => {
        button.addEventListener('click', function() {
            const id = this.dataset.id;
            const deleteForm = document.getElementById('deleteForm');
            deleteForm.action = `<?= base_url('administrator/banners/delete/') ?>${id}`;
            new bootstrap.Modal(document.getElementById('deleteModal')).show();
        });
    });
});
</script>
<?= $this->endSection() ?>