<?= $this->extend('Modules\Admin\Views\index') ?>

<?= $this->section('content') ?>
<?php $validation = \Config\Services::validation(); ?>

<!-- DataTables CSS -->
<link rel="stylesheet" type="text/css" href="<?= base_url('assets/admin_assets/vendor/DataTables/datatables.min.css') ?>"/>


<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
    .image-popup-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.8); display:flex; align-items:center; justify-content:center; z-index:9999; }
    .image-popup { max-width:90%; max-height:90%; }
    .banner-thumbnail { width:150px; height:150px; object-fit:cover; cursor:pointer; }
    .preview-thumbnail { width:50px; height:50px; object-fit:cover; cursor:pointer; }
    #bannerImgPreview .img-thumbnail { height: 120px; }
</style>

<div class="container-fluid">
    <div class="row mb-md-3">
        <div class="col">
            <h4>Banners Management</h4>
        </div>
    </div>

    <?php if (session()->getFlashdata('success')) : ?>
        <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')) : ?>
        <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
    <?php endif; ?>
    <?php if (isset($validation) && $validation->getErrors()) : ?>
        <div class="alert alert-danger"><ul><?php foreach ($validation->getErrors() as $error) : ?><li><?= esc($error) ?></li><?php endforeach ?></ul></div>
    <?php endif; ?>

    <div class="row">
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header"><h6 class="card-title fw-bold"><?= isset($banner) ? 'Edit Banner' : 'Add Banner' ?></h6></div>
                <div class="card-body">
                    <form method="POST" action="<?= isset($banner) ? base_url('administrator/banners/update/' . $banner['id']) : base_url('administrator/banners/create') ?>" enctype="multipart/form-data" id="banner-form">
                        <?= csrf_field() ?>

                        <div class="mb-3">
                            <label class="form-label">Name *</label>
                            <input type="text" class="form-control" name="name" value="<?= isset($banner) ? esc($banner['name']) : old('name') ?>" minlength="3" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Title Emphasis</label>
                            <input type="text" class="form-control" name="title_emphasized" value="<?= isset($banner) ? esc($banner['title_emphasized']) : old('title_emphasized') ?>">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Banner Image *</label>
                            <div id="bannerImgPreview" class="mb-2" style="min-height: 120px; border: 1px dashed #ccc; padding: 5px;">
                                <?php if (isset($banner) && !empty($banner['photo'])):
                                    echo '<img src="'.base_url('media/files/' . $banner['photo']).'" class="img-thumbnail thumb">';
                                endif; ?>
                            </div>
                            <div class="d-flex">
                                <input type="file" class="form-control form-control-sm" name="photo" accept="image/*" <?= !isset($banner) ? 'required' : '' ?>>
                                <button type="button" id="clearImageBtn" class="btn btn-sm btn-outline-danger ms-2" style="display: <?= (isset($banner) && !empty($banner['photo'])) ? 'block' : 'none' ?>;"><i class="bi bi-trash"></i></button>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Link URL *</label>
                            <select class="form-control url-select" name="url" required>
                                <?php if (isset($banner) && $banner['url']) : ?>
                                    <option value="<?= esc($banner['url']) ?>" selected><?= esc($banner['url']) ?></option>
                                <?php endif; ?>
                            </select>
                            <input type="hidden" name="selected_link_id" id="selected_link_id" value="<?= isset($selected_link_meta) ? esc($selected_link_meta['id']) : '' ?>">
                            <small class="text-muted">Select from available pages or enter a custom URL</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" style="height:80px;"><?= isset($banner) ? esc($banner['description']) : old('description') ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Navigation Context</label>
                            <select class="form-control nav-context-select" name="nav_context">
                                <?php if (isset($banner) && $banner['nav_context']) : ?><option value="<?= esc($banner['nav_context']) ?>" selected><?= ucfirst(esc($banner['nav_context'])) ?></option><?php endif; ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Banner Type</label>
                            <select class="form-control" name="banner_type" required>
                                <option value="hero" <?= (isset($banner) && $banner['banner_type'] == 'hero') ? 'selected' : '' ?>>Hero</option>
                                <option value="slider" <?= (isset($banner) && $banner['banner_type'] == 'slider') ? 'selected' : '' ?>>Slider</option>
                                <option value="promotional" <?= (isset($banner) && $banner['banner_type'] == 'promotional') ? 'selected' : '' ?>>Promotional</option>
                                <option value="featured" <?= (isset($banner) && $banner['banner_type'] == 'featured') ? 'selected' : '' ?>>Featured</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Service Group</label>
                            <select class="form-control service-group-select" name="service_group_id">
                                <?php if (isset($banner) && $banner['service_group_id']) : ?><option value="<?= esc($banner['service_group_id']) ?>" selected><?= esc($banner['service_group_name'] ?? $banner['service_group_id']) ?></option><?php endif; ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-control" name="status" required>
                                <option value="1" <?= (isset($banner) && $banner['status'] == '1') ? 'selected' : '' ?>>Active</option>
                                <option value="0" <?= (isset($banner) && $banner['status'] == '0') ? 'selected' : '' ?>>Inactive</option>
                            </select>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary"><?= isset($banner) ? 'Update Banner' : 'Save Banner' ?></button>
                            <a href="<?= base_url('administrator/banners') ?>" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card">
                <div class="card-header"><h6 class="card-title fw-bold">All Banners</h6></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="banners-table" class="table table-hover">
                            <thead class="bg-light">
                                <tr><th>ID</th><th>Image</th><th>Details</th><th>Type</th><th>Status</th><th>Actions</th></tr>
                            </thead>
                            <tbody>
                                <?php foreach ($banners as $b) : ?>
                                    <tr>
                                        <td><?= $b['id'] ?></td>
                                        <td><?php if ($b['photo']) : ?><img src="<?= base_url('media/files/' . $b['photo']) ?>" class="banner-thumbnail" onclick="showImagePopup(this)" alt="<?= esc($b['name']) ?>"><?php endif; ?></td>
                                        <td><strong><?= esc($b['name']) ?></strong>
                                            <?php if ($b['title_emphasized']) : ?><br><small class="text-muted">Emphasis: <?= esc($b['title_emphasized']) ?></small><?php endif; ?>
                                            <?php if ($b['description']) : ?><br><small class="text-muted"><?= esc($b['description']) ?></small><?php endif; ?>
                                            <?php if ($b['url']) : ?><br><small class="text-primary"><?= esc($b['url']) ?></small><?php endif; ?></td>
                                        <td><?= ucfirst($b['banner_type']) ?><br><small class="text-muted"><?= ucfirst($b['nav_context']) ?></small></td>
                                        <td><span class="badge <?= $b['status'] == '1' ? 'bg-success' : 'bg-danger' ?>"><?= $b['status'] == '1' ? 'Active' : 'Inactive' ?></span></td>
                                        <td><div class="btn-group" role="group"><a href="<?= base_url('administrator/banners/edit/' . $b['id']) ?>" class="btn btn-sm btn-info" title="Edit"><i class="bi bi-pencil-square"></i></a>
                                                    <button type="button" class="btn btn-sm btn-danger delete-banner" data-id="<?= $b['id'] ?>" title="Delete"><i class="bi bi-trash"></i></button></div></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Banner</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">Are you sure you want to delete this banner?</div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="" method="POST" id="deleteForm">
                    <?= csrf_field() ?>
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<!-- DataTables JS -->
<script type="text/javascript" src="<?= base_url('assets/admin_assets/vendor/DataTables/datatables.min.js') ?>"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
window.initialSelectedLinkMeta = <?= json_encode($selected_link_meta ?? null) ?>;

function showImagePopup(img) {
    const overlay = document.createElement('div'); overlay.classList.add('image-popup-overlay');
    const image = document.createElement('img'); image.src = img.src; image.classList.add('image-popup'); overlay.appendChild(image); document.body.appendChild(overlay);
    overlay.onclick = function() { document.body.removeChild(overlay); };
}

document.addEventListener('DOMContentLoaded', function() {
    // Initialize DataTable with search and responsive features
    const table = $('#banners-table').DataTable({
        "processing": true,
        "pageLength": 10,
        "order": [[0, "desc"]],
        "responsive": true,
        "search": {
            "smart": true,
            "delay": 300 // 300ms debounce delay
        },
        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
        "language": {
            "search": "Search:",
            "lengthMenu": "Show _MENU_ entries",
            "info": "Showing _START_ to _END_ of _TOTAL_ entries",
            "infoEmpty": "Showing 0 to 0 of 0 entries",
            "infoFiltered": "(filtered from _MAX_ total entries)",
            "emptyTable": "No data available"
        },
        "dom": "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
               "<'row'<'col-sm-12'tr>>" +
               "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>"
    });

    // Clear search when clicking clear button
    $('#clearSearch').on('click', function() {
        table.search('').draw();
    });

    var pageUrls = <?= json_encode($pageUrls ?? []) ?>;
    var pageUrlData = pageUrls.map(function(item) { return { id: item.url, text: (item.title || item.url) + ' (' + item.url + ')', meta: item }; });
    $('.url-select').select2({ placeholder: 'Select a page or enter URL', tags:true, allowClear:true, data: pageUrlData });

    function applyUrlMeta(meta, isManual) {
        if (!meta || isManual) {
            $('.nav-context-select').prop('disabled', false);
            $('.service-group-select').prop('disabled', false);
            return;
        }

        if (meta.nav_context) {
            var ncOption = new Option(meta.nav_context, meta.nav_context, true, true);
            $('.nav-context-select').append(ncOption).trigger('change').prop('disabled', true);
        }
        if (meta.service_group_id) {
            var sgText = meta.service_group_name || meta.service_group_id;
            var sgOption = new Option(sgText, meta.service_group_id, true, true);
            $('.service-group-select').append(sgOption).trigger('change').prop('disabled', true);
        }
        if (meta.template_group) {
            var tg = document.querySelector('[name="template_group"]');
            if (tg) tg.value = meta.template_group;
        }
    }

    $('.url-select').on('select2:select', function(e){
        var sel = e.params.data;
        if (sel && sel.meta) {
            applyUrlMeta(sel.meta, false);
            if (sel.meta.id) document.getElementById('selected_link_id').value = sel.meta.id;
            else document.getElementById('selected_link_id').value = '';
        } else if (sel && sel.id) {
            var found = pageUrls.find(function(p){ return p.url === sel.id; });
            if (found) {
                applyUrlMeta(found, false);
                if (found.id) document.getElementById('selected_link_id').value = found.id;
                else document.getElementById('selected_link_id').value = '';
            }
        }
    });

    $('.url-select').on('select2:unselect', function(e){
        applyUrlMeta(null, true);
    });

    (function prefillExistingUrl(){
        var select = document.querySelector('.url-select');
        if (!select) return;
        if (window.initialSelectedLinkMeta) {
            var meta = window.initialSelectedLinkMeta;
            var urlVal = meta.menu_link || meta.slug || meta.alias || '';
            if (urlVal) {
                if (!select.querySelector('option[value="'+urlVal+'"]')) {
                    var opt = new Option(urlVal, urlVal, true, true);
                    select.appendChild(opt);
                }
                $(select).val(urlVal).trigger('change');
                applyUrlMeta(meta, false);
                var hid = document.getElementById('selected_link_id');
                if(hid) hid.value = meta.id || '';
                return;
            }
        }
        var selectedVal = select.value || (select.querySelector('option[selected]') && select.querySelector('option[selected]').value);
        if (selectedVal) {
            if (!select.querySelector('option[value="'+selectedVal+'"]')) {
                var opt = new Option(selectedVal, selectedVal, true, true);
                select.appendChild(opt);
            }
            $(select).trigger('change');
            var found = pageUrls.find(function(p){ return p.url === selectedVal; });
            if (found) applyUrlMeta(found, false);
        }
    })();

    $('.nav-context-select').select2({ placeholder:'Select navigation context', allowClear:true, ajax: { url:'<?= base_url('administrator/posts/context-manager/nav-contexts') ?>', dataType:'json', delay:250, processResults:function(data){ return { results: data.map(function(item){ return { id: item.slug, text: item.name }; }) }; }, cache:true } });

    $('.service-group-select').select2({ placeholder:'Select service group', allowClear:true, ajax:{ url:'<?= base_url('administrator/posts/context-manager/nav-context-groups') ?>/', dataType:'json', delay:250, data:function(params){ return { search: params.term, nav_context: $('.nav-context-select').val() }; }, processResults:function(data){ return { results: data.map(function(item){ return { id: item.id, text: item.name }; }) }; }, cache:true } });

    $('.nav-context-select').on('change', function(){ $('.service-group-select').val(null).trigger('change'); });

    document.querySelectorAll('.delete-banner').forEach(button=>{ button.addEventListener('click', function(){ const id = this.dataset.id; const deleteForm = document.getElementById('deleteForm'); deleteForm.action = `<?= base_url('administrator/banners/delete/') ?>/${id}`; new bootstrap.Modal(document.getElementById('deleteModal')).show(); }); });

    // Image preview
    const bannerPhotoInput = document.querySelector('input[name="photo"]');
    const bannerImgPreview = document.getElementById('bannerImgPreview');
    const clearImageBtn = document.getElementById('clearImageBtn');

    bannerPhotoInput.addEventListener('change', function() {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            bannerImgPreview.innerHTML = '';
            reader.onload = function(e) {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.className = 'img-thumbnail thumb';
                bannerImgPreview.appendChild(img);
                clearImageBtn.style.display = 'block';
            }
            reader.readAsDataURL(file);
        } else {
            bannerImgPreview.innerHTML = '';
            clearImageBtn.style.display = 'none';
        }
    });

    clearImageBtn.addEventListener('click', function() {
        bannerPhotoInput.value = '';
        bannerImgPreview.innerHTML = '';
        this.style.display = 'none';
    });

    document.querySelector('a.btn-secondary').addEventListener('click', function(e){
        e.preventDefault();
        document.getElementById('banner-form').reset();
        bannerImgPreview.innerHTML = '';
        clearImageBtn.style.display = 'none';
        $('.url-select').val(null).trigger('change');
        $('.nav-context-select').val(null).trigger('change').prop('disabled', false);
        $('.service-group-select').val(null).trigger('change').prop('disabled', false);
        window.location.href = '<?= base_url('administrator/banners') ?>';
    });
});
</script>

<?= $this->endSection() ?>
