<div class="container-fluid">
    <div class="row mb-md-3">
        <div class="col">
            <h4>Banner Management</h4>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Banners</li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Messages -->
    <?php if (session()->getFlashdata('success')) : ?>
        <div class="alert alert-success">
            <?= session()->getFlashdata('success') ?>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')) : ?>
        <div class="alert alert-danger">
            <?= session()->getFlashdata('error') ?>
        </div>
    <?php endif; ?>

    <div class="row">
        <!-- Hero Banners Card -->
        <?php if(has_permission('banner.view.hero')): ?>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-stars me-2"></i>Hero Banners
                    </h5>
                    <p class="card-text">Manage hero banners for main page sections.</p>
                    <div class="mt-3">
                        <a href="<?= base_url('administrator/banners/list?type=hero') ?>" class="btn btn-primary">
                            View Hero Banners
                        </a>
                        <?php if(has_permission('banner.create')): ?>
                        <a href="<?= base_url('administrator/banners/new?type=hero') ?>" class="btn btn-outline-primary">
                            Add New
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Promotional Banners Card -->
        <?php if(has_permission('banner.view.promotional')): ?>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-megaphone me-2"></i>Promotional Banners
                    </h5>
                    <p class="card-text">Manage promotional banners for marketing campaigns.</p>
                    <div class="mt-3">
                        <a href="<?= base_url('administrator/banners/list?type=promotional') ?>" class="btn btn-primary">
                            View Promotional
                        </a>
                        <?php if(has_permission('banner.create')): ?>
                        <a href="<?= base_url('administrator/banners/new?type=promotional') ?>" class="btn btn-outline-primary">
                            Add New
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Featured Banners Card -->
        <?php if(has_permission('banner.view.featured')): ?>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-award me-2"></i>Featured Banners
                    </h5>
                    <p class="card-text">Manage featured content and special announcements.</p>
                    <div class="mt-3">
                        <a href="<?= base_url('administrator/banners/list?type=featured') ?>" class="btn btn-primary">
                            View Featured
                        </a>
                        <?php if(has_permission('banner.create')): ?>
                        <a href="<?= base_url('administrator/banners/new?type=featured') ?>" class="btn btn-outline-primary">
                            Add New
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Slider Banners Card -->
        <?php if(has_permission('banner.view.slider')): ?>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-images me-2"></i>Slider Banners
                    </h5>
                    <p class="card-text">Manage dynamic slider banners for rotating content.</p>
                    <div class="mt-3">
                        <a href="<?= base_url('administrator/banners/list?type=slider') ?>" class="btn btn-primary">
                            View Sliders
                        </a>
                        <?php if(has_permission('banner.create')): ?>
                        <a href="<?= base_url('administrator/banners/new?type=slider') ?>" class="btn btn-outline-primary">
                            Add New
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <?php if(has_permission('banner.settings.view')): ?>
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-gear me-2"></i>Banner Settings
                    </h5>
                    <p class="card-text">Configure global banner settings, navigation contexts, and service groups.</p>
                    <div class="mt-3">
                        <a href="<?= base_url('administrator/banners/settings') ?>" class="btn btn-secondary">
                            Manage Settings
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>