<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<?php helper('security'); ?>
<div class="pagetitle">
      <h1>Edit User</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?= base_url('administrator'); ?>">Home</a></li>
          <li class="breadcrumb-item"><a href="<?= base_url('administrator/users'); ?>">Users</a></li>
          <li class="breadcrumb-item active">Edit User</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <!-- Alerts here !-->
    <?php if(session()->getTempdata('error')):?>
    <div class="alert alert-danger">  <?= session()->getTempdata('error');?></div>
    <?php endif;?>
      <?php if(session()->getTempdata('success')):?>
      <div class="alert alert-success">  <?= session()->getTempdata('success');?></div>
      <?php endif;?>
			<?php if(session()->getTempdata('warning')):?>
      <div class="alert alert-warning">  <?= session()->getTempdata('warning');?></div>
      <?php endif;?>
    </div>
    <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
    <?php endif;?>

    <!-- End of Alerts !-->

    <section class="section profile">
      <div class="row">
        <div class="col-xl-4">

          <div class="card">
            <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">
              <?php if(!empty($user->photo)): ?>
                <img src="<?= base_url('/media/files/').'/'.$user->photo;?>" alt="<?= $user->first_name; ?>" class="rounded-circle mb-3" width="120px" height="120px">
              <?php else: ?>
                <img src="<?= base_url();?>/assets/admin_assets/images/profiler.jpeg" alt="" class="rounded-circle mb-3" width="120px" height="120px">
              <?php endif; ?>
              <h5><?= $user->first_name; ?> <?= $user->last_name; ?></h5>
              <div class="social-links mt-2">
                <a href="<?= $user->twitter; ?>" class="twitter"><i class="bi bi-twitter"></i></a>
                <a href="<?= $user->facebook; ?>" class="facebook"><i class="bi bi-facebook"></i></a>
                <a href="<?= $user->instagram; ?>" class="instagram"><i class="bi bi-instagram"></i></a>
                <a href="<?= $user->linkedin; ?>" class="linkedin"><i class="bi bi-linkedin"></i></a>
              </div>
            </div>
          </div>

        </div>

        <div class="col-xl-8">

          <div class="card">
            <div class="card-body pt-3">
              <!-- Bordered Tabs -->
              <ul class="nav nav-tabs nav-tabs-bordered">

                <li class="nav-item">
                  <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#profile-edit">Edit User Details</button>
                </li>

              </ul>
              <div class="tab-content pt-2">

                <div class="tab-pane fade show active profile-edit pt-3" id="profile-edit">

                  <!-- Profile Edit Form -->
                  <form method="post" action="<?= base_url('administrator/users/edit/' . $user->id);?>"  enctype="multipart/form-data">
                    <?= csrf_field(); ?>
                    <div class="row mb-3">
                      <label for="profileImage" class="col-md-4 col-lg-3 col-form-label">Profile Image</label>
                      <div class="col-md-8 col-lg-9">
                        <?php if(!empty($user->photo)): ?>
                          <img src="<?= base_url('/media/files/').'/'.$user->photo;?>" alt="<?= $user->first_name; ?>" class="rounded-circle mb-2" width="100px" height="100px">
                        <?php else: ?>
                          <img src="<?= base_url();?>/assets/admin_assets/images/profiler.jpeg" alt="" class="rounded-circle mb-2" width="100px" height="100px">
                        <?php endif; ?>
                        <div class="pt-2">
                          <input type="file" name="photo" class="form-control" accept="image/jpeg, image/png, image/gif"/>
                          <small class="text-muted">Upload a new profile image (JPEG, PNG, GIF)</small>
                        </div>
                      </div>
                    </div>

                    <!-- Full Name Section -->
                    <div class="row mb-3">
                      <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Full Name <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <div class="row">
                          <div class="col">
                            <input name="first_name" type="text" class="form-control <?= (isset($validation) && $validation->hasError('first_name')) ? 'is-invalid' : '' ?>" 
                                   id="firstName" placeholder="Enter first name" value="<?= old('first_name', $user->first_name) ?>" required>
                            <?php if (isset($validation) && $validation->hasError('first_name')): ?>
                              <div class="invalid-feedback">
                                <?= $validation->getError('first_name') ?>
                              </div>
                            <?php endif; ?>
                          </div>
                          <div class="col">
                            <input name="last_name" type="text" class="form-control <?= (isset($validation) && $validation->hasError('last_name')) ? 'is-invalid' : '' ?>" 
                                   id="lastName" placeholder="Enter last name" value="<?= old('last_name', $user->last_name) ?>" required>
                            <?php if (isset($validation) && $validation->hasError('last_name')): ?>
                              <div class="invalid-feedback">
                                <?= $validation->getError('last_name') ?>
                              </div>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    </div>

                    <!-- Phone -->
                    <div class="row mb-3">
                      <label for="Phone" class="col-md-4 col-lg-3 col-form-label">Phone</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="mobile" type="text" class="form-control" id="Phone" placeholder="Enter phone number" value="<?= old('mobile', $user->mobile) ?>">
                      </div>
                    </div>

                    <!-- Email -->
                    <div class="row mb-3">
                      <label for="Email" class="col-md-4 col-lg-3 col-form-label">Email <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <input name="email" type="email" class="form-control <?= (isset($validation) && $validation->hasError('email')) ? 'is-invalid' : '' ?>" 
                              id="Email" placeholder="Enter email address" value="<?= old('email', $user->email) ?>" required>
                        <?php if (isset($validation) && $validation->hasError('email')): ?>
                          <div class="invalid-feedback">
                            <?= $validation->getError('email') ?>
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>

                    <!-- Position -->
                    <div class="row mb-3">
                      <label for="Position" class="col-md-4 col-lg-3 col-form-label">Position</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="position" type="text" class="form-control" id="Position" placeholder="Enter job position" value="<?= old('position', $user->position) ?>">
                      </div>
                    </div>

                    <!-- Department -->
                    <div class="row mb-3">
                      <label for="Department" class="col-md-4 col-lg-3 col-form-label">Department</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="department_id" class="form-select" id="department_id">
                          <option value="">Select Department</option>
                          <?php foreach($departments ?? [] as $department): ?>
                            <option value="<?= $department->id; ?>" <?= (old('department_id', $user->department_id) == $department->id) ? 'selected' : '' ?>>
                              <?= $department->name; ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                    </div>
   <!-- Admin Role -->
                    <div class="row mb-3">
                      <label for="Group" class="col-md-4 col-lg-3 col-form-label">Admin Role <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <select name="group_id" class="form-select <?= (isset($validation) && $validation->hasError('group_id')) ? 'is-invalid' : '' ?>" id="group_id" required>
                          <option value="">Select Role</option>
                          <?php foreach($user_roles ?? [] as $role): ?>
                            <option value="<?= $role->id; ?>" <?= (old('group_id', $user->group_id) == $role->id) ? 'selected' : '' ?>>
                              <?= $role->name; ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                        <?php if (isset($validation) && $validation->hasError('group_id')): ?>
                          <div class="invalid-feedback">
                            <?= $validation->getError('group_id') ?>
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>
                    <!-- Country -->
                    <div class="row mb-3">
                      <label for="Country" class="col-md-4 col-lg-3 col-form-label">Country</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="country_id" class="form-select" id="country_id">
                          <option value="">Select Country</option>
                          <?php foreach($countries ?? [] as $country): ?>
                            <option value="<?= $country['country_id']; ?>" <?= (old('country_id', $user->country_id) == $country['country_id']) ? 'selected' : '' ?>>
                              <?= $country['country_name']; ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                    </div>

                    <!-- Address -->
                    <div class="row mb-3">
                      <label for="Address" class="col-md-4 col-lg-3 col-form-label">Address</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="address" type="text" class="form-control" id="Address" placeholder="Enter street address" value="<?= old('address', $user->address) ?>">
                      </div>
                    </div>

                    <!-- Social Media Profiles -->
                    <div class="row mb-3">
                      <label for="twitter" class="col-md-4 col-lg-3 col-form-label">Twitter Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="twitter" type="text" class="form-control" id="twitter" placeholder="Enter Twitter username or profile URL" value="<?= old('twitter', $user->twitter) ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Facebook" class="col-md-4 col-lg-3 col-form-label">Facebook Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="facebook" type="text" class="form-control" id="Facebook" placeholder="Enter Facebook profile URL" value="<?= old('facebook', $user->facebook) ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Instagram" class="col-md-4 col-lg-3 col-form-label">Instagram Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="instagram" type="text" class="form-control" id="Instagram" placeholder="Enter Instagram username" value="<?= old('instagram', $user->instagram) ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Linkedin" class="col-md-4 col-lg-3 col-form-label">LinkedIn Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="linkedin" type="text" class="form-control" id="Linkedin" placeholder="Enter LinkedIn profile URL" value="<?= old('linkedin', $user->linkedin) ?>">
                      </div>
                    </div>

                 

                    <!-- About -->
                    <div class="row mb-3">
                      <label for="about" class="col-md-4 col-lg-3 col-form-label">About</label>
                      <div class="col-md-8 col-lg-9">
                        <textarea name="description" class="form-control" id="about" placeholder="Enter user description or bio" style="height: 100px"><?= old('description', $user->description) ?></textarea>
                      </div>
                    </div>
                    
                    <!-- Status -->
                    <div class="row mb-3">
                      <label for="status" class="col-md-4 col-lg-3 col-form-label">Status <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <select name="status" class="form-select <?= (isset($validation) && $validation->hasError('status')) ? 'is-invalid' : '' ?>" id="status" required>
                          <option value="active" <?= (old('status', $user->status) == 'active') ? 'selected' : '' ?>>Active</option>
                          <option value="inactive" <?= (old('status', $user->status) == 'inactive') ? 'selected' : '' ?>>Inactive</option>
                        </select>
                        <?php if (isset($validation) && $validation->hasError('status')): ?>
                          <div class="invalid-feedback">
                            <?= $validation->getError('status') ?>
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>

                    <div class="text-center d-grid">
                      <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>

                    <!-- Required Fields Note -->
                    <div class="row mt-3">
                      <div class="col-12">
                        <small class="text-muted"><span class="text-danger">*</span> indicates required fields</small>
                      </div>
                    </div>
                  </form><!-- End Profile Edit Form -->

                  <script>
                    $(document).ready(function() {
                      var country_id = $('#country_id').val();
                      var state_id = "<?= $user->state_id; ?>";
                      var city_id = "<?= $user->city_id; ?>";

                      // Load initial states and cities for edit mode
                      if(country_id) {
                        loadUserStates(country_id).then(function() {
                          $('#state_id').val(state_id);
                          if(state_id) {
                            loadUserCities(state_id).then(function() {
                              $('#city_id').val(city_id);
                            });
                          }
                        });
                      }
                    });
                  </script>
                  <script src="<?= base_url('assets/admin_assets/js/modules/user.js'); ?>"></script>

                </div>

              </div><!-- End Bordered Tabs -->

            </div>
          </div>

        </div>
      </div>
    </section>

<?= $this->endSection();?>