<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<?php helper('security'); ?>
<div class="pagetitle">
      <h1>Add User</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?= base_url('administrator'); ?>">Home</a></li>
          <li class="breadcrumb-item"><a href="<?= base_url('administrator/users'); ?>">Users</a></li>
          <li class="breadcrumb-item active">Add User</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <!-- Alerts here !-->
    <?php if(session()->getTempdata('error')):?>
    <div class="alert alert-danger">  <?= session()->getTempdata('error');?></div>
    <?php endif;?>
      <?php if(session()->getTempdata('success')):?>
      <div class="alert alert-success">  <?= session()->getTempdata('success');?></div>
      <?php endif;?>
			<?php if(session()->getTempdata('warning')):?>
      <div class="alert alert-warning">  <?= session()->getTempdata('warning');?></div>
      <?php endif;?>
    </div>
    <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
    <?php endif;?>

    <!-- End of Alerts !-->

    <section class="section profile">
      <div class="row">
        <div class="col-xl-4">

          <div class="card">
            <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">
              <img src="<?= base_url();?>/assets/admin_assets/images/profiler.jpeg" alt="" class="rounded-circle mb-3" width="120px" height="120px">
              <h5>New User</h5>
              <div class="social-links mt-2">
                <a href="#" class="twitter"><i class="bi bi-twitter"></i></a>
                <a href="#" class="facebook"><i class="bi bi-facebook"></i></a>
                <a href="#" class="instagram"><i class="bi bi-instagram"></i></a>
                <a href="#" class="linkedin"><i class="bi bi-linkedin"></i></a>
              </div>
            </div>
          </div>

        </div>

        <div class="col-xl-8">

          <div class="card">
            <div class="card-body pt-3">
              <!-- Bordered Tabs -->
              <ul class="nav nav-tabs nav-tabs-bordered">

                <li class="nav-item">
                  <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#profile-edit">Add User Details</button>
                </li>

              </ul>
              <div class="tab-content pt-2">

                <div class="tab-pane fade show active profile-edit pt-3" id="profile-edit">

                  <!-- Profile Edit Form -->
                  <form method="post" action="<?= base_url('administrator/users/add');?>"  enctype="multipart/form-data">
                    <?= csrf_field(); ?>
                    <div class="row mb-3">
                      <label for="profileImage" class="col-md-4 col-lg-3 col-form-label">Profile Image</label>
                      <div class="col-md-8 col-lg-9">
                        <img src="<?= base_url();?>/assets/admin_assets/images/profiler.jpeg" alt="" class="rounded-circle mb-2" width="100px" height="100px">
                        <div class="pt-2">
                          <input type="file" name="photo" class="form-file" accept="image/jpeg, image/png, image/gif"/>
                        </div>
                      </div>
                    </div>

                    <!-- Full Name Section -->
                    <div class="row mb-3">
                      <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Full Name <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <div class="row">
                          <div class="col">
                            <input name="first_name" type="text" class="form-control <?= (isset($validation) && $validation->hasError('first_name')) ? 'is-invalid' : '' ?>" 
                                   id="firstName" placeholder="Enter first name" value="<?= old('first_name') ?>" required>
                            <?php if (isset($validation) && $validation->hasError('first_name')): ?>
                              <div class="invalid-feedback">
                                <?= $validation->getError('first_name') ?>
                              </div>
                            <?php endif; ?>
                          </div>
                          <div class="col">
                            <input name="last_name" type="text" class="form-control <?= (isset($validation) && $validation->hasError('last_name')) ? 'is-invalid' : '' ?>" 
                                   id="lastName" placeholder="Enter last name" value="<?= old('last_name') ?>" required>
                            <?php if (isset($validation) && $validation->hasError('last_name')): ?>
                              <div class="invalid-feedback">
                                <?= $validation->getError('last_name') ?>
                              </div>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    </div>

                    <!-- Phone -->
                    <div class="row mb-3">
                      <label for="Phone" class="col-md-4 col-lg-3 col-form-label">Phone</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="mobile" type="text" class="form-control" id="Phone" placeholder="Enter phone number" value="<?= old('mobile') ?>">
                      </div>
                    </div>

                    <!-- Email -->
                    <div class="row mb-3">
                      <label for="Email" class="col-md-4 col-lg-3 col-form-label">Email <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <input name="email" type="email" class="form-control <?= (isset($validation) && $validation->hasError('email')) ? 'is-invalid' : '' ?>" 
                              id="Email" placeholder="Enter email address" value="<?= old('email') ?>" required>
                        <?php if (isset($validation) && $validation->hasError('email')): ?>
                          <div class="invalid-feedback">
                            <?= $validation->getError('email') ?>
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>

                    <!-- Password -->
                    <div class="row mb-3">
                      <label for="password" class="col-md-4 col-lg-3 col-form-label">Password <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <input name="password" type="password" class="form-control <?= (isset($validation) && $validation->hasError('password')) ? 'is-invalid' : '' ?>" 
                               id="password" placeholder="Enter password (min. 8 characters)" required>
                        <?php if (isset($validation) && $validation->hasError('password')): ?>
                          <div class="invalid-feedback">
                            <?= $validation->getError('password') ?>
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>

                    <!-- Confirm Password -->
                    <div class="row mb-3">
                      <label for="cpassword" class="col-md-4 col-lg-3 col-form-label">Confirm Password <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <input name="cpass" type="password" class="form-control <?= (isset($validation) && $validation->hasError('cpass')) ? 'is-invalid' : '' ?>" 
                               id="cpassword" placeholder="Re-enter password" required>
                        <?php if (isset($validation) && $validation->hasError('cpass')): ?>
                          <div class="invalid-feedback">
                            <?= $validation->getError('cpass') ?>
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>

                    <!-- Position -->
                    <div class="row mb-3">
                      <label for="Position" class="col-md-4 col-lg-3 col-form-label">Position</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="position" type="text" class="form-control" id="Position" placeholder="Enter job position" value="<?= old('position') ?>">
                      </div>
                    </div>

                    <!-- Department -->
                    <div class="row mb-3">
                      <label for="Department" class="col-md-4 col-lg-3 col-form-label">Department</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="department_id" class="form-select" id="department_id">
                          <option value="">Select Department</option>
                          <?php foreach($departments ?? [] as $department): ?>
                            <option value="<?= $department->id; ?>" <?= old('department_id') == $department->id ? 'selected' : '' ?>>
                              <?= $department->name; ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                    </div>

                    <!-- Admin Role -->
                    <div class="row mb-3">
                      <label for="Group" class="col-md-4 col-lg-3 col-form-label">Admin Role <span class="text-danger">*</span></label>
                      <div class="col-md-8 col-lg-9">
                        <select name="group_id" class="form-select <?= (isset($validation) && $validation->hasError('group_id')) ? 'is-invalid' : '' ?>" id="group_id" required>
                          <option value="">Select Role</option>
                          <?php foreach($user_roles ?? [] as $role): ?>
                            <option value="<?= $role->id; ?>" <?= old('group_id') == $role->id ? 'selected' : '' ?>>
                              <?= $role->name; ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                        <?php if (isset($validation) && $validation->hasError('group_id')): ?>
                          <div class="invalid-feedback">
                            <?= $validation->getError('group_id') ?>
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>

                    <!-- Country -->
                    <div class="row mb-3">
                      <label for="Country" class="col-md-4 col-lg-3 col-form-label">Country</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="country_id" class="form-select" id="country_id">
                          <option value="">Select Country</option>
                          <?php foreach($countries ?? [] as $country): ?>
                            <option value="<?= $country['country_id']; ?>" <?= old('country_id') == $country['country_id'] ? 'selected' : '' ?>>
                              <?= $country['country_name']; ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                    </div>

                    <!-- Address -->
                    <div class="row mb-3">
                      <label for="Address" class="col-md-4 col-lg-3 col-form-label">Address</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="address" type="text" class="form-control" id="Address" placeholder="Enter street address" value="<?= old('address') ?>">
                      </div>
                    </div>

                    <!-- Social Media Profiles -->
                    <div class="row mb-3">
                      <label for="Twitter" class="col-md-4 col-lg-3 col-form-label">Twitter Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="twitter" type="text" class="form-control" id="Twitter" placeholder="Enter Twitter username or profile URL" value="<?= old('twitter') ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Facebook" class="col-md-4 col-lg-3 col-form-label">Facebook Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="facebook" type="text" class="form-control" id="Facebook" placeholder="Enter Facebook profile URL" value="<?= old('facebook') ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Instagram" class="col-md-4 col-lg-3 col-form-label">Instagram Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="instagram" type="text" class="form-control" id="Instagram" placeholder="Enter Instagram username" value="<?= old('instagram') ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Linkedin" class="col-md-4 col-lg-3 col-form-label">LinkedIn Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="linkedin" type="text" class="form-control" id="Linkedin" placeholder="Enter LinkedIn profile URL" value="<?= old('linkedin') ?>">
                      </div>
                    </div>

                    <!-- Description (if you have this field) -->
                    

                    <div class="text-center d-grid">
                      <button type="submit" class="btn btn-primary">Create User Account</button>
                    </div>

                    <!-- Required Fields Note -->
                    <div class="row mt-3">
                      <div class="col-12">
                        <small class="text-muted"><span class="text-danger">*</span> indicates required fields</small>
                      </div>
                    </div>
                  </form><!-- End Profile Edit Form -->

                  <script src="<?= base_url('assets/admin_assets/js/modules/user.js'); ?>"></script>

                </div>

              </div><!-- End Bordered Tabs -->

            </div>
          </div>

        </div>
      </div>
    </section>

<?= $this->endSection();?>