<?= $this->extend('Modules\Admin\Views\index'); ?>

<?= $this->section('content');?>

<style>
  #notif-toast { 
    position: fixed; 
    right: 20px; 
    bottom: 20px; 
    z-index: 99999; 
    min-width: 220px; 
  }
  #notif-toast .toast-body { 
    padding: .75rem 1rem; 
  }
  .switch {
    position: relative;
    display: inline-block;
    width: 50px;
    height: 24px;
  }
  .switch input {
    opacity: 0;
    width: 0;
    height: 0;
  }
  .slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 24px;
  }
  .slider:before {
    position: absolute;
    content: "";
    height: 16px;
    width: 16px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
  }
  input:checked + .slider {
    background-color: #198754;
  }
  input:checked + .slider:before {
    transform: translateX(26px);
  }
</style>

<div class="container-fluid">
  <div class="row mb-md-3 align-items-center">
    <div class="col-auto">
        <h4 class="mb-0">Notifications</h4>
        <nav aria-label="breadcrumb"><small>
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?></li>
            </ol></small>
        </nav>
    </div>
    <div class="col">
      <div class="row gx-2 justify-content-end">
        
        <div class="col-auto">
          <div class="card bg-light mb-0">
            <div class="card-body py-2 px-3">
              <div class="small">Showing</div>
              <div id="card-showing" class="h4 mb-0"><?= $total_notifications ?? 0 ?></div>
            </div>
          </div>
        </div>
        <div class="col-auto">
          <a id="btn-refresh" href="<?= base_url('administrator/notifications') ?>" class="btn btn-outline-secondary">Refresh</a>
        </div>
      </div>
    </div>
  </div>

  <!-- Flash Messages -->
  <div>
    <?php if(session()->getTempdata('error')):?>
      <div class="alert alert-danger"><?= session()->getTempdata('error'); ?></div>
    <?php endif; ?>
    <?php if(session()->getTempdata('success')):?>
      <div class="alert alert-success"><?= session()->getTempdata('success'); ?></div>
    <?php endif; ?>
    <?php if(session()->getTempdata('warning')):?>
      <div class="alert alert-warning"><?= session()->getTempdata('warning'); ?></div>
    <?php endif; ?>
  </div>

  <?php if(isset($validation)): ?>
    <div class="alert alert-danger">
      <?= $validation->listErrors() ?>
    </div>
  <?php endif; ?>

  <!-- Main Content -->
  <div class="row g-4">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <div>
              <strong>Notifications List</strong>
              <div class="small text-muted">Latest notifications for your account</div>
            </div>
            <div class="d-flex gap-2">
              <!-- <button id="markAllRead" class="btn btn-sm btn-outline-primary">Mark all (page) as read</button>
              <button id="markSelectedRead" class="btn btn-sm btn-outline-success">Mark Selected Read</button>
              <button id="markSelectedUnread" class="btn btn-sm btn-outline-warning">Mark Selected Unread</button> -->
              <form id="exportForm" method="GET" action="<?= base_url('administrator/notifications/exportCsv') ?>" target="_blank" class="m-0">
                <input type="hidden" name="type" id="exportType" value="">
                <input type="hidden" name="status" id="exportStatus" value="">
                <input type="hidden" name="from" id="exportFrom" value="">
                <input type="hidden" name="to" id="exportTo" value="">
                <button class="btn btn-sm btn-outline-success" type="submit">Export CSV</button>
              </form>
            </div>
          </div>

          <!-- Filters -->
          <div class="row g-2">
            <div class="col-md-3">
              <label class="form-label small">Type</label>
              <select id="filterType" class="form-select form-select-sm">
                <option value="">All Types</option>
                <?php if (!empty($types)): foreach($types as $t): ?>
                  <?php 
                  $tt = is_object($t) ? $t->notification_type : (is_array($t) ? $t['notification_type'] : $t); 
                  $cnt = is_object($t) ? $t->cnt : (is_array($t) ? $t['cnt'] : 0);
                  $isEmpty = (strlen(trim((string)$tt)) === 0);
                  $label = $isEmpty ? 'Unspecified' : $tt;
                  $val = $isEmpty ? '__unspecified__' : $tt;
                  ?>
                  <option value="<?= esc($val) ?>"><?= esc($label) ?> (<?= intval($cnt) ?>)</option>
                <?php endforeach; endif; ?>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label small">Status</label>
              <select id="filterStatus" class="form-select form-select-sm">
                <option value="">All</option>
                <option value="0">Unread</option>
                <option value="1">Read</option>
              </select>
            </div>
            <div class="col-md-3">
              <label class="form-label small">From</label>
              <input id="filterFrom" type="date" class="form-control form-control-sm">
            </div>
            <div class="col-md-3">
              <label class="form-label small">To</label>
              <input id="filterTo" type="date" class="form-control form-control-sm">
            </div>
            <div class="col-md-1 d-flex align-items-end">
              <button id="resetFilters" class="btn btn-sm btn-outline-secondary w-100">Reset</button>
            </div>
          </div>
        </div>

        <div class="card-body p-0">
          <div class="table-responsive">
            <table id="notification-list" class="table table-hover table-striped table-sm mb-0">
              <thead class="table-light">
                <tr>
                  <th style="width:3%"><input id="selectAll" type="checkbox"></th>
                  <th style="width:18%">Date</th>
                  <th>Message</th>
                  <th style="width:12%">Type</th>
                  <th style="width:10%">Status</th>
                  <th style="width:12%" class="text-end">Action</th>
                </tr>
              </thead>
              <tbody style="font-size: 13px;">
                <!-- DataTable will populate this -->
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>




<!-- Hidden forms for AJAX submissions -->
<form id="bulk-action-form" style="display: none;">
    <?= csrf_field() ?>
    <input type="hidden" name="status" id="bulk-status">
    <!-- Notification IDs will be appended here -->
</form>

<form id="toggle-status-form" style="display: none;">
    <?= csrf_field() ?>
    <input type="hidden" name="id" id="toggle-id">
    <input type="hidden" name="status" id="toggle-status">
</form>

<!-- Modal for viewing notification -->
<div class="modal fade" id="notificationModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Notification Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="notificationModalBody">Loading...</div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Toast container -->
<div id="notif-toast" aria-live="polite" aria-atomic="true"></div>

<script>
$(document).ready(function() {
  // Global variables
  let debounceTimer = null;
  let table_notifications_list = null;
  const base_url = '<?= base_url() ?>';

  // Function to update CSRF token in all forms
  function updateCsrfToken(newHash) {
    if (newHash) {
      $('input[name="<?= csrf_token() ?>"]').val(newHash);
    }
  }

  // Toast function (using toastr library if available, otherwise basic alert)
  function showToast(message, type = 'info') {
      if (typeof toastr !== 'undefined') {
          toastr[type](message);
      } else {
          alert(message);
      }
  }

  // Update export inputs
  function updateExportInputs() {
    $('#exportType').val($('#filterType').val() || '');
    $('#exportStatus').val($('#filterStatus').val() || '');
    $('#exportFrom').val($('#filterFrom').val() || '');
    $('#exportTo').val($('#filterTo').val() || '');
  }

  // Refresh DataTable and cards
  function refreshTable() {
    updateExportInputs();
    if (table_notifications_list) {
      table_notifications_list.ajax.reload(null, false);
    }
  }

  // Initialize DataTable
  function initDataTable() {
    if ($.fn.DataTable.isDataTable('#notification-list')) {
      table_notifications_list = $('#notification-list').DataTable();
      return;
    }

    table_notifications_list = $('#notification-list').DataTable({
      "processing": true,
      "serverSide": false,
      "ajax": {
        "url": base_url + "administrator/notifications/list",
        "type": "GET",
        "data": function(d) {
          return {
            type: $('#filterType').val() || '',
            status: $('#filterStatus').val() || '',
            from: $('#filterFrom').val() || '',
            to: $('#filterTo').val() || '',
            all: 1
          };
        },
        "dataSrc": function (json) {
          if (json && json.success) {
            $('#card-unread').text(json.unread_count || 0);
            $('#card-showing').text(json.total_count || 0);
            updateCsrfToken(json.csrf_hash);
            return json.data || [];
          }
          showToast('Failed to load notifications', 'error');
          return [];
        },
        "error": function(xhr, error, thrown) {
          showToast('Error loading notifications: ' + (xhr.responseJSON?.msg || 'Server error'), 'error');
          if(xhr.responseJSON && xhr.responseJSON.csrf_hash) {
            updateCsrfToken(xhr.responseJSON.csrf_hash);
          }
        }
      },
      "columns": [
        {
          "data": null, "orderable": false,
          "render": (data) => `<input type="checkbox" class="select-row" value="${data.id || ''}">`
        },
        { 
          "data": "created_at",
          "render": function(data) {
            if (!data) return '';
            const date = new Date(data);
            return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric', hour: '2-digit', minute: '2-digit' });
          }
        },
        { "data": "message" },
        { "data": "notification_type", "render": (data) => !data || data.trim() === '' ? 'Unspecified' : data },
        {
          "data": "status",
          "render": (data) => parseInt(data) === 0 ? '<span class="badge bg-danger">Unread</span>' : '<span class="badge bg-secondary">Read</span>'
        },
        {
          "data": null, "orderable": false,
          "render": function (data) {
            const isRead = parseInt(data.status) === 1;
            const statusText = isRead ? 'Mark unread' : 'Mark read';
            const btnClass = isRead ? 'btn-outline-warning' : 'btn-outline-success';
            return `
              <div class="btn-group" role="group">
                <button class="btn btn-sm btn-outline-primary btn-view" data-id="${data.id}">View</button>
                <button class="btn btn-sm ${btnClass} mark-toggle" data-id="${data.id}" data-status="${data.status}">${statusText}</button>
              </div>`;
          }
        }
      ],
      "order": [[1, 'desc']],
      "paging": true, "pageLength": 50, "lengthChange": false, "searching": false, "info": true, "autoWidth": false,
      "drawCallback": function() {
        $('#selectAll').prop('checked', $('.select-row').length > 0 && $('.select-row:checked').length === $('.select-row').length);
      }
    });
  }

  // Event Listeners
  $('#filterType, #filterStatus, #filterFrom, #filterTo').on('change', function() {
    clearTimeout(debounceTimer);
    debounceTimer = setTimeout(refreshTable, 500);
  });

  $('#resetFilters').on('click', function(e) {
    e.preventDefault();
    $('#filterType, #filterStatus, #filterFrom, #filterTo').val('');
    refreshTable();
  });

  $('#selectAll').on('change', function() {
    $('.select-row').prop('checked', this.checked);
  });

  $('#markSelectedRead').on('click', (e) => { e.preventDefault(); bulkMark(1); });
  $('#markSelectedUnread').on('click', (e) => { e.preventDefault(); bulkMark(0); });

  $('#markAllRead').on('click', function(e) {
    e.preventDefault();
    if (!table_notifications_list) return showToast('DataTable not initialized', 'error');
    const ids = table_notifications_list.rows({ search: 'applied' }).data().toArray().map(row => row.id);
    if (ids.length === 0) return showToast('No notifications to mark', 'warning');
    bulkMark(1, ids);
  });

  // Bulk mark function
  function bulkMark(status, specificIds = null) {
    let ids = specificIds || $('.select-row:checked').map((i, el) => el.value).get();
    if (!ids.length) return showToast('No notifications selected', 'warning');

    // Clear previous IDs and add new ones
    $('#bulk-action-form input[name="ids[]"]').remove();
    ids.forEach(id => {
        $('<input>').attr({ type: 'hidden', name: 'ids[]', value: id }).appendTo('#bulk-action-form');
    });
    $('#bulk-status').val(status);

    $.ajax({
      url: base_url + 'administrator/notifications/mark-bulk',
      type: 'POST',
      data: new FormData($('#bulk-action-form')[0]),
      processData: false,
      contentType: false,
      headers: {'X-Requested-With': 'XMLHttpRequest'},
      success: function(data) {
        updateCsrfToken(data.csrf_hash);
        if (data.success) {
          showToast(data.msg || 'Operation successful', 'success');
          refreshTable();
        } else {
          showToast(data.msg || 'Operation failed', 'error');
        }
      },
      error: function(xhr) {
        updateCsrfToken(xhr.responseJSON?.csrf_hash);
        showToast(xhr.responseJSON?.msg || 'An error occurred', 'error');
      }
    });
  }

  // Event delegation for dynamic elements
  $('#notification-list tbody').on('click', '.btn-view', function(e) {
      e.preventDefault();
      viewNotification($(this).data('id'));
  });

  $('#notification-list tbody').on('click', '.mark-toggle', function(e) {
      e.preventDefault();
      const id = $(this).data('id');
      const newStatus = parseInt($(this).data('status')) === 1 ? 0 : 1;
      toggleNotificationStatus(id, newStatus);
  });

  // View notification details
  function viewNotification(id) {
    $.ajax({
        url: base_url + 'administrator/notifications/view/' + id,
        type: 'GET',
        headers: {'X-Requested-With': 'XMLHttpRequest'},
        success: function(data) {
            updateCsrfToken(data.csrf_hash);
            if (data.success) {
                const n = data.data;
                $('#notificationModalBody').html(`
                    <p><strong>Message:</strong></p><p class="mb-3">${n.message || ''}</p><hr>
                    <p><strong>Type:</strong> ${n.notification_type || 'Unspecified'}</p>
                    <p><strong>Status:</strong> ${n.status == 0 ? 'Unread' : 'Read'}</p>
                    <p><small class="text-muted">Created: ${new Date(n.created_at).toLocaleString()}</small></p>
                `);
                new bootstrap.Modal($('#notificationModal')[0]).show();
            } else {
                showToast(data.msg || 'Unable to load notification', 'error');
            }
        },
        error: function(xhr) {
            updateCsrfToken(xhr.responseJSON?.csrf_hash);
            showToast(xhr.responseJSON?.msg || 'Request failed', 'error');
        }
    });
  }

  // Toggle notification status
  function toggleNotificationStatus(id, status) {
    $('#toggle-id').val(id);
    $('#toggle-status').val(status);

    $.ajax({
      url: base_url + 'administrator/notifications/status/' + id,
      type: 'POST',
      data: new FormData($('#toggle-status-form')[0]),
      processData: false,
      contentType: false,
      headers: {'X-Requested-With': 'XMLHttpRequest'},
      success: function(data) {
        updateCsrfToken(data.csrf_hash);
        if (data.success) {
          showToast(data.msg || 'Status updated', 'success');
          refreshTable();
        } else {
          showToast(data.msg || 'Update failed', 'error');
        }
      },
      error: function(xhr) {
        updateCsrfToken(xhr.responseJSON?.csrf_hash);
        showToast(xhr.responseJSON?.msg || 'An error occurred', 'error');
      }
    });
  }

  // Initialize everything
  initDataTable();
});
</script>

<?= $this->endSection() ?>