<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>

<div class="pagetitle">
      <h1>Profile</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?= base_url('administrator'); ?>">Home</a></li>
          <li class="breadcrumb-item">Users</li>
          <li class="breadcrumb-item active">Profile</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <?php if(session()->getTempdata('success')): ?>
        <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
    <?php endif;?>
    <?php if(session()->getTempdata('error')): ?>
        <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
    <?php endif;?>
    <?php if(isset($validation)): ?>
        <div class="alert alert-danger">
    <?= $validation->listErrors()?>
    </div>
    <?php endif;?>

    <section class="section profile">
      <div class="row">
        <div class="col-xl-4">

          <div class="card">
            <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">

              <img src="<?= base_url() ?>/assets/admin_assets/img/profile-img.jpg" alt="Profile" class="rounded-circle">
              <h2><?= $user->first_name; ?> <?= $user->last_name; ?></h2>
              <h3><?= $user->position; ?></h3>
              <div class="social-links mt-2">
                <a href="<?= $user->twitter; ?>" class="twitter"><i class="bi bi-twitter"></i></a>
                <a href="<?= $user->facebook; ?>" class="facebook"><i class="bi bi-facebook"></i></a>
                <a href="<?= $user->instagram; ?>" class="instagram"><i class="bi bi-instagram"></i></a>
                <a href="<?= $user->linkedin; ?>" class="linkedin"><i class="bi bi-linkedin"></i></a>
              </div>
            </div>
          </div>

        </div>

        <div class="col-xl-8">

          <div class="card">
            <div class="card-body pt-3">
              <!-- Bordered Tabs -->
              <ul class="nav nav-tabs nav-tabs-bordered">

                <li class="nav-item">
                  <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#profile-overview">Overview</button>
                </li>

                <li class="nav-item">
                  <button class="nav-link" data-bs-toggle="tab" data-bs-target="#profile-edit">Edit Profile</button>
                </li>

                <li class="nav-item">
                  <button class="nav-link" data-bs-toggle="tab" data-bs-target="#profile-change-password">Change Password</button>
                </li>

              </ul>
              <div class="tab-content pt-2">

                <div class="tab-pane fade show active profile-overview" id="profile-overview">
                  <h5 class="card-title">About</h5>
                  <p class="small fst-italic"><?= $user->description; ?></p>

                  <h5 class="card-title">Profile Details</h5>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label ">Full Name</div>
                    <div class="col-lg-9 col-md-8"><?= $user->first_name; ?> <?= $user->last_name; ?></div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Department</div>
                    <div class="col-lg-9 col-md-8"><?= $user->department_name; ?></div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Position</div>
                    <div class="col-lg-9 col-md-8"><?= $user->position; ?></div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Country</div>
                    <div class="col-lg-9 col-md-8"><?= $user->country_name; ?></div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Address</div>
                    <div class="col-lg-9 col-md-8"><?= $user->address; ?></div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Phone</div>
                    <div class="col-lg-9 col-md-8"><?= $user->mobile; ?></div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Email</div>
                    <div class="col-lg-9 col-md-8"><?= $user->email; ?></div>
                  </div>

                </div>

                <div class="tab-pane fade profile-edit pt-3" id="profile-edit">

                  <!-- Profile Edit Form -->
                  <form method="post" action="<?= base_url('administrator/profile');?>">
                    <?= csrf_field() ?>
                    <div class="row mb-3">
                      <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Full Name</label>
                      <div class="col-md-8 col-lg-9">
                        <div class="row">
                          <div class="col"> <input name="first_name" type="text" class="form-control" id="firstName" value="<?= $user->first_name; ?>"></div>
                          <div class="col"><input name="last_name" type="text" class="form-control" id="lastName" value="<?= $user->last_name; ?>"></div>
                        </div>
                      </div>
                    </div>
                    <div class="row mb-3">
                      <label for="Phone" class="col-md-4 col-lg-3 col-form-label">Phone</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="mobile" type="text" class="form-control" id="Phone" value="<?= $user->mobile; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Email" class="col-md-4 col-lg-3 col-form-label">Email</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="email" type="email" class="form-control" id="Email" value="<?= $user->email; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Position" class="col-md-4 col-lg-3 col-form-label">Position</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="position" type="text" class="form-control" id="Position" value="<?= $user->position; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Department" class="col-md-4 col-lg-3 col-form-label">Department</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="department_id" class="form-select" id="department_id">
                          <option value="">Select Department</option>
                          <?php foreach($departments ?? [] as $department): ?>
                            <option value="<?= $department->id; ?>" <?php if($user->department_id == $department->id) echo "selected"; ?>>
                              <?= $department->name; ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Country" class="col-md-4 col-lg-3 col-form-label">Country</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="country_id" class="form-select" id="country_id">
                          <option value="">Select Country</option>
                          <?php foreach($countries ?? [] as $country): ?>
                            <option value="<?= $country['country_id']; ?>" <?php if($user->country_id == $country['country_id']) echo "selected"; ?>>
                              <?= $country['country_name']; ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                    </div>

                    <!-- <div class="row mb-3">
                      <label for="State" class="col-md-4 col-lg-3 col-form-label">State</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="state_id" class="form-select" id="state_id">
                          <option value="">Select State</option>
                        </select>
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="City" class="col-md-4 col-lg-3 col-form-label">City</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="city_id" class="form-select" id="city_id">
                          <option value="">Select City</option>
                        </select>
                      </div>
                    </div> -->

                    <div class="row mb-3">
                      <label for="Address" class="col-md-4 col-lg-3 col-form-label">Address</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="address" type="text" class="form-control" id="Address" value="<?= $user->address; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Twitter" class="col-md-4 col-lg-3 col-form-label">Twitter Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="twitter" type="text" class="form-control" id="Twitter" value="<?= $user->twitter; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Facebook" class="col-md-4 col-lg-3 col-form-label">Facebook Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="facebook" type="text" class="form-control" id="Facebook" value="<?= $user->facebook; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Instagram" class="col-md-4 col-lg-3 col-form-label">Instagram Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="instagram" type="text" class="form-control" id="Instagram" value="<?= $user->instagram; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Linkedin" class="col-md-4 col-lg-3 col-form-label">Linkedin Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="linkedin" type="text" class="form-control" id="Linkedin" value="<?= $user->linkedin; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="about" class="col-md-4 col-lg-3 col-form-label">About</label>
                      <div class="col-md-8 col-lg-9">
                        <textarea name="description" class="form-control" id="about" style="height: 100px"><?= $user->description; ?></textarea>
                      </div>
                    </div>

                    <div class="text-center">
                      <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                  </form><!-- End Profile Edit Form -->

                </div>

                <div class="tab-pane fade pt-3" id="profile-change-password">
                  <!-- Change Password Form -->
                  <form method="post" action="<?= base_url('administrator/changePassword') ?>">
                    <?= csrf_field() ?>
                    <div class="row mb-3">
                      <label for="currentPassword" class="col-md-4 col-lg-3 col-form-label">Current Password</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="password" type="password" class="form-control" id="currentPassword">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="newPassword" class="col-md-4 col-lg-3 col-form-label">New Password</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="new_password" type="password" class="form-control" id="newPassword">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="renewPassword" class="col-md-4 col-lg-3 col-form-label">Re-enter New Password</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="renew_password" type="password" class="form-control" id="renewPassword">
                      </div>
                    </div>

                    <div class="text-center">
                      <button type="submit" class="btn btn-primary">Change Password</button>
                    </div>
                  </form><!-- End Change Password Form -->

                </div>

              </div><!-- End Bordered Tabs -->

            </div>
          </div>

        </div>
      </div>
    </section>
    <script>
        $(document).ready(function() {
            var country_id = $('#country_id').val();
            var state_id = "<?= $user->state_id; ?>";
            var city_id = "<?= $user->city_id; ?>";

            if(country_id) {
                $.ajax({
                url: '<?= base_url('get-states/') ?>' + country_id,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#state_id').html('<option value="">Select State</option>');
                    $.each(data, function(key, value) {
                    $('#state_id').append('<option value="' + value.id + '"' + (value.id == state_id ? ' selected' : '') + '>' + value.name + '</option>');
                    });
                    $('#state_id').trigger('change');
                }
                });
            }

            if(state_id) {
                $.ajax({
                url: '<?= base_url('get-cities/') ?>' + state_id,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#city_id').html('<option value="">Select City</option>');
                    $.each(data, function(key, value) {
                    $('#city_id').append('<option value="' + value.id + '"' + (value.id == city_id ? ' selected' : '') + '>' + value.name + '</option>');
                    });
                }
                });
            }


            $('#country_id').change(function() {
            var country_id = $(this).val();
            if(country_id) {
                $.ajax({
                url: '<?= base_url('get-states/') ?>' + country_id,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#state_id').html('<option value="">Select State</option>');
                    $('#city_id').html('<option value="">Select City</option>');
                    $.each(data, function(key, value) {
                    $('#state_id').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
                });
            } else {
                $('#state_id').html('<option value="">Select State</option>');
                $('#city_id').html('<option value="">Select City</option>');
            }
            });

            $('#state_id').change(function() {
            var state_id = $(this).val();
            if(state_id) {
                $.ajax({
                url: '<?= base_url('get-cities/') ?>' + state_id,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#city_id').html('<option value="">Select City</option>');
                    $.each(data, function(key, value) {
                    $('#city_id').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
                });
            } else {
                $('#city_id').html('<option value="">Select City</option>');
            }
            });
        });
    </script>
<?= $this->endSection();?>
