<div class="wrapper-container">
    <style>
    /* Inline notification styles (keeps styling local to header to avoid external conflicts) */
    .notifications-dropdown, .messages-dropdown {
        background-color: #ffffff !important;
        color: #0b2a66 !important; /* deep blue text */
        box-shadow: 0 8px 20px rgba(11,42,102,0.08) !important;
        border-radius: 8px !important;
        width: 380px !important;
        max-height: 480px !important;
        overflow-y: auto !important;
        z-index: 2000 !important;
    }
    .notifications-dropdown .dropdown-header, .messages-dropdown .dropdown-header {
        background: linear-gradient(90deg,#e6f4ff,#dff0ff) !important;
        color: #0b5ed7 !important; /* bootstrap primary */
        font-weight: 700 !important;
        padding: .6rem 1rem !important;
    }
    .notifications-dropdown .dropdown-item, .messages-dropdown .dropdown-item {
        background: #ffffff !important;
        color: #0b2a66 !important;
        padding: .5rem .75rem !important;
        display: flex !important;
        justify-content: space-between !important;
        align-items: flex-start !important;
    }
    .notifications-dropdown .dropdown-item:hover, .messages-dropdown .dropdown-item:hover {
        background: #f4fbff !important;
    }
    .notifications-dropdown .small.text-muted, .messages-dropdown .small.text-muted {
        color: #6c757d !important;
        font-size: .75rem !important;
    }
    .badge-number {
        font-size: .65rem !important;
    }
    </style>
      <!-- ========= For all Alerts and Notifications ===== !-->
  <script>
        <?php if(session()->getFlashdata('success')){ ?>
            toastr.success("<?= session()->getFlashdata('success'); ?>");
        <?php }else if(session()->getFlashdata('error')){  ?>
            toastr.error("<?= session()->getFlashdata('error'); ?>");
        <?php }else if(session()->getFlashdata('warning')){  ?>
            toastr.warning("<?= session()->getFlashdata('warning'); ?>");
        <?php }else if(session()->getFlashdata('info')){  ?>
            toastr.info("<?= session()->getFlashdata('info'); ?>");
        <?php } ?>

        // Function to toggle notifications dropdown
        function toggleNotificationsDropdown() {
            var dropdown = document.getElementById('notificationsDropdown');
            dropdown.classList.toggle('show');
        }

        // Function to toggle messages dropdown
        function toggleMessagesDropdown() {
            var dropdown = document.getElementById('messagesDropdown');
            dropdown.classList.toggle('show');
        }

        // Close dropdowns when clicking outside
        document.addEventListener('click', function(event) {
            var notificationsDropdown = document.getElementById('notificationsDropdown');
            var messagesDropdown = document.getElementById('messagesDropdown');
            var notificationsIcon = event.target.closest('.nav-item.dropdown');
            var messagesIcon = event.target.closest('.nav-item.dropdown');

            if (!notificationsIcon || !notificationsIcon.querySelector('#notificationsDropdown')) {
                notificationsDropdown.classList.remove('show');
            }
            if (!messagesIcon || !messagesIcon.querySelector('#messagesDropdown')) {
                messagesDropdown.classList.remove('show');
            }
        });
  </script>
<header class="header">
    <div class="mx-3 d-flex bd-highlight">
        <div class="bd-highlight align-self-center "><a class="btn me-3" onclick="toggleSidebar()"><i class="bi bi-justify-left fs-4"></i></a>
     </div>
        <div class="flex-grow-1 bd-highlight align-self-center">
            <div class="mx-3 d-flex bd-highlight">
            <div class="bd-highlight me-5 d-none d-md-block">
            <!-- Breadcrumb !-->
            <nav aria-label="breadcrumb"><small>
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item active text-white" aria-current="page"><?= esc($bcrumb ?? $title ?? 'Home') ?> </li>
            </ol></small>
            </nav>
            </div>
            <div class="bd-highlight">
            <span class="badge bg-warning display-5 fs-6 bg-opacity-75"><?= esc($title) ?> </span>
            </div>
            </div>
            <!-- End Breadcrumb !-->
        </div>
        <div class="bd-highlight d-none d-md-block">
            <ul class="nav">
            <li class="nav-item align-self-center dropdown">
            <a class="nav-link nav-icon position-relative align-items-center mt-2" href="#" onclick="toggleNotificationsDropdown()"> <i class="bi bi-bell"></i> <small><span class="position-absolute translate-middle badge rounded-pill bg-danger badge-number"><?= count($notifications ?? []) > 9 ? '9+' : count($notifications ?? []) ?></span></small>
            </a>
            <ul class="dropdown-menu dropdown-menu-end notifications-dropdown" id="notificationsDropdown">
                <li class="dropdown-header">Notifications</li>
                <?php if (!empty($notifications)): ?>
                    <?php foreach (array_slice($notifications, 0, 5) as $notification): ?>
                        <?php $nid = is_array($notification) ? ($notification['id'] ?? '') : ($notification->id ?? ''); ?>
                        <?php $nmsg = is_array($notification) ? ($notification['message'] ?? '') : ($notification->message ?? ''); ?>
                        <?php $ndate = is_array($notification) ? ($notification['created_at'] ?? '') : ($notification->created_at ?? ''); ?>
                        <li>
                            <a class="dropdown-item d-flex justify-content-between align-items-start" href="<?= base_url('administrator/notifications') ?>" data-notification-id="<?= $nid ?>" onclick="event.preventDefault(); window.location='<?= base_url('administrator/notifications') ?>';">
                                <div class="me-2">
                                    <div class="small fw-bold text-truncate" style="max-width:220px"><?= esc(mb_substr($nmsg, 0, 80, 'UTF-8')) ?><?= mb_strlen($nmsg, 'UTF-8') > 80 ? '...' : '' ?></div>
                                    <div class="small text-muted"><?= $ndate ? date('M d, H:i', strtotime($ndate)) : '' ?></div>
                                </div>
                                <span class="badge bg-danger rounded-pill">New</span>
                            </a>
                        </li>
                    <?php endforeach; ?>
                <?php else: ?>
                    <li><a class="dropdown-item">No new notifications</a></li>
                <?php endif; ?>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item text-center" href="<?= base_url('administrator/notifications') ?>">View All</a></li>
            </ul>
            </li>
            <li class="nav-item dropdown">
            <a class="nav-link nav-icon position-relative align-items-center mt-2" href="#" onclick="toggleMessagesDropdown()"> <i class="bi bi-chat-left-text"></i> <span class="position-absolute translate-middle badge rounded-pill bg-success badge-number"><?= isset($messages_count) ? (intval($messages_count) > 9 ? '9+' : intval($messages_count)) : (count($messages ?? []) > 9 ? '9+' : count($messages ?? [])) ?></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end messages-dropdown" id="messagesDropdown" style="width: 320px; max-height: 420px; overflow-y: auto;">
                <li class="dropdown-header">Messages</li>
                <?php if (!empty($messages)): ?>
                    <?php foreach (array_slice($messages, 0, 5) as $message): ?>
                        <?php $mid = is_object($message) ? ($message->id ?? '') : ($message['id'] ?? ''); ?>
                        <?php $mtext = is_object($message) ? ($message->message ?? '') : ($message['message'] ?? ''); ?>
                        <?php $mdate = is_object($message) ? ($message->created_at ?? '') : ($message['created_at'] ?? ''); ?>
                        <li>
                            <a class="dropdown-item d-flex justify-content-between align-items-start" href="<?= base_url('administrator/feedback/edit/') ?><?= $mid ?>" data-message-id="<?= $mid ?>" onclick="event.preventDefault(); openFeedbackModal(<?= $mid ?>);">
                                <div class="me-2">
                                    <div class="small fw-bold text-truncate" style="max-width:220px"><?= esc(mb_substr($mtext, 0, 80, 'UTF-8')) ?><?= mb_strlen($mtext, 'UTF-8') > 80 ? '...' : '' ?></div>
                                    <div class="small text-muted"><?= $mdate ? date('M d, H:i', strtotime($mdate)) : '' ?></div>
                                </div>
                                <span class="badge bg-success rounded-pill">New</span>
                            </a>
                        </li>
                    <?php endforeach; ?>
                <?php else: ?>
                    <li><a class="dropdown-item">No new messages</a></li>
                <?php endif; ?>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item text-center" href="<?= base_url('administrator/feedback'); ?>">View All</a></li>
            </ul>
            </li></ul>
        </div>
        <div class="bd-highlight">
            <!-- User Login/Logout Area !-->
            <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
                <?php if($userdata && $userdata->photo):?>
                    <img src="<?= base_url('/media/files/').'/'.$userdata->photo; ?>" alt="Profile" class="rounded-circle" style="width: 30px; height: 30px">
                <?php else:?>
                <img src="<?= base_url()?>/assets/admin_assets/images/profiler.jpeg" alt="Profile" class="rounded-circle" style="width: 30px; height: 30px">
                <?php endif;?>
                <span class="d-none d-md-block dropdown-toggle ps-2"><small><?= $userdata ? $userdata->first_name : 'User';?></small></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile text-dark">
                <li class="dropdown-header"><h6><?= $userdata ? $userdata->first_name.' '.$userdata->last_name : 'User';?></h6> <span>Web Designer</span></li>
                <li><hr class="dropdown-divider"></li><li> <a class="dropdown-item d-flex align-items-center" href="<?= base_url('administrator/profile');?>"> <i class="bi bi-person me-2"></i> <span>My Profile</span> </a></li>
                <!--<li><hr class="dropdown-divider"></li><li> <a class="dropdown-item d-flex align-items-center" href="#"> <i class="bi bi-gear me-2"></i> <span>Account Settings</span> </a></li>
                <li><hr class="dropdown-divider"></li> !-->
                <!--<li> <a class="dropdown-item d-flex align-items-center" href="#"> <i class="bi bi-question-circle me-2"></i> <span>Need Help?</span> </a></li><li><hr class="dropdown-divider"></li>!-->
                <li> <a class="dropdown-item d-flex align-items-center" href="<?= base_url('logout');?>"> <i class="bi bi-box-arrow-right me-2"></i> <span>Sign Out</span> </a></li>
            </ul>
            <!-- END User login/logout !-->
        </div>
    </div>
</header>
